/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import com.mojang.logging.LogUtils;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;

public class PortalExtension {
    private static final Logger LOGGER = LogUtils.getLogger();
    public double motionAffinity = 0.0;
    public boolean adjustPositionAfterTeleport = true;
    public boolean bindCluster = true;
    @Nullable
    public UUID reversePortalId;
    @Nullable
    public UUID flippedPortalId;
    @Nullable
    public UUID parallelPortalId;
    @Nullable
    public Portal reversePortal;
    @Nullable
    public Portal flippedPortal;
    @Nullable
    public Portal parallelPortal;

    public static PortalExtension get(Portal portal) {
        if (portal.extension == null) {
            portal.extension = new PortalExtension();
        }
        return portal.extension;
    }

    public static void init() {
        Portal.clientPortalTickSignal.connect(portal -> PortalExtension.get(portal).tick((Portal)portal));
        Portal.serverPortalTickSignal.connect(portal -> PortalExtension.get(portal).tick((Portal)portal));
        Portal.readPortalDataSignal.connect((portal, tag) -> PortalExtension.get(portal).readFromNbt((class_2487)tag));
        Portal.writePortalDataSignal.connect((portal, tag) -> PortalExtension.get(portal).writeToNbt((class_2487)tag));
    }

    private void readFromNbt(class_2487 compoundTag) {
        this.motionAffinity = compoundTag.method_10545("motionAffinity") ? compoundTag.method_10574("motionAffinity") : 0.0;
        this.adjustPositionAfterTeleport = compoundTag.method_10545("adjustPositionAfterTeleport") ? compoundTag.method_10577("adjustPositionAfterTeleport") : true;
        this.bindCluster = compoundTag.method_10545("bindCluster") ? compoundTag.method_10577("bindCluster") : true;
        this.reversePortalId = compoundTag.method_25928("reversePortalId") ? compoundTag.method_25926("reversePortalId") : null;
        this.flippedPortalId = compoundTag.method_25928("flippedPortalId") ? compoundTag.method_25926("flippedPortalId") : null;
        this.parallelPortalId = compoundTag.method_25928("parallelPortalId") ? compoundTag.method_25926("parallelPortalId") : null;
    }

    private void writeToNbt(class_2487 compoundTag) {
        if (this.motionAffinity != 0.0) {
            compoundTag.method_10549("motionAffinity", this.motionAffinity);
        }
        compoundTag.method_10556("adjustPositionAfterTeleport", this.adjustPositionAfterTeleport);
        compoundTag.method_10556("bindCluster", this.bindCluster);
        if (this.reversePortalId != null) {
            compoundTag.method_25927("reversePortalId", this.reversePortalId);
        }
        if (this.flippedPortalId != null) {
            compoundTag.method_25927("flippedPortalId", this.flippedPortalId);
        }
        if (this.parallelPortalId != null) {
            compoundTag.method_25927("parallelPortalId", this.parallelPortalId);
        }
    }

    private void tick(Portal portal) {
        if (portal.method_37908().method_8608()) {
            this.updateClusterStatusClient(portal);
        } else {
            this.updateClusterStatusServer(portal);
        }
    }

    private void updateClusterStatusServer(Portal portal) {
        if (portal instanceof Mirror) {
            return;
        }
        boolean needsUpdate = false;
        if (this.bindCluster) {
            Portal p;
            class_1297 e;
            if (this.flippedPortal != null && this.flippedPortal.method_31481()) {
                this.flippedPortal = null;
            }
            if (this.reversePortal != null && this.reversePortal.method_31481()) {
                this.reversePortal = null;
            }
            if (this.parallelPortal != null && this.parallelPortal.method_31481()) {
                this.parallelPortal = null;
            }
            if (this.flippedPortalId != null && this.flippedPortal == null) {
                e = (class_1297)((IEWorld)portal.method_37908()).portal_getEntityLookup().method_31808(this.flippedPortalId);
                if (e instanceof Portal) {
                    this.flippedPortal = p = (Portal)e;
                } else {
                    this.flippedPortalId = null;
                    needsUpdate = true;
                }
            }
            if (this.flippedPortalId == null) {
                this.flippedPortal = PortalManipulation.findFlippedPortal(portal);
                if (this.flippedPortal != null) {
                    this.flippedPortalId = this.flippedPortal.method_5667();
                    needsUpdate = true;
                }
            }
            if (this.reversePortalId != null && this.reversePortal == null) {
                e = (class_1297)((IEWorld)portal.getDestWorld()).portal_getEntityLookup().method_31808(this.reversePortalId);
                if (e instanceof Portal) {
                    this.reversePortal = p = (Portal)e;
                } else if (portal.isOtherSideChunkLoaded()) {
                    LOGGER.info("portal linking break {}", (Object)portal);
                    this.reversePortalId = null;
                    needsUpdate = true;
                }
            }
            if (this.reversePortalId == null) {
                this.reversePortal = PortalManipulation.findReversePortal(portal);
                if (this.reversePortal != null) {
                    this.reversePortalId = this.reversePortal.method_5667();
                    needsUpdate = true;
                }
            }
            if (this.parallelPortalId != null && this.parallelPortal == null) {
                e = (class_1297)((IEWorld)portal.getDestWorld()).portal_getEntityLookup().method_31808(this.parallelPortalId);
                if (e instanceof Portal) {
                    this.parallelPortal = p = (Portal)e;
                } else if (portal.isOtherSideChunkLoaded()) {
                    LOGGER.info("portal linking break {}", (Object)portal);
                    this.parallelPortalId = null;
                    needsUpdate = true;
                }
            }
            if (this.parallelPortalId == null) {
                this.parallelPortal = PortalManipulation.findParallelPortal(portal);
                if (this.parallelPortal != null) {
                    this.parallelPortalId = this.parallelPortal.method_5667();
                    needsUpdate = true;
                }
            }
        } else {
            this.flippedPortal = null;
            this.reversePortal = null;
            this.parallelPortal = null;
            this.flippedPortalId = null;
            this.reversePortalId = null;
            this.parallelPortalId = null;
        }
        if (this.flippedPortal != null) {
            PortalExtension.get((Portal)this.flippedPortal).bindCluster = true;
        }
        if (this.reversePortal != null) {
            PortalExtension.get((Portal)this.reversePortal).bindCluster = true;
        }
        if (this.parallelPortal != null) {
            PortalExtension.get((Portal)this.parallelPortal).bindCluster = true;
        }
        if (this.flippedPortal == portal) {
            this.flippedPortal = null;
            this.flippedPortalId = null;
            needsUpdate = true;
        }
        if (this.reversePortal == portal) {
            this.reversePortal = null;
            this.reversePortalId = null;
            needsUpdate = true;
        }
        if (this.parallelPortal == portal) {
            this.parallelPortal = null;
            this.parallelPortalId = null;
            needsUpdate = true;
        }
        if (needsUpdate) {
            portal.reloadAndSyncToClient();
        }
    }

    private void updateClusterStatusClient(Portal portal) {
        if (this.bindCluster) {
            Portal p;
            class_1297 e;
            if (this.flippedPortalId != null) {
                e = (class_1297)((IEWorld)portal.method_37908()).portal_getEntityLookup().method_31808(this.flippedPortalId);
                if (e instanceof Portal) {
                    this.flippedPortal = p = (Portal)e;
                }
            } else {
                this.flippedPortal = null;
            }
            if (this.reversePortalId != null) {
                e = (class_1297)((IEWorld)portal.getDestWorld()).portal_getEntityLookup().method_31808(this.reversePortalId);
                if (e instanceof Portal) {
                    this.reversePortal = p = (Portal)e;
                }
            } else {
                this.reversePortal = null;
            }
            if (this.parallelPortalId != null) {
                e = (class_1297)((IEWorld)portal.getDestWorld()).portal_getEntityLookup().method_31808(this.parallelPortalId);
                if (e instanceof Portal) {
                    this.parallelPortal = p = (Portal)e;
                }
            } else {
                this.parallelPortal = null;
            }
        } else {
            this.flippedPortal = null;
            this.reversePortal = null;
            this.parallelPortal = null;
        }
    }

    public void rectifyClusterPortals(Portal portal, boolean sync) {
        portal.animation.defaultAnimation.inverseScale = false;
        if (this.flippedPortal != null) {
            this.flippedPortal = ServerTeleportationManager.teleportRegularEntityTo(this.flippedPortal, (class_5321<class_1937>)portal.method_37908().method_27983(), portal.getOriginPos());
            this.flippedPortal.dimensionTo = portal.dimensionTo;
            this.flippedPortal.setOriginPos(portal.getOriginPos());
            this.flippedPortal.setDestination(portal.getDestPos());
            this.flippedPortal.axisW = portal.axisW.method_1021(-1.0);
            this.flippedPortal.axisH = portal.axisH;
            this.flippedPortal.scaling = portal.scaling;
            this.flippedPortal.rotation = portal.rotation;
            this.flippedPortal.width = portal.width;
            this.flippedPortal.height = portal.height;
            PortalManipulation.copyAdditionalProperties(this.flippedPortal, portal, false);
            this.flippedPortal.animation.defaultAnimation.inverseScale = false;
            this.flippedPortal.specialShape = portal.specialShape != null ? portal.specialShape.getFlippedWithScaling(1.0) : null;
            if (sync) {
                this.flippedPortal.reloadAndSyncToClientNextTick();
            }
        }
        if (this.reversePortal != null) {
            this.reversePortal = ServerTeleportationManager.teleportRegularEntityTo(this.reversePortal, portal.getDestDim(), portal.getDestPos());
            this.reversePortalId = this.reversePortal.method_5667();
            this.reversePortal.dimensionTo = portal.getOriginDim();
            this.reversePortal.setOriginPos(portal.getDestPos());
            this.reversePortal.setDestination(portal.getOriginPos());
            this.reversePortal.axisW = portal.transformLocalVecNonScale(portal.axisW.method_1021(-1.0));
            this.reversePortal.axisH = portal.transformLocalVecNonScale(portal.axisH);
            this.reversePortal.scaling = 1.0 / portal.scaling;
            this.reversePortal.rotation = portal.rotation != null ? portal.rotation.getConjugated() : null;
            this.reversePortal.width = portal.width * portal.getScale();
            this.reversePortal.height = portal.height * portal.getScale();
            PortalManipulation.copyAdditionalProperties(this.reversePortal, portal, false);
            this.reversePortal.animation.defaultAnimation.inverseScale = true;
            this.reversePortal.specialShape = portal.specialShape != null ? portal.specialShape.getFlippedWithScaling(1.0) : null;
            if (sync) {
                this.reversePortal.reloadAndSyncToClientNextTick();
            }
        }
        if (this.parallelPortal != null) {
            this.parallelPortal = ServerTeleportationManager.teleportRegularEntityTo(this.parallelPortal, portal.getDestDim(), portal.getDestPos());
            this.parallelPortalId = this.parallelPortal.method_5667();
            this.parallelPortal.dimensionTo = portal.getOriginDim();
            this.parallelPortal.setOriginPos(portal.getDestPos());
            this.parallelPortal.setDestination(portal.getOriginPos());
            this.parallelPortal.axisW = portal.transformLocalVecNonScale(portal.axisW);
            this.parallelPortal.axisH = portal.transformLocalVecNonScale(portal.axisH);
            this.parallelPortal.scaling = 1.0 / portal.scaling;
            this.parallelPortal.rotation = portal.rotation != null ? portal.rotation.getConjugated() : null;
            this.parallelPortal.width = portal.width * portal.getScale();
            this.parallelPortal.height = portal.height * portal.getScale();
            PortalManipulation.copyAdditionalProperties(this.parallelPortal, portal, false);
            this.parallelPortal.animation.defaultAnimation.inverseScale = true;
            this.parallelPortal.specialShape = portal.specialShape;
            if (sync) {
                this.parallelPortal.reloadAndSyncToClientNextTick();
            }
        }
    }

    public static void initializeClusterBind(Portal f1, Portal f2, Portal t1, Portal t2) {
        PortalExtension.get((Portal)f1).bindCluster = true;
        PortalExtension.get((Portal)f2).bindCluster = true;
        PortalExtension.get((Portal)t1).bindCluster = true;
        PortalExtension.get((Portal)t2).bindCluster = true;
        PortalExtension.get((Portal)f1).flippedPortalId = f2.method_5667();
        PortalExtension.get((Portal)f2).flippedPortalId = f1.method_5667();
        PortalExtension.get((Portal)t1).flippedPortalId = t2.method_5667();
        PortalExtension.get((Portal)t2).flippedPortalId = t1.method_5667();
        PortalExtension.get((Portal)f1).reversePortalId = t1.method_5667();
        PortalExtension.get((Portal)t1).reversePortalId = f1.method_5667();
        PortalExtension.get((Portal)f2).reversePortalId = t2.method_5667();
        PortalExtension.get((Portal)t2).reversePortalId = f2.method_5667();
        PortalExtension.get((Portal)f1).parallelPortalId = t2.method_5667();
        PortalExtension.get((Portal)t2).parallelPortalId = f1.method_5667();
        PortalExtension.get((Portal)f2).parallelPortalId = t1.method_5667();
        PortalExtension.get((Portal)t1).parallelPortalId = f2.method_5667();
    }

    public static void forClusterPortals(Portal portal, Consumer<Portal> func) {
        func.accept(portal);
        PortalExtension.forConnectedPortals(portal, func);
    }

    public static void forConnectedPortals(Portal portal, Consumer<Portal> func) {
        PortalExtension extension = PortalExtension.get(portal);
        if (extension.flippedPortal != null) {
            func.accept(extension.flippedPortal);
        }
        if (extension.reversePortal != null) {
            func.accept(extension.reversePortal);
        }
        if (extension.parallelPortal != null) {
            func.accept(extension.parallelPortal);
        }
    }

    public static void forEachClusterPortal(Portal portal, Consumer<Portal> forThis, Consumer<Portal> forFlipped, Consumer<Portal> forReverse, Consumer<Portal> forParallel) {
        forThis.accept(portal);
        PortalExtension extension = PortalExtension.get(portal);
        if (extension.flippedPortal != null) {
            forFlipped.accept(extension.flippedPortal);
        }
        if (extension.reversePortal != null) {
            forReverse.accept(extension.reversePortal);
        }
        if (extension.parallelPortal != null) {
            forParallel.accept(extension.parallelPortal);
        }
    }
}

