/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1313;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_265;
import net.minecraft.class_2658;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.ImmPtlEntityExtension;
import qouteall.imm_ptl.core.compat.PehkuiInterface;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.mc_utils.IPEntityEventListenableEntity;
import qouteall.imm_ptl.core.network.IPNetworking;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.IntraClusterRelation;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalRenderInfo;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.AnimationView;
import qouteall.imm_ptl.core.portal.animation.DefaultPortalAnimation;
import qouteall.imm_ptl.core.portal.animation.PortalAnimation;
import qouteall.imm_ptl.core.portal.animation.PortalAnimationDriver;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.render.FrustumCuller;
import qouteall.imm_ptl.core.render.PortalGroup;
import qouteall.imm_ptl.core.render.PortalRenderable;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.dimension.DimId;
import qouteall.q_misc_util.my_util.BoxPredicate;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.MyTaskList;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Range;
import qouteall.q_misc_util.my_util.SignalArged;
import qouteall.q_misc_util.my_util.SignalBiArged;

public class Portal
extends class_1297
implements PortalLike,
IPEntityEventListenableEntity,
PortalRenderable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final class_1299<Portal> entityType = Portal.createPortalEntityType(Portal::new);
    public static final UUID nullUUID = class_156.field_25140;
    private static final class_238 nullBox = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public double width = 0.0;
    public double height = 0.0;
    public class_243 axisW;
    public class_243 axisH;
    public class_5321<class_1937> dimensionTo;
    public class_243 destination;
    public boolean teleportable = true;
    @Nullable
    public UUID specificPlayerId;
    @Nullable
    public GeometryPortalShape specialShape;
    private class_238 exactBoundingBoxCache;
    private class_238 boundingBoxCache;
    private class_243 normal;
    private class_243 contentDirection;
    @Deprecated
    public double cullableXStart = 0.0;
    @Deprecated
    public double cullableXEnd = 0.0;
    @Deprecated
    public double cullableYStart = 0.0;
    @Deprecated
    public double cullableYEnd = 0.0;
    @Nullable
    protected DQuaternion rotation;
    public double scaling = 1.0;
    public boolean teleportChangesScale = true;
    protected boolean teleportChangesGravity;
    private boolean interactable;
    PortalExtension extension;
    @Nullable
    public String portalTag;
    public boolean isGlobalPortal;
    public boolean fuseView;
    public boolean renderingMergable;
    public boolean hasCrossPortalCollision;
    public boolean doRenderPlayer;
    protected boolean visible;
    @Nullable
    public List<String> commandsOnTeleported;
    @Environment(value=EnvType.CLIENT)
    PortalRenderInfo portalRenderInfo;
    public final PortalAnimation animation;
    @Nullable
    private PortalState lastTickPortalState;
    @Nullable
    private PortalState thisTickPortalState;
    private boolean reloadAndSyncNextTick;
    @Nullable
    private class_265 thisSideCollisionExclusion;
    public static final SignalArged<Portal> clientPortalTickSignal = new SignalArged();
    public static final SignalArged<Portal> serverPortalTickSignal = new SignalArged();
    public static final SignalArged<Portal> portalCacheUpdateSignal = new SignalArged();
    public static final SignalArged<Portal> portalDisposeSignal = new SignalArged();
    public static final SignalBiArged<Portal, class_2487> readPortalDataSignal = new SignalBiArged();
    public static final SignalBiArged<Portal, class_2487> writePortalDataSignal = new SignalBiArged();

    public static <T extends Portal> class_1299<T> createPortalEntityType(class_1299.class_4049<T> constructor) {
        return FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, constructor).dimensions(new class_4048(1.0f, 1.0f, true)).fireImmune().trackRangeBlocks(96).trackedUpdateRate(20).forceTrackedVelocityUpdates(true).build();
    }

    public Portal(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
        this.teleportChangesGravity = IPConfig.getConfig().portalsChangeGravityByDefault;
        this.interactable = true;
        this.isGlobalPortal = false;
        this.fuseView = false;
        this.renderingMergable = false;
        this.hasCrossPortalCollision = true;
        this.doRenderPlayer = true;
        this.visible = true;
        this.animation = new PortalAnimation();
        this.reloadAndSyncNextTick = false;
    }

    protected void method_5749(class_2487 compoundTag) {
        this.width = compoundTag.method_10574("width");
        this.height = compoundTag.method_10574("height");
        this.axisW = Helper.getVec3d((class_2487)compoundTag, (String)"axisW").method_1029();
        this.axisH = Helper.getVec3d((class_2487)compoundTag, (String)"axisH").method_1029();
        this.dimensionTo = DimId.getWorldId((class_2487)compoundTag, (String)"dimensionTo", (boolean)this.method_37908().field_9236);
        this.destination = Helper.getVec3d((class_2487)compoundTag, (String)"destination");
        this.specificPlayerId = Helper.getUuid((class_2487)compoundTag, (String)"specificPlayer");
        if (compoundTag.method_10545("specialShape")) {
            this.specialShape = new GeometryPortalShape(compoundTag.method_10554("specialShape", 6));
            if (!this.specialShape.normalized) {
                boolean shapeNormalized;
                this.specialShape.normalized = shapeNormalized = compoundTag.method_10577("shapeNormalized");
            }
            this.specialShape.normalize(this.width, this.height);
            if (this.specialShape.triangles.isEmpty()) {
                this.specialShape = null;
            } else if (!this.specialShape.isValid()) {
                Helper.err((Object)"Portal shape invalid ");
                this.specialShape = null;
            }
        } else {
            this.specialShape = null;
        }
        if (compoundTag.method_10545("teleportable")) {
            this.teleportable = compoundTag.method_10577("teleportable");
        }
        if (compoundTag.method_10545("rotationA")) {
            this.setRotationTransformationD(new DQuaternion((double)compoundTag.method_10583("rotationB"), (double)compoundTag.method_10583("rotationC"), (double)compoundTag.method_10583("rotationD"), (double)compoundTag.method_10583("rotationA")));
        } else {
            this.rotation = null;
        }
        if (compoundTag.method_10545("interactable")) {
            this.interactable = compoundTag.method_10577("interactable");
        }
        if (compoundTag.method_10545("scale")) {
            this.scaling = compoundTag.method_10574("scale");
        }
        if (compoundTag.method_10545("teleportChangesScale")) {
            this.teleportChangesScale = compoundTag.method_10577("teleportChangesScale");
        }
        this.teleportChangesGravity = compoundTag.method_10545("teleportChangesGravity") ? compoundTag.method_10577("teleportChangesGravity") : IPConfig.getConfig().portalsChangeGravityByDefault;
        if (compoundTag.method_10545("portalTag")) {
            this.portalTag = compoundTag.method_10558("portalTag");
        }
        if (compoundTag.method_10545("fuseView")) {
            this.fuseView = compoundTag.method_10577("fuseView");
        }
        if (compoundTag.method_10545("renderingMergable")) {
            this.renderingMergable = compoundTag.method_10577("renderingMergable");
        }
        if (compoundTag.method_10545("hasCrossPortalCollision")) {
            this.hasCrossPortalCollision = compoundTag.method_10577("hasCrossPortalCollision");
        }
        if (compoundTag.method_10545("commandsOnTeleported")) {
            class_2499 list = compoundTag.method_10554("commandsOnTeleported", 8);
            this.commandsOnTeleported = list.stream().map(t -> ((class_2519)t).method_10714()).collect(Collectors.toList());
        } else {
            this.commandsOnTeleported = null;
        }
        if (compoundTag.method_10545("doRenderPlayer")) {
            this.doRenderPlayer = compoundTag.method_10577("doRenderPlayer");
        }
        this.visible = compoundTag.method_10545("isVisible") ? compoundTag.method_10577("isVisible") : true;
        this.animation.readFromTag(compoundTag);
        readPortalDataSignal.emit((Object)this, (Object)compoundTag);
        this.updateCache();
    }

    protected void method_5652(class_2487 compoundTag) {
        compoundTag.method_10549("width", this.width);
        compoundTag.method_10549("height", this.height);
        Helper.putVec3d((class_2487)compoundTag, (String)"axisW", (class_243)this.axisW);
        Helper.putVec3d((class_2487)compoundTag, (String)"axisH", (class_243)this.axisH);
        DimId.putWorldId((class_2487)compoundTag, (String)"dimensionTo", this.dimensionTo);
        Helper.putVec3d((class_2487)compoundTag, (String)"destination", (class_243)this.getDestPos());
        if (this.specificPlayerId != null) {
            Helper.putUuid((class_2487)compoundTag, (String)"specificPlayer", (UUID)this.specificPlayerId);
        }
        if (this.specialShape != null) {
            this.specialShape.normalize(this.width, this.height);
            compoundTag.method_10566("specialShape", (class_2520)this.specialShape.writeToTag());
            compoundTag.method_10556("shapeNormalized", true);
        }
        compoundTag.method_10556("teleportable", this.teleportable);
        if (this.specialShape == null) {
            this.initDefaultCullableRange();
        }
        if (this.rotation != null) {
            compoundTag.method_10549("rotationA", this.rotation.w);
            compoundTag.method_10549("rotationB", this.rotation.x);
            compoundTag.method_10549("rotationC", this.rotation.y);
            compoundTag.method_10549("rotationD", this.rotation.z);
        }
        compoundTag.method_10556("interactable", this.interactable);
        compoundTag.method_10549("scale", this.scaling);
        compoundTag.method_10556("teleportChangesScale", this.teleportChangesScale);
        compoundTag.method_10556("teleportChangesGravity", this.teleportChangesGravity);
        if (this.portalTag != null) {
            compoundTag.method_10582("portalTag", this.portalTag);
        }
        compoundTag.method_10556("fuseView", this.fuseView);
        compoundTag.method_10556("renderingMergable", this.renderingMergable);
        compoundTag.method_10556("hasCrossPortalCollision", this.hasCrossPortalCollision);
        compoundTag.method_10556("doRenderPlayer", this.doRenderPlayer);
        compoundTag.method_10556("isVisible", this.visible);
        if (this.commandsOnTeleported != null) {
            class_2499 list = new class_2499();
            for (String command : this.commandsOnTeleported) {
                list.add((Object)class_2519.method_23256((String)command));
            }
            compoundTag.method_10566("commandsOnTeleported", (class_2520)list);
        }
        this.animation.writeToTag(compoundTag);
        writePortalDataSignal.emit((Object)this, (Object)compoundTag);
    }

    @Override
    public void ip_onEntityPositionUpdated() {
        this.updateCache();
    }

    @Override
    public void ip_onRemoved(class_1297.class_5529 reason) {
        portalDisposeSignal.emit((Object)this);
    }

    @Override
    public class_243 transformPoint(class_243 pos) {
        class_243 localPos = pos.method_1020(this.getOriginPos());
        return this.transformLocalVec(localPos).method_1019(this.getDestPos());
    }

    @Override
    public class_243 transformLocalVec(class_243 localVec) {
        return this.transformLocalVecNonScale(localVec).method_1021(this.scaling);
    }

    public class_243 getNormal() {
        if (this.normal == null) {
            this.normal = this.axisW.method_1036(this.axisH).method_1029();
        }
        return this.normal;
    }

    public class_243 getContentDirection() {
        if (this.contentDirection == null) {
            this.contentDirection = this.transformLocalVecNonScale(this.getNormal().method_1021(-1.0));
        }
        return this.contentDirection;
    }

    public void onEntityTeleportedOnServer(class_1297 entity) {
        if (this.commandsOnTeleported != null) {
            McHelper.invokeCommandAs(entity, this.commandsOnTeleported);
        }
    }

    public void reloadAndSyncToClient() {
        this.reloadAndSyncNextTick = false;
        Validate.isTrue((!this.isGlobalPortal ? 1 : 0) != 0);
        Validate.isTrue((!this.method_37908().method_8608() ? 1 : 0) != 0, (String)"must be used on server side", (Object[])new Object[0]);
        this.updateCache();
        class_2487 customData = new class_2487();
        this.method_5652(customData);
        class_2658 packet = McRemoteProcedureCall.createPacketToSendToClient((String)"qouteall.imm_ptl.core.portal.Portal.RemoteCallables.acceptPortalDataSync", (Object[])new Object[]{this.method_37908().method_27983(), this.method_5628(), this.method_19538(), customData});
        McHelper.sendToTrackers(this, packet);
    }

    public void reloadAndSyncToClientNextTick() {
        Validate.isTrue((!this.method_37908().method_8608() ? 1 : 0) != 0, (String)"must be used on server side", (Object[])new Object[0]);
        this.reloadAndSyncNextTick = true;
    }

    public void reloadAndSyncClusterToClientNextTick() {
        PortalExtension.forClusterPortals(this, Portal::reloadAndSyncToClientNextTick);
    }

    public void reloadAndSyncToClientWithTickDelay(int tickDelay) {
        Validate.isTrue((!this.method_37908().method_8608() ? 1 : 0) != 0, (String)"must be used on server side", (Object[])new Object[0]);
        IPGlobal.serverTaskList.addTask(MyTaskList.withDelay((int)tickDelay, () -> {
            this.reloadAndSyncToClientNextTick();
            return true;
        }));
    }

    public void updateCache() {
        if (this.axisW == null) {
            return;
        }
        boolean updates = this.boundingBoxCache != null || this.exactBoundingBoxCache != null || this.normal != null || this.contentDirection != null;
        this.boundingBoxCache = null;
        this.exactBoundingBoxCache = null;
        this.normal = null;
        this.contentDirection = null;
        this.thisTickPortalState = null;
        this.thisSideCollisionExclusion = null;
        if (updates) {
            portalCacheUpdateSignal.emit((Object)this);
        }
    }

    public class_238 method_5829() {
        if (this.boundingBoxCache == null) {
            this.boundingBoxCache = this.method_33332();
            if (this.boundingBoxCache == null) {
                Helper.err((Object)"Cannot calc portal bounding box");
                return nullBox;
            }
        }
        return this.boundingBoxCache;
    }

    @Override
    public class_243 getOriginPos() {
        return this.method_19538();
    }

    @Override
    public class_243 getDestPos() {
        return this.destination;
    }

    public void setOriginPos(class_243 pos) {
        this.method_33574(pos);
    }

    public void setDestinationDimension(class_5321<class_1937> dim) {
        this.dimensionTo = dim;
    }

    public void setDestination(class_243 destination) {
        this.destination = destination;
        this.updateCache();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderViewAreaMesh(class_243 portalPosRelativeToCamera, Consumer<class_243> vertexOutput) {
        if (this instanceof Mirror) {
            boolean offsetFront = IrisInterface.invoker.isShaders() || IPGlobal.pureMirror;
            double mirrorOffset = offsetFront ? 0.01 : -0.01;
            portalPosRelativeToCamera = portalPosRelativeToCamera.method_1019(((Mirror)this).getNormal().method_1021(mirrorOffset));
        }
        ViewAreaRenderer.generateViewAreaTriangles(this, portalPosRelativeToCamera, vertexOutput);
    }

    @Override
    public boolean isFuseView() {
        return this.fuseView;
    }

    public boolean isRenderingMergable() {
        return this.renderingMergable;
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public void setInteractable(boolean interactable) {
        this.interactable = interactable;
    }

    @Override
    public class_1937 getOriginWorld() {
        return this.method_37908();
    }

    @Override
    public class_1937 getDestWorld() {
        return this.getDestinationWorld();
    }

    @Override
    public class_5321<class_1937> getDestDim() {
        return this.dimensionTo;
    }

    @Override
    public double getScale() {
        return this.scaling;
    }

    @Override
    public boolean getIsGlobal() {
        return this.isGlobalPortal;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setIsVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean canTeleportEntity(class_1297 entity) {
        if (!this.teleportable) {
            return false;
        }
        if (entity instanceof Portal) {
            return false;
        }
        if (entity instanceof class_1657 ? this.specificPlayerId != null && !entity.method_5667().equals(this.specificPlayerId) : this.specificPlayerId != null && !this.specificPlayerId.equals(nullUUID)) {
            return false;
        }
        return ((ImmPtlEntityExtension)entity).imm_ptl_canTeleportThroughPortal(this);
    }

    public boolean canCollideWithEntity(class_1297 entity) {
        return this.canTeleportEntity(entity);
    }

    public boolean isInteractableBy(class_1657 player) {
        if (!this.isInteractable()) {
            return false;
        }
        if (!this.isVisible()) {
            return false;
        }
        return this.canTeleportEntity((class_1297)player);
    }

    @Override
    @Nullable
    public DQuaternion getRotation() {
        return this.rotation;
    }

    @NotNull
    public DQuaternion getRotationD() {
        return DQuaternion.fromNullable((DQuaternion)this.getRotation());
    }

    @Override
    public boolean getDoRenderPlayer() {
        return this.doRenderPlayer;
    }

    public boolean getTeleportable() {
        return this.teleportable;
    }

    public void setTeleportable(boolean teleportable) {
        this.teleportable = teleportable;
    }

    public void setOrientationAndSize(class_243 newAxisW, class_243 newAxisH, double newWidth, double newHeight) {
        this.setOrientation(newAxisW, newAxisH);
        this.width = newWidth;
        this.height = newHeight;
        this.updateCache();
    }

    public void setOrientation(class_243 newAxisW, class_243 newAxisH) {
        this.axisW = newAxisW.method_1029();
        this.axisH = newAxisH.method_1029();
        this.updateCache();
    }

    public void setWidth(double newWidth) {
        this.width = newWidth;
        this.updateCache();
    }

    public void setHeight(double newHeight) {
        this.height = newHeight;
        this.updateCache();
    }

    public DQuaternion getOrientationRotation() {
        return PortalManipulation.getPortalOrientationQuaternion(this.axisW, this.axisH);
    }

    public void setOrientationRotation(DQuaternion quaternion) {
        DQuaternion fixed = this.method_37908().method_8608() ? quaternion : quaternion.fixFloatingPointErrorAccumulation();
        this.setOrientation(McHelper.getAxisWFromOrientation(fixed), McHelper.getAxisHFromOrientation(fixed));
    }

    public void setRotation(@Nullable DQuaternion quaternion) {
        this.setRotationTransformationD(quaternion);
    }

    public void setRotationTransformation(@Nullable DQuaternion quaternion) {
        this.setRotationTransformationD(quaternion);
    }

    public void setRotationTransformationD(@Nullable DQuaternion quaternion) {
        this.rotation = quaternion == null ? null : quaternion.fixFloatingPointErrorAccumulation();
        this.updateCache();
    }

    public void setOtherSideOrientation(DQuaternion otherSideOrientation) {
        this.setRotation(PortalManipulation.computeDeltaTransformation(this.getOrientationRotation(), otherSideOrientation));
    }

    public void setScaleTransformation(double newScale) {
        this.scaling = newScale;
    }

    @Deprecated
    private void initDefaultCullableRange() {
    }

    @Deprecated
    public void initCullableRange(double cullableXStart, double cullableXEnd, double cullableYStart, double cullableYEnd) {
    }

    public class_2596<class_2602> method_18002() {
        return IPNetworking.createStcSpawnEntity(this);
    }

    public boolean method_5680(class_3222 spectator) {
        if (this.specificPlayerId == null) {
            return true;
        }
        return spectator.method_5667().equals(this.specificPlayerId);
    }

    public void method_5773() {
        if (this.method_5829().equals((Object)nullBox)) {
            Helper.err((Object)("Abnormal bounding box " + this));
        }
        if (this.specialShape != null) {
            this.specialShape.normalize(this.width, this.height);
        }
        if (this.thisTickPortalState == null) {
            this.thisTickPortalState = this.getPortalState();
        }
        this.lastTickPortalState = this.thisTickPortalState;
        if (!this.method_37908().method_8608() && this.reloadAndSyncNextTick) {
            this.reloadAndSyncToClient();
        }
        if (this.method_37908().method_8608()) {
            clientPortalTickSignal.emit((Object)this);
        } else {
            if (!this.isPortalValid()) {
                Helper.log((Object)("removed invalid portal" + this));
                this.method_5650(class_1297.class_5529.field_26998);
                return;
            }
            serverPortalTickSignal.emit((Object)this);
        }
        this.animation.tick(this);
        super.method_5773();
    }

    protected class_238 method_33332() {
        if (this.axisW == null) {
            this.boundingBoxCache = null;
            return nullBox;
        }
        if (this.boundingBoxCache == null) {
            double w = this.width;
            double h = this.height;
            if (this.shouldLimitBoundingBox()) {
                w = Math.min(this.width, 64.0);
                h = Math.min(this.height, 64.0);
            }
            this.boundingBoxCache = new class_238(this.getPointInPlane(w / 2.0, h / 2.0).method_1019(this.getNormal().method_1021(0.2)), this.getPointInPlane(-w / 2.0, -h / 2.0).method_1019(this.getNormal().method_1021(-0.2))).method_991(new class_238(this.getPointInPlane(-w / 2.0, h / 2.0).method_1019(this.getNormal().method_1021(0.2)), this.getPointInPlane(w / 2.0, -h / 2.0).method_1019(this.getNormal().method_1021(-0.2))));
        }
        return this.boundingBoxCache;
    }

    protected boolean shouldLimitBoundingBox() {
        return !this.getIsGlobal();
    }

    public class_238 getExactBoundingBox() {
        if (this.exactBoundingBoxCache == null) {
            this.exactBoundingBoxCache = new class_238(this.getPointInPlane(this.width / 2.0, this.height / 2.0).method_1019(this.getNormal().method_1021(0.02)), this.getPointInPlane(-this.width / 2.0, -this.height / 2.0).method_1019(this.getNormal().method_1021(-0.02))).method_991(new class_238(this.getPointInPlane(-this.width / 2.0, this.height / 2.0).method_1019(this.getNormal().method_1021(0.02)), this.getPointInPlane(this.width / 2.0, -this.height / 2.0).method_1019(this.getNormal().method_1021(-0.02))));
        }
        return this.exactBoundingBoxCache;
    }

    public void method_5784(class_1313 type, class_243 movement) {
    }

    public boolean isPortalValid() {
        boolean valid;
        boolean bl = valid = this.dimensionTo != null && this.width != 0.0 && this.height != 0.0 && this.axisW != null && this.axisH != null && this.getDestPos() != null && this.axisW.method_1027() > 0.9 && this.axisH.method_1027() > 0.9 && this.method_23318() > (double)(McHelper.getMinY((class_1936)this.method_37908()) - 100);
        if (valid) {
            if (this.method_37908() instanceof class_3218) {
                class_3218 destWorld = MiscHelper.getServer().method_3847(this.dimensionTo);
                if (destWorld == null) {
                    Helper.err((Object)("Portal Dest Dimension Missing " + this.dimensionTo.method_29177()));
                    return false;
                }
                boolean inWorldBorder = destWorld.method_8621().method_11952(class_2338.method_49638((class_2374)this.getDestPos()));
                if (!inWorldBorder) {
                    Helper.err((Object)("Destination out of World Border " + this));
                    return false;
                }
            }
            if (this.method_37908().method_8608()) {
                return this.isPortalValidClient();
            }
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private boolean isPortalValidClient() {
        boolean contains = ClientWorldLoader.getServerDimensions().contains(this.dimensionTo);
        if (!contains) {
            Helper.err((Object)("Client Portal Dest Dimension Missing " + this.dimensionTo.method_29177()));
        }
        return contains;
    }

    @Override
    @Nullable
    public UUID getDiscriminator() {
        return this.method_5667();
    }

    public String toString() {
        return String.format("%s{%s,%s,(%s %.1f %.1f %.1f)->(%s %.1f %.1f %.1f)%s%s%s}", this.getClass().getSimpleName(), this.method_5628(), this.getApproximateFacingDirection(), this.method_37908().method_27983().method_29177(), this.method_23317(), this.method_23318(), this.method_23321(), this.dimensionTo.method_29177(), this.getDestPos().field_1352, this.getDestPos().field_1351, this.getDestPos().field_1350, this.specificPlayerId != null ? ",specificAccessor:" + this.specificPlayerId.toString() : "", this.hasScaling() ? ",scale:" + this.scaling : "", this.portalTag != null ? "," + this.portalTag : "");
    }

    public class_2350 getApproximateFacingDirection() {
        return class_2350.method_10142((double)this.getNormal().field_1352, (double)this.getNormal().field_1351, (double)this.getNormal().field_1350);
    }

    public class_243 transformVelocityRelativeToPortal(class_243 originalVelocityRelativeToPortal, class_1297 entity) {
        class_243 result = PehkuiInterface.invoker.isPehkuiPresent() ? (this.teleportChangesScale ? this.transformLocalVecNonScale(originalVelocityRelativeToPortal) : this.transformLocalVec(originalVelocityRelativeToPortal)) : this.transformLocalVec(originalVelocityRelativeToPortal);
        int maxVelocity = 15;
        if (originalVelocityRelativeToPortal.method_1033() > 15.0) {
            result = result.method_1029().method_1021(15.0);
        }
        if (entity instanceof class_1688 && result.method_1027() < 0.5) {
            result = result.method_1021(2.0);
        }
        return result;
    }

    public double getDistanceToPlane(class_243 pos) {
        return pos.method_1020(this.getOriginPos()).method_1026(this.getNormal());
    }

    public boolean isInFrontOfPortal(class_243 pos) {
        return this.getDistanceToPlane(pos) > 0.0;
    }

    public class_243 getPointInPlane(double xInPlane, double yInPlane) {
        return this.getOriginPos().method_1019(this.getPointInPlaneLocal(xInPlane, yInPlane));
    }

    public class_243 getPointInPlaneLocal(double xInPlane, double yInPlane) {
        return this.axisW.method_1021(xInPlane).method_1019(this.axisH.method_1021(yInPlane));
    }

    public class_243 getPointInPlaneLocalClamped(double xInPlane, double yInPlane) {
        return this.getPointInPlaneLocal(class_3532.method_15350((double)xInPlane, (double)(-this.width / 2.0), (double)(this.width / 2.0)), class_3532.method_15350((double)yInPlane, (double)(-this.height / 2.0), (double)(this.height / 2.0)));
    }

    public class_243[] getFourVerticesLocal(double shrinkFactor) {
        class_243[] vertices = new class_243[]{this.getPointInPlaneLocal(this.width / 2.0 - shrinkFactor, -this.height / 2.0 + shrinkFactor), this.getPointInPlaneLocal(-this.width / 2.0 + shrinkFactor, -this.height / 2.0 + shrinkFactor), this.getPointInPlaneLocal(this.width / 2.0 - shrinkFactor, this.height / 2.0 - shrinkFactor), this.getPointInPlaneLocal(-this.width / 2.0 + shrinkFactor, this.height / 2.0 - shrinkFactor)};
        return vertices;
    }

    private class_243[] getFourVerticesLocalRotated(double shrinkFactor) {
        class_243[] fourVerticesLocal = this.getFourVerticesLocal(shrinkFactor);
        fourVerticesLocal[0] = this.transformLocalVec(fourVerticesLocal[0]);
        fourVerticesLocal[1] = this.transformLocalVec(fourVerticesLocal[1]);
        fourVerticesLocal[2] = this.transformLocalVec(fourVerticesLocal[2]);
        fourVerticesLocal[3] = this.transformLocalVec(fourVerticesLocal[3]);
        return fourVerticesLocal;
    }

    private class_243[] getFourVerticesLocalCullable(double shrink) {
        double xStart = -this.width / 2.0;
        double xEnd = this.width / 2.0;
        double yStart = -this.height / 2.0;
        double yEnd = this.height / 2.0;
        class_243[] vertices = new class_243[]{this.getPointInPlaneLocal(xEnd - shrink, yStart + shrink), this.getPointInPlaneLocal(xStart + shrink, yStart + shrink), this.getPointInPlaneLocal(xEnd - shrink, yEnd - shrink), this.getPointInPlaneLocal(xStart + shrink, yEnd - shrink)};
        return vertices;
    }

    public final class_243 transformPointRough(class_243 pos) {
        class_243 offset = this.getDestPos().method_1020(this.getOriginPos());
        return pos.method_1019(offset);
    }

    @Override
    public class_243 transformLocalVecNonScale(class_243 localVec) {
        if (this.rotation == null) {
            return localVec;
        }
        return this.rotation.rotate(localVec);
    }

    public class_243 inverseTransformLocalVecNonScale(class_243 localVec) {
        if (this.rotation == null) {
            return localVec;
        }
        return this.rotation.getConjugated().rotate(localVec);
    }

    @Override
    public class_243 inverseTransformLocalVec(class_243 localVec) {
        return this.inverseTransformLocalVecNonScale(localVec).method_1021(1.0 / this.scaling);
    }

    @Override
    public class_243 inverseTransformPoint(class_243 point) {
        return this.getOriginPos().method_1019(this.inverseTransformLocalVec(point.method_1020(this.getDestPos())));
    }

    public class_238 getThinAreaBox() {
        double w = this.width;
        double h = this.height;
        return new class_238(this.getPointInPlane(w / 2.0, h / 2.0), this.getPointInPlane(-w / 2.0, -h / 2.0)).method_991(new class_238(this.getPointInPlane(-w / 2.0, h / 2.0), this.getPointInPlane(w / 2.0, -h / 2.0)));
    }

    public boolean isPointInPortalProjection(class_243 pos) {
        return this.lenientIsPointInPortalProjection(pos, 0.001);
    }

    public boolean lenientIsPointInPortalProjection(class_243 pos, double leniency) {
        class_243 offset = pos.method_1020(this.getOriginPos());
        double yInPlane = offset.method_1026(this.axisH);
        double xInPlane = offset.method_1026(this.axisW);
        return this.lenientIsLocalXYOnPortal(xInPlane, yInPlane, leniency);
    }

    public boolean isLocalXYOnPortal(double xInPlane, double yInPlane) {
        return this.lenientIsLocalXYOnPortal(xInPlane, yInPlane, 0.001);
    }

    public boolean lenientIsLocalXYOnPortal(double xInPlane, double yInPlane, double leniency) {
        boolean roughResult;
        double halfWidth = this.width / 2.0;
        double halfHeight = this.height / 2.0;
        boolean bl = roughResult = Math.abs(xInPlane) < halfWidth + leniency && Math.abs(yInPlane) < halfHeight + leniency;
        if (halfWidth == 0.0 || halfHeight == 0.0) {
            return false;
        }
        if (roughResult && this.specialShape != null) {
            return this.specialShape.triangles.stream().anyMatch(triangle -> triangle.lenientIsPointInTriangle(xInPlane / halfWidth, yInPlane / halfHeight, leniency));
        }
        return roughResult;
    }

    public boolean isMovedThroughPortal(class_243 lastTickPos, class_243 pos) {
        return this.rayTrace(lastTickPos, pos) != null;
    }

    @Nullable
    public class_243 rayTrace(class_243 from, class_243 to) {
        return this.lenientRayTrace(from, to, 0.001);
    }

    @Nullable
    public class_243 lenientRayTrace(class_243 from, class_243 to, double leniency) {
        double collidingT;
        double lastDistance = this.getDistanceToPlane(from);
        double nowDistance = this.getDistanceToPlane(to);
        if (!(lastDistance > 0.0) || !(nowDistance < 0.0)) {
            return null;
        }
        class_243 lineOrigin = from;
        class_243 lineDirection = to.method_1020(from).method_1029();
        class_243 collidingPoint = lineOrigin.method_1019(lineDirection.method_1021(collidingT = Helper.getCollidingT((class_243)this.getOriginPos(), (class_243)this.normal, (class_243)lineOrigin, (class_243)lineDirection)));
        if (this.lenientIsPointInPortalProjection(collidingPoint, leniency)) {
            return collidingPoint;
        }
        return null;
    }

    @Override
    public double getDistanceToNearestPointInPortal(class_243 point) {
        double distanceToPlane = this.getDistanceToPlane(point);
        class_243 localPos = point.method_1020(this.getOriginPos());
        double localX = localPos.method_1026(this.axisW);
        double localY = localPos.method_1026(this.axisH);
        double distanceToRect = Helper.getDistanceToRectangle((double)localX, (double)localY, (double)(-(this.width / 2.0)), (double)(-(this.height / 2.0)), (double)(this.width / 2.0), (double)(this.height / 2.0));
        return Math.sqrt(distanceToPlane * distanceToPlane + distanceToRect * distanceToRect);
    }

    public class_243 getPointProjectedToPlane(class_243 pos) {
        class_243 originPos = this.getOriginPos();
        class_243 offset = pos.method_1020(originPos);
        double yInPlane = offset.method_1026(this.axisH);
        double xInPlane = offset.method_1026(this.axisW);
        return originPos.method_1019(this.axisW.method_1021(xInPlane)).method_1019(this.axisH.method_1021(yInPlane));
    }

    public class_243 getNearestPointInPortal(class_243 pos) {
        class_243 originPos = this.getOriginPos();
        class_243 offset = pos.method_1020(originPos);
        double yInPlane = offset.method_1026(this.axisH);
        double xInPlane = offset.method_1026(this.axisW);
        xInPlane = class_3532.method_15350((double)xInPlane, (double)(-this.width / 2.0), (double)(this.width / 2.0));
        yInPlane = class_3532.method_15350((double)yInPlane, (double)(-this.height / 2.0), (double)(this.height / 2.0));
        return originPos.method_1019(this.axisW.method_1021(xInPlane)).method_1019(this.axisH.method_1021(yInPlane));
    }

    public class_1937 getDestinationWorld() {
        return this.getDestinationWorld(this.method_37908().method_8608());
    }

    private class_1937 getDestinationWorld(boolean isClient) {
        if (isClient) {
            return CHelper.getClientWorld(this.dimensionTo);
        }
        return MiscHelper.getServer().method_3847(this.dimensionTo);
    }

    public static boolean isParallelPortal(Portal a, Portal b) {
        if (a == b) {
            return false;
        }
        return a.dimensionTo == b.method_37908().method_27983() && a.method_37908().method_27983() == b.dimensionTo && a.getOriginPos().method_1022(b.getDestPos()) < 0.1 && a.getDestPos().method_1022(b.getOriginPos()) < 0.1 && a.getNormal().method_1026(b.getContentDirection()) < -0.9;
    }

    public static boolean isParallelOrientedPortal(Portal currPortal, Portal outerPortal) {
        double dot = currPortal.getOriginPos().method_1020(outerPortal.getDestPos()).method_1026(outerPortal.getContentDirection());
        return currPortal.method_37908().method_27983() == outerPortal.dimensionTo && currPortal.getNormal().method_1026(outerPortal.getContentDirection()) < -0.9 && Math.abs(dot) < 0.001;
    }

    public static boolean isReversePortal(Portal a, Portal b) {
        return a.dimensionTo == b.method_37908().method_27983() && a.method_37908().method_27983() == b.dimensionTo && a.getOriginPos().method_1022(b.getDestPos()) < 0.1 && a.getDestPos().method_1022(b.getOriginPos()) < 0.1 && a.getNormal().method_1026(b.getContentDirection()) > 0.9;
    }

    public static boolean isFlippedPortal(Portal a, Portal b) {
        if (a == b) {
            return false;
        }
        return a.method_37908() == b.method_37908() && a.dimensionTo == b.dimensionTo && a.getOriginPos().method_1022(b.getOriginPos()) < 0.1 && a.getDestPos().method_1022(b.getDestPos()) < 0.1 && a.getNormal().method_1026(b.getNormal()) < -0.9;
    }

    @Override
    public double getDestAreaRadiusEstimation() {
        return Math.max(this.width, this.height) * this.scaling;
    }

    @Override
    public boolean isConventionalPortal() {
        return true;
    }

    @Override
    public class_238 getExactAreaBox() {
        return this.getExactBoundingBox();
    }

    @Override
    public boolean isRoughlyVisibleTo(class_243 cameraPos) {
        return this.isInFrontOfPortal(cameraPos);
    }

    @Override
    @Nullable
    public Plane getInnerClipping() {
        return new Plane(this.getDestPos(), this.getContentDirection());
    }

    @Override
    @Nullable
    public class_243[] getOuterFrustumCullingVertices() {
        return this.getFourVerticesLocalCullable(0.0);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BoxPredicate getInnerFrustumCullingFunc(double cameraX, double cameraY, double cameraZ) {
        class_243 portalOriginInLocalCoordinate = this.getDestPos().method_1031(-cameraX, -cameraY, -cameraZ);
        class_243[] innerFrustumCullingVertices = this.getFourVerticesLocalRotated(0.0);
        if (innerFrustumCullingVertices == null) {
            return BoxPredicate.nonePredicate;
        }
        class_243[] downLeftUpRightPlaneNormals = FrustumCuller.getDownLeftUpRightPlaneNormals(portalOriginInLocalCoordinate, innerFrustumCullingVertices);
        class_243 downPlane = downLeftUpRightPlaneNormals[0];
        class_243 leftPlane = downLeftUpRightPlaneNormals[1];
        class_243 upPlane = downLeftUpRightPlaneNormals[2];
        class_243 rightPlane = downLeftUpRightPlaneNormals[3];
        return (minX, minY, minZ, maxX, maxY, maxZ) -> FrustumCuller.isFullyOutsideFrustum(minX, minY, minZ, maxX, maxY, maxZ, leftPlane, rightPlane, upPlane, downPlane);
    }

    public Matrix4d getFullSpaceTransformation() {
        class_243 originPos = this.getOriginPos();
        class_243 destPos = this.getDestPos();
        DQuaternion rot = this.getRotationD();
        return new Matrix4d().translation(destPos.field_1352, destPos.field_1351, destPos.field_1350).scale(this.getScale()).rotate((Quaternionfc)rot.toMcQuaternion()).translate(-originPos.field_1352, -originPos.field_1351, -originPos.field_1350);
    }

    public TransformationDesc getTransformationDesc() {
        return new TransformationDesc(this.getDestDim(), this.getFullSpaceTransformation(), this.getRotationD(), this.getScale());
    }

    @Override
    public boolean cannotRenderInMe(Portal portal) {
        if (this.respectParallelOrientedPortal()) {
            return Portal.isParallelPortal(portal, this);
        }
        return Portal.isParallelOrientedPortal(portal, this);
    }

    public void myUnsetRemoved() {
        this.method_31482();
    }

    @Environment(value=EnvType.CLIENT)
    public PortalLike getRenderingDelegate() {
        if (IPGlobal.enablePortalRenderingMerge) {
            PortalGroup group = PortalRenderInfo.getGroupOf(this);
            if (group != null) {
                return group;
            }
            return this;
        }
        return this;
    }

    public void method_18382() {
        this.boundingBoxCache = null;
    }

    protected float method_18378(class_4050 pose, class_4048 dimensions) {
        return 0.0f;
    }

    @Override
    @Nullable
    public Matrix4f getAdditionalCameraTransformation() {
        return PortalRenderer.getPortalTransformation(this);
    }

    protected void method_5693() {
    }

    public boolean canDoOuterFrustumCulling() {
        if (this.isFuseView()) {
            return false;
        }
        if (!this.isVisible()) {
            return false;
        }
        return this.specialShape == null;
    }

    @Deprecated
    public boolean isTeleportable() {
        return this.teleportable;
    }

    public static boolean doesPortalBlockEntityView(class_1309 observer, class_1297 target) {
        observer.method_37908().method_16107().method_15396("portal_block_view");
        List<Portal> viewBlockingPortals = McHelper.findEntitiesByBox(Portal.class, observer.method_37908(), observer.method_5829().method_991(target.method_5829()), 8.0, p -> p.rayTrace(observer.method_5836(1.0f), target.method_5836(1.0f)) != null);
        observer.method_37908().method_16107().method_15407();
        return !viewBlockingPortals.isEmpty();
    }

    public boolean respectParallelOrientedPortal() {
        return this.allowOverlappedTeleport();
    }

    @Deprecated
    public boolean allowOverlappedTeleport() {
        return false;
    }

    public void onCollidingWithEntity(class_1297 entity) {
    }

    @Override
    public boolean getHasCrossPortalCollision() {
        return this.hasCrossPortalCollision;
    }

    public boolean getTeleportChangesScale() {
        return this.teleportChangesScale;
    }

    public void setTeleportChangesScale(boolean teleportChangesScale) {
        this.teleportChangesScale = teleportChangesScale;
    }

    public boolean getTeleportChangesGravity() {
        return this.teleportChangesGravity;
    }

    public void setTeleportChangesGravity(boolean cond) {
        this.teleportChangesGravity = cond;
    }

    public class_2350 getTeleportedGravityDirection(class_2350 oldGravityDir) {
        if (!this.getTeleportChangesGravity()) {
            return oldGravityDir;
        }
        return this.getTransformedGravityDirection(oldGravityDir);
    }

    public class_2350 getTransformedGravityDirection(class_2350 oldGravityDir) {
        class_243 oldGravityVec = class_243.method_24954((class_2382)oldGravityDir.method_10163());
        class_243 newGravityVec = this.transformLocalVecNonScale(oldGravityVec);
        return class_2350.method_10142((double)newGravityVec.field_1352, (double)newGravityVec.field_1351, (double)newGravityVec.field_1350);
    }

    @Nullable
    public PortalState getPortalState() {
        if (this.axisW == null) {
            return null;
        }
        return new PortalState((class_5321<class_1937>)this.method_37908().method_27983(), this.getOriginPos(), this.dimensionTo, this.getDestPos(), this.getScale(), this.getRotationD(), this.getOrientationRotation(), this.width, this.height);
    }

    public void setPortalState(PortalState state) {
        Validate.isTrue((this.method_37908().method_27983() == state.fromWorld ? 1 : 0) != 0);
        Validate.isTrue((this.dimensionTo == state.toWorld ? 1 : 0) != 0);
        this.width = state.width;
        this.height = state.height;
        this.setOriginPos(state.fromPos);
        this.setDestination(state.toPos);
        PortalManipulation.setPortalOrientationQuaternion(this, state.orientation);
        if (DQuaternion.isClose((DQuaternion)state.rotation, (DQuaternion)DQuaternion.identity, (double)5.0E-5)) {
            this.setRotationTransformationD(null);
        } else {
            this.setRotationTransformationD(state.rotation);
        }
        this.setScaleTransformation(state.scaling);
    }

    public UnilateralPortalState getThisSideState() {
        return new UnilateralPortalState((class_5321<class_1937>)this.getOriginDim(), this.getOriginPos(), this.getOrientationRotation(), this.width, this.height);
    }

    public void setThisSideState(UnilateralPortalState ups) {
        this.setThisSideState(ups, false);
    }

    public void setThisSideState(UnilateralPortalState ups, boolean lockScale) {
        Validate.notNull((Object)ups);
        PortalState portalState = this.getPortalState();
        assert (portalState != null);
        PortalState newPortalState = portalState.withThisSideUpdated(ups, lockScale);
        this.setPortalState(newPortalState);
    }

    @Environment(value=EnvType.CLIENT)
    private void acceptDataSync(class_243 pos, class_2487 customData) {
        PortalState oldState = this.getPortalState();
        this.method_33574(pos);
        this.method_5749(customData);
        if (this.animation.defaultAnimation.durationTicks > 0) {
            this.animation.defaultAnimation.startClientDefaultAnimation(this, oldState);
        }
    }

    public class_2487 writePortalDataToNbt() {
        class_2487 nbtCompound = new class_2487();
        this.method_5652(nbtCompound);
        return nbtCompound;
    }

    public void readPortalDataFromNbt(class_2487 compound) {
        this.method_5749(compound);
    }

    public void updatePortalFromNbt(class_2487 newNbt) {
        class_2487 data = this.writePortalDataToNbt();
        newNbt.method_10541().forEach(key -> data.method_10566(key, newNbt.method_10580(key)));
        this.readPortalDataFromNbt(data);
    }

    @Deprecated
    public void rectifyClusterPortals() {
        PortalExtension.get(this).rectifyClusterPortals(this, true);
    }

    public void rectifyClusterPortals(boolean sync) {
        PortalExtension.get(this).rectifyClusterPortals(this, sync);
    }

    public void reloadPortal() {
        Validate.isTrue((!this.method_37908().method_8608() ? 1 : 0) != 0);
        this.updateCache();
        this.rectifyClusterPortals(true);
        this.reloadAndSyncToClientNextTick();
    }

    public DefaultPortalAnimation getDefaultAnimation() {
        return this.animation.defaultAnimation;
    }

    public void clearAnimationDrivers(boolean clearThisSide, boolean clearOtherSide) {
        this.animation.clearAnimationDrivers(this, clearThisSide, clearOtherSide);
    }

    public void addThisSideAnimationDriver(PortalAnimationDriver driver) {
        this.getAnimationView().addThisSideAnimation(driver);
        this.reloadAndSyncClusterToClientNextTick();
    }

    public void addOtherSideAnimationDriver(PortalAnimationDriver driver) {
        this.getAnimationView().addOtherSideAnimation(driver);
        this.reloadAndSyncClusterToClientNextTick();
    }

    public void pauseAnimation() {
        this.animation.setPaused(this, true);
    }

    public void resumeAnimation() {
        this.animation.setPaused(this, false);
    }

    public void resetAnimationReferenceState(boolean resetThisSide, boolean resetOtherSide) {
        this.animation.resetReferenceState(this, resetThisSide, resetOtherSide);
    }

    public AnimationView getAnimationView() {
        PortalExtension extension = PortalExtension.get(this);
        if (extension.flippedPortal != null && extension.flippedPortal.animation.hasAnimationDriver()) {
            return new AnimationView(this, extension.flippedPortal, IntraClusterRelation.FLIPPED);
        }
        if (extension.reversePortal != null && extension.reversePortal.animation.hasAnimationDriver()) {
            return new AnimationView(this, extension.reversePortal, IntraClusterRelation.REVERSE);
        }
        if (extension.parallelPortal != null && extension.parallelPortal.animation.hasAnimationDriver()) {
            return new AnimationView(this, extension.parallelPortal, IntraClusterRelation.PARALLEL);
        }
        return new AnimationView(this, this, IntraClusterRelation.SAME);
    }

    public boolean isOtherSideChunkLoaded() {
        Validate.isTrue((!this.method_37908().method_8608() ? 1 : 0) != 0);
        return McHelper.isServerChunkFullyLoaded((class_3218)this.getDestWorld(), new class_1923(class_2338.method_49638((class_2374)this.getDestPos())));
    }

    @Nullable
    public PortalState getLastTickPortalState() {
        if (this.lastTickPortalState == null) {
            return this.getThisTickPortalState();
        }
        return this.lastTickPortalState;
    }

    @Nullable
    public PortalState getThisTickPortalState() {
        if (this.thisTickPortalState == null) {
            this.thisTickPortalState = this.getPortalState();
        }
        return this.thisTickPortalState;
    }

    public PortalState getAnimationEndingState() {
        return this.animation.getAnimationEndingState(this);
    }

    public class_243 transformFromPortalLocalToWorld(class_243 localPos) {
        return this.axisW.method_1021(localPos.field_1352).method_1019(this.axisH.method_1021(localPos.field_1351)).method_1019(this.getNormal().method_1021(localPos.field_1350)).method_1019(this.getOriginPos());
    }

    public class_243 transformFromWorldToPortalLocal(class_243 worldPos) {
        class_243 relativePos = worldPos.method_1020(this.getOriginPos());
        return new class_243(relativePos.method_1026(this.axisW), relativePos.method_1026(this.axisH), relativePos.method_1026(this.getNormal()));
    }

    @Nullable
    public Portal getAnimationHolder() {
        if (this.animation.hasAnimationDriver()) {
            return this;
        }
        PortalExtension portalExtension = PortalExtension.get(this);
        if (portalExtension.flippedPortal != null && portalExtension.flippedPortal.animation.hasAnimationDriver()) {
            return portalExtension.flippedPortal;
        }
        if (portalExtension.reversePortal != null && portalExtension.reversePortal.animation.hasAnimationDriver()) {
            return portalExtension.reversePortal;
        }
        if (portalExtension.parallelPortal != null && portalExtension.parallelPortal.animation.hasAnimationDriver()) {
            return portalExtension.parallelPortal;
        }
        return null;
    }

    public Portal getPossibleAnimationHolder() {
        Portal holder = this.getAnimationHolder();
        if (holder != null) {
            return holder;
        }
        return this;
    }

    public long getAnimationEffectiveTime() {
        Portal holder = this.getPossibleAnimationHolder();
        return holder.animation.getEffectiveTime(holder.method_37908().method_8510());
    }

    public void disableDefaultAnimation() {
        this.animation.defaultAnimation.durationTicks = 0;
        this.reloadAndSyncToClientNextTick();
    }

    public class_265 getThisSideCollisionExclusion() {
        if (this.thisSideCollisionExclusion == null) {
            class_238 thinAreaBox = this.getThinAreaBox();
            class_243 reaching = this.getNormal().method_1021(-10.0);
            class_238 ignorance = thinAreaBox.method_991(thinAreaBox.method_997(reaching));
            this.thisSideCollisionExclusion = class_259.method_1078((class_238)ignorance);
        }
        return this.thisSideCollisionExclusion;
    }

    public boolean isBoundingBoxInPortalProjection(class_238 boundingBox) {
        double minY;
        double minX;
        class_243[] vertexes = Helper.eightVerticesOf((class_238)boundingBox);
        class_243 originPos = this.getOriginPos();
        double maxX = minX = vertexes[0].method_1020(originPos).method_1026(this.axisW);
        double maxY = minY = vertexes[0].method_1020(originPos).method_1026(this.axisH);
        for (int i = 1; i < 8; ++i) {
            class_243 vertex = vertexes[i];
            double x = vertex.method_1020(originPos).method_1026(this.axisW);
            double y = vertex.method_1020(originPos).method_1026(this.axisH);
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        return this.isLocalBoxInShape(minX, minY, maxX, maxY);
    }

    private boolean isLocalBoxInShape(double minX, double minY, double maxX, double maxY) {
        double halfWidth = this.width / 2.0;
        double halfHeight = this.height / 2.0;
        if (!Range.rangeIntersects((double)minX, (double)maxX, (double)(-halfWidth), (double)halfWidth)) {
            return false;
        }
        if (!Range.rangeIntersects((double)minY, (double)maxY, (double)(-halfHeight), (double)halfHeight)) {
            return false;
        }
        if (this.specialShape == null) {
            return true;
        }
        return this.specialShape.boxIntersects(minX / halfWidth, minY / halfHeight, maxX / halfWidth, maxY / halfHeight);
    }

    @Override
    public PortalLike getPortalLike() {
        return this;
    }

    public record TransformationDesc(class_5321<class_1937> dimensionTo, Matrix4d fullSpaceTransformation, DQuaternion rotation, double scaling) {
        public static boolean isRoughlyEqual(TransformationDesc a, TransformationDesc b) {
            if (a.dimensionTo != b.dimensionTo) {
                return false;
            }
            Matrix4d diff = new Matrix4d().set((Matrix4dc)a.fullSpaceTransformation).sub((Matrix4dc)b.fullSpaceTransformation);
            double diffSquareSum = diff.m00() * diff.m00() + diff.m01() * diff.m01() + diff.m02() * diff.m02() + diff.m03() * diff.m03() + diff.m10() * diff.m10() + diff.m11() * diff.m11() + diff.m12() * diff.m12() + diff.m13() * diff.m13() + diff.m20() * diff.m20() + diff.m21() * diff.m21() + diff.m22() * diff.m22() + diff.m23() * diff.m23() + diff.m30() * diff.m30() + diff.m31() * diff.m31() + diff.m32() * diff.m32() + diff.m33() * diff.m33();
            return diffSquareSum < 0.1;
        }
    }

    public static class RemoteCallables {
        public static void acceptPortalDataSync(class_5321<class_1937> dim, int entityId, class_243 pos, class_2487 customData) {
            class_638 world = ClientWorldLoader.getWorld(dim);
            class_1297 entity = world.method_8469(entityId);
            if (entity instanceof Portal) {
                Portal portal = (Portal)entity;
                portal.acceptDataSync(pos, customData);
            } else {
                Helper.err((Object)("missing portal entity to sync " + entityId));
            }
        }
    }
}

