/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1667;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2881;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.mixin.common.miscellaneous.IEEndDragonFight;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;

public class EndPortalEntity
extends Portal {
    private static final Logger LOGGER = LogManager.getLogger(EndPortalEntity.class);
    public static final class_1299<EndPortalEntity> entityType = Portal.createPortalEntityType(EndPortalEntity::new);
    public static final String PORTAL_TAG_VIEW_BOX = "view_box";
    private EndPortalEntity clientFakedReversePortal;

    public EndPortalEntity(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
        this.renderingMergable = true;
        this.hasCrossPortalCollision = false;
    }

    public static void onEndPortalComplete(class_3218 world, class_243 portalCenter) {
        class_3218 endDim = MiscHelper.getServer().method_3847(class_1937.field_25181);
        if (endDim == null) {
            return;
        }
        if (IPGlobal.endPortalMode == IPGlobal.EndPortalMode.normal) {
            EndPortalEntity.generateClassicalEndPortal(world, new class_243(0.0, 120.0, 0.0), portalCenter);
        } else if (IPGlobal.endPortalMode == IPGlobal.EndPortalMode.toObsidianPlatform) {
            class_2338 endSpawnPos = class_3218.field_25144;
            EndPortalEntity.generateClassicalEndPortal(world, class_243.method_24953((class_2382)endSpawnPos).method_1031(0.0, 1.0, 0.0), portalCenter);
        } else if (IPGlobal.endPortalMode == IPGlobal.EndPortalMode.scaledView) {
            EndPortalEntity.generateScaledViewEndPortal(world, portalCenter);
        } else {
            Helper.err((Object)"End portal mode abnormal");
        }
        class_3218.method_29200((class_3218)world);
        class_2881 dragonFight = world.method_29198();
        if (dragonFight == null) {
            return;
        }
        if (((IEEndDragonFight)dragonFight).ip_getNeedsStateScanning()) {
            ((IEEndDragonFight)dragonFight).ip_scanState();
        }
    }

    private static void generateClassicalEndPortal(class_3218 world, class_243 destination, class_243 portalCenter) {
        EndPortalEntity portal = new EndPortalEntity(entityType, (class_1937)world);
        portal.method_5814(portalCenter.field_1352, portalCenter.field_1351, portalCenter.field_1350);
        portal.setDestination(destination);
        portal.dimensionTo = class_1937.field_25181;
        portal.axisW = new class_243(0.0, 0.0, 1.0);
        portal.axisH = new class_243(1.0, 0.0, 0.0);
        portal.width = 3.0;
        portal.height = 3.0;
        world.method_8649((class_1297)portal);
    }

    private static void generateScaledViewEndPortal(class_3218 world, class_243 portalCenter) {
        class_3218 endWorld = McHelper.getServerWorld((class_5321<class_1937>)class_1937.field_25181);
        double d = 3.0;
        class_243 viewBoxSize = new class_243(d, 1.2, d);
        double scale = 280.0 / d;
        class_238 thisSideBox = Helper.getBoxByBottomPosAndSize((class_243)portalCenter.method_1031(0.0, 0.0, 0.0), (class_243)viewBoxSize);
        class_238 otherSideBox = Helper.getBoxByBottomPosAndSize((class_243)new class_243(0.0, 0.0, 0.0), (class_243)viewBoxSize.method_1021(scale));
        for (class_2350 direction : class_2350.values()) {
            EndPortalEntity portal = PortalManipulation.createOrthodoxPortal(entityType, world, endWorld, direction, Helper.getBoxSurface((class_238)thisSideBox, (class_2350)direction), Helper.getBoxSurface((class_238)otherSideBox, (class_2350)direction).method_1005());
            portal.scaling = scale;
            portal.teleportChangesScale = false;
            portal.portalTag = PORTAL_TAG_VIEW_BOX;
            portal.setInteractable(false);
            McHelper.spawnServerEntity(portal);
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.tickClient();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void tickClient() {
        if (this.isViewBoxPortal()) {
            class_243 cameraPosVec;
            double dist;
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            if (this.getNormal().field_1351 > 0.5 && ((IEEntity)player).ip_getCollidingPortal() == this && (dist = this.getDistanceToNearestPointInPortal(cameraPosVec = player.method_5836(1.0f))) < 1.0) {
                double mul = dist / 2.0 + 0.1;
                player.method_18800(player.method_18798().field_1352 * mul, player.method_18798().field_1351 * mul, player.method_18798().field_1350 * mul);
            }
            this.fuseView = true;
        }
    }

    @Override
    public void onEntityTeleportedOnServer(class_1297 entity) {
        super.onEntityTeleportedOnServer(entity);
        if (this.shouldAddSlowFalling(entity)) {
            int duration = 200;
            if (this.isViewBoxPortal()) {
                duration = 300;
            }
            class_1309 livingEntity = (class_1309)entity;
            livingEntity.method_6092(new class_1293(class_1294.field_5906, duration, 1));
        }
        class_3218 endWorld = MiscHelper.getServer().method_3847(class_1937.field_25181);
        class_3218.method_29200((class_3218)endWorld);
    }

    private boolean isViewBoxPortal() {
        return Objects.equals(this.portalTag, PORTAL_TAG_VIEW_BOX);
    }

    @Override
    public class_243 transformVelocityRelativeToPortal(class_243 originalVelocityRelativeToPortal, class_1297 entity) {
        if (this.isViewBoxPortal()) {
            return class_243.field_1353;
        }
        return super.transformVelocityRelativeToPortal(originalVelocityRelativeToPortal, entity);
    }

    @Override
    public boolean canTeleportEntity(class_1297 entity) {
        if (entity instanceof class_1667) {
            return false;
        }
        return super.canTeleportEntity(entity);
    }

    private boolean shouldAddSlowFalling(class_1297 entity) {
        if (entity instanceof class_1309) {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                if (player.field_13974.method_14257() == class_1934.field_9220) {
                    return false;
                }
                if (player.method_6118(class_1304.field_6174).method_7909() == class_1802.field_8833) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldLimitBoundingBox() {
        return false;
    }

    @Override
    public void onCollidingWithEntity(class_1297 entity) {
        if (!this.method_37908().method_8608() && entity instanceof class_3222 && IPGlobal.endPortalMode == IPGlobal.EndPortalMode.toObsidianPlatform) {
            class_3218 endWorld = MiscHelper.getServer().method_3847(class_1937.field_25181);
            class_3218.method_29200((class_3218)endWorld);
        }
    }
}

