/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific;

import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_155;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_631;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlClientChunkMap;
import qouteall.imm_ptl.core.platform_specific.RequiemCompat;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;

public class O_O {
    public static boolean isDimensionalThreadingPresent = false;
    private static final class_2680 obsidianState = class_2246.field_10540.method_9564();

    public static boolean isForge() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static void onPlayerChangeDimensionClient(class_5321<class_1937> from, class_5321<class_1937> to) {
        RequiemCompat.onPlayerTeleportedClient();
    }

    public static void onPlayerTravelOnServer(class_3222 player, class_5321<class_1937> from, class_5321<class_1937> to) {
        RequiemCompat.onPlayerTeleportedServer(player);
    }

    public static Path getGameDir() {
        return FabricLoader.getInstance().getGameDir();
    }

    public static boolean isObsidian(class_2680 blockState) {
        return blockState == obsidianState;
    }

    public static void postClientChunkLoadEvent(class_2818 chunk) {
        ((ClientChunkEvents.Load)ClientChunkEvents.CHUNK_LOAD.invoker()).onChunkLoad((class_638)chunk.method_12200(), chunk);
    }

    public static void postClientChunkUnloadEvent(class_2818 chunk) {
        ((ClientChunkEvents.Unload)ClientChunkEvents.CHUNK_UNLOAD.invoker()).onChunkUnload((class_638)chunk.method_12200(), chunk);
    }

    public static boolean isDedicatedServer() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    public static void postPortalSpawnEventForge(PortalGenInfo info) {
    }

    @Environment(value=EnvType.CLIENT)
    public static class_631 createMyClientChunkManager(class_638 world, int loadDistance) {
        return new ImmPtlClientChunkMap(world, loadDistance);
    }

    public static boolean getIsPehkuiPresent() {
        return FabricLoader.getInstance().isModLoaded("pehkui");
    }

    @Nullable
    public static String getImmPtlModInfoUrl() {
        String gameVersion = class_155.method_16673().method_48019();
        if (O_O.isForge()) {
            return "https://qouteall.fun/immptl_info/forge-%s.json".formatted(gameVersion);
        }
        return "https://qouteall.fun/immptl_info/%s.json".formatted(gameVersion);
    }

    public static boolean isModLoadedWithinVersion(String modId, @Nullable String startVersion, @Nullable String endVersion) {
        Optional modContainer = FabricLoader.getInstance().getModContainer(modId);
        if (modContainer.isPresent()) {
            Version version = ((ModContainer)modContainer.get()).getMetadata().getVersion();
            try {
                int i;
                if (startVersion != null && (i = Version.parse((String)startVersion).compareTo((Object)version)) > 0) {
                    return false;
                }
                if (endVersion != null && (i = Version.parse((String)endVersion).compareTo((Object)version)) < 0) {
                    return false;
                }
            }
            catch (VersionParsingException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static String getImmPtlVersion() {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            return null;
        }
        return ((ModContainer)FabricLoader.getInstance().getModContainer("imm_ptl_core").get()).getMetadata().getVersion().toString();
    }

    public static boolean shouldUpdateImmPtl(String latestReleaseVersion) {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            return false;
        }
        Version currentVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("imm_ptl_core").get()).getMetadata().getVersion();
        try {
            Version latestVersion = Version.parse((String)latestReleaseVersion);
            if (latestVersion.compareTo((Object)currentVersion) > 0) {
                return true;
            }
        }
        catch (VersionParsingException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getModDownloadLink() {
        return "https://modrinth.com/mod/immersiveportals";
    }

    public static String getIssueLink() {
        return "https://github.com/iPortalTeam/ImmersivePortalsMod/issues";
    }

    @Nullable
    public static class_2960 getModIconLocation(String modid) {
        String[] parts;
        String path = FabricLoader.getInstance().getModContainer(modid).flatMap(c -> c.getMetadata().getIconPath(512)).orElse(null);
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith("assets")) {
            path = path.substring("assets".length());
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((parts = path.split("/")).length != 2) {
            return null;
        }
        return new class_2960(parts[0], parts[1]);
    }

    @Nullable
    public static String getModName(String modid) {
        return FabricLoader.getInstance().getModContainer(modid).map(c -> c.getMetadata().getName()).orElse(null);
    }

    public static boolean isQuilt() {
        return FabricLoader.getInstance().isModLoaded("quilted_fabric_api");
    }
}

