/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific;

import java.util.Arrays;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.IPModMainClient;
import qouteall.imm_ptl.core.compat.IPModInfoChecking;
import qouteall.imm_ptl.core.compat.iris_compatibility.ExperimentalIrisPortalRenderer;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.BreakableMirror;
import qouteall.imm_ptl.core.portal.EndPortalEntity;
import qouteall.imm_ptl.core.portal.LoadingIndicatorEntity;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalTrackedPortal;
import qouteall.imm_ptl.core.portal.global_portals.VerticalConnectingPortal;
import qouteall.imm_ptl.core.portal.global_portals.WorldWrappingPortal;
import qouteall.imm_ptl.core.portal.nether_portal.GeneralBreakablePortal;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalEntity;
import qouteall.imm_ptl.core.render.LoadingIndicatorRenderer;
import qouteall.imm_ptl.core.render.PortalEntityRenderer;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.MyTaskList;

public class IPModEntryClient
implements ClientModInitializer {
    public static void initPortalRenderers() {
        Arrays.stream(new class_1299[]{Portal.entityType, NetherPortalEntity.entityType, EndPortalEntity.entityType, Mirror.entityType, BreakableMirror.entityType, GlobalTrackedPortal.entityType, WorldWrappingPortal.entityType, VerticalConnectingPortal.entityType, GeneralBreakablePortal.entityType}).peek(Validate::notNull).forEach(entityType -> EntityRendererRegistry.register((class_1299)entityType, PortalEntityRenderer::new));
        EntityRendererRegistry.register(LoadingIndicatorEntity.entityType, LoadingIndicatorRenderer::new);
    }

    public void onInitializeClient() {
        IPModMainClient.init();
        IPModEntryClient.initPortalRenderers();
        boolean isSodiumPresent = FabricLoader.getInstance().isModLoaded("sodium");
        if (isSodiumPresent) {
            Helper.log((Object)"Sodium is present");
            SodiumInterface.invoker = new SodiumInterface.OnSodiumPresent();
        } else {
            Helper.log((Object)"Sodium is not present");
        }
        if (FabricLoader.getInstance().isModLoaded("iris")) {
            Helper.log((Object)"Iris is present");
            IrisInterface.invoker = new IrisInterface.OnIrisPresent();
            ExperimentalIrisPortalRenderer.init();
            IPGlobal.clientTaskList.addTask(MyTaskList.oneShotTask(() -> {
                if (IPConfig.getConfig().shouldDisplayWarning("iris")) {
                    CHelper.printChat((class_2561)class_2561.method_43471((String)"imm_ptl.iris_warning").method_10852(IPMcHelper.getDisableWarningText("iris")));
                }
            }));
        } else {
            Helper.log((Object)"Iris is not present");
        }
        IPModInfoChecking.initClient();
    }
}

