/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2539;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2602;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5321;
import net.minecraft.class_8037;
import net.minecraft.class_8042;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qouteall.imm_ptl.core.ducks.IECustomPayloadPacket;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.network.PacketRedirectionClient;

public class PacketRedirection {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketRedirection.class);
    public static final class_2960 id_stcRedirected = new class_2960("imm_ptl", "rd");
    private static final ThreadLocal<class_5321<class_1937>> serverPacketRedirection = ThreadLocal.withInitial(() -> null);
    private static final class_2540 dummyByteBuf = new class_2540(Unpooled.buffer());

    public static boolean isPacketIdOfRedirection(class_2960 packetTypeId) {
        return packetTypeId.method_12836().equals("imm_ptl") && packetTypeId.method_12832().equals("rd");
    }

    public static void withForceRedirect(class_3218 world, Runnable func) {
        PacketRedirection.withForceRedirectAndGet(world, () -> {
            func.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withForceRedirectAndGet(class_3218 world, Supplier<T> func) {
        if (((IEWorld)world).portal_getThread() != Thread.currentThread()) {
            LOGGER.error("It's possible that a mod is trying to handle packet in networking thread instead of server thread. This is not thread safe and can cause rare bugs! (ImmPtl is just doing checking, it's not an issue of ImmPtl)", new Throwable());
        }
        class_5321<class_1937> oldRedirection = serverPacketRedirection.get();
        serverPacketRedirection.set((class_5321<class_1937>)world.method_27983());
        try {
            T t = func.get();
            return t;
        }
        finally {
            serverPacketRedirection.set(oldRedirection);
        }
    }

    @Nullable
    public static class_5321<class_1937> getForceRedirectDimension() {
        return serverPacketRedirection.get();
    }

    public static void sendRedirectedPacket(class_3244 serverPlayNetworkHandler, class_2596<class_2602> packet, class_5321<class_1937> dimension) {
        if (PacketRedirection.getForceRedirectDimension() == dimension) {
            serverPlayNetworkHandler.method_14364(packet);
        } else {
            serverPlayNetworkHandler.method_14364(PacketRedirection.createRedirectedMessage(dimension, packet));
        }
    }

    public static void validateForceRedirecting() {
        Validate.isTrue((PacketRedirection.getForceRedirectDimension() != null ? 1 : 0) != 0);
    }

    public static void do_handleRedirectedPacket(class_5321<class_1937> dimension, class_2596<class_2602> packet, class_2602 handler) {
        PacketRedirectionClient.handleRedirectedPacket(dimension, packet, handler);
    }

    public static class_2596<class_2602> createRedirectedMessage(class_5321<class_1937> dimension, class_2596<class_2602> packet) {
        Validate.isTrue((!(packet instanceof class_8037) ? 1 : 0) != 0);
        if (packet instanceof class_8042) {
            class_8042 bundlePacket = (class_8042)packet;
            ArrayList<class_2596<class_2602>> newSubPackets = new ArrayList<class_2596<class_2602>>();
            for (class_2596 subPacket : bundlePacket.method_48324()) {
                newSubPackets.add(PacketRedirection.createRedirectedMessage(dimension, (class_2596<class_2602>)subPacket));
            }
            return new class_8042(newSubPackets);
        }
        class_2658 result = new class_2658(id_stcRedirected, dummyByteBuf);
        ((IECustomPayloadPacket)result).ip_setRedirectedDimension(dimension);
        ((IECustomPayloadPacket)result).ip_setRedirectedPacket(packet);
        return result;
    }

    public static void sendRedirectedMessage(class_3222 player, class_5321<class_1937> dimension, class_2596 packet) {
        player.field_13987.method_14364(PacketRedirection.createRedirectedMessage(dimension, (class_2596<class_2602>)packet));
    }

    public static int getPacketId(class_2596 packet) {
        try {
            return class_2539.field_20591.method_10781(class_2598.field_11942, packet);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class_2596 createPacketById(int messageType, class_2540 buf) {
        return class_2539.field_20591.method_10783(class_2598.field_11942, messageType, buf);
    }
}

