/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.network;

import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.network.IPNetworking;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.teleportation.ClientTeleportationManager;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DimId;
import qouteall.q_misc_util.my_util.SignalArged;

@Environment(value=EnvType.CLIENT)
public class IPNetworkingClient {
    public static final SignalArged<Portal> clientPortalSpawnSignal = new SignalArged();
    private static final class_310 client = class_310.method_1551();

    public static void init() {
    }

    public static boolean handleImmPtlCorePacketClientSide(class_2960 packedId, Supplier<class_2540> buf) {
        if (packedId.equals((Object)IPNetworking.id_stcSpawnEntity)) {
            IPNetworkingClient.processStcSpawnEntity(buf.get());
            return true;
        }
        if (packedId.equals((Object)IPNetworking.id_stcDimensionConfirm)) {
            IPNetworkingClient.processStcDimensionConfirm(buf.get());
            return true;
        }
        if (packedId.equals((Object)IPNetworking.id_stcUpdateGlobalPortal)) {
            IPNetworkingClient.processGlobalPortalUpdate(buf.get());
            return true;
        }
        return false;
    }

    private static void processStcSpawnEntity(class_2540 buf) {
        String entityTypeString = buf.method_19772();
        int entityId = buf.readInt();
        class_5321 dim = DimId.readWorldId((class_2540)buf, (boolean)true);
        class_2487 compoundTag = buf.method_10798();
        IPNetworkingClient.processEntitySpawn(entityTypeString, entityId, (class_5321<class_1937>)dim, compoundTag);
    }

    private static void processStcDimensionConfirm(class_2540 buf) {
        class_5321 dimension = DimId.readWorldId((class_2540)buf, (boolean)true);
        class_243 pos = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        MiscHelper.executeOnRenderThread(() -> ClientTeleportationManager.acceptSynchronizationDataFromServer((class_5321<class_1937>)dimension, pos, false));
    }

    private static void processGlobalPortalUpdate(class_2540 buf) {
        class_5321 dimension = DimId.readWorldId((class_2540)buf, (boolean)true);
        class_2487 compoundTag = buf.method_10798();
        MiscHelper.executeOnRenderThread(() -> GlobalPortalStorage.receiveGlobalPortalSync((class_5321<class_1937>)dimension, compoundTag));
    }

    public static class_2596 createCtsTeleport(class_5321<class_1937> dimensionBefore, class_243 posBefore, UUID portalEntityId) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        DimId.writeWorldId((class_2540)buf, dimensionBefore, (boolean)true);
        buf.writeDouble(posBefore.field_1352);
        buf.writeDouble(posBefore.field_1351);
        buf.writeDouble(posBefore.field_1350);
        buf.method_10797(portalEntityId);
        return new class_2817(IPNetworking.id_ctsTeleport, buf);
    }

    public static void processEntitySpawn(String entityTypeString, int entityId, class_5321<class_1937> dim, class_2487 compoundTag) {
        Optional entityType = class_1299.method_5898((String)entityTypeString);
        if (!entityType.isPresent()) {
            Helper.err((Object)("unknown entity type " + entityTypeString));
            return;
        }
        MiscHelper.executeOnRenderThread(() -> {
            client.method_16011().method_15396("ip_spawn_entity");
            class_638 world = ClientWorldLoader.getWorld(dim);
            class_1297 entity = ((class_1299)entityType.get()).method_5883((class_1937)world);
            entity.method_5651(compoundTag);
            entity.method_5838(entityId);
            entity.method_43391(entity.method_23317(), entity.method_23318(), entity.method_23321());
            world.method_2942(entityId, entity);
            if (entity instanceof Portal) {
                ClientWorldLoader.getWorld(((Portal)entity).dimensionTo);
                clientPortalSpawnSignal.emit((Object)((Portal)entity));
            }
            client.method_16011().method_15407();
        });
    }
}

