/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.position_sync;

import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2708;
import net.minecraft.class_2709;
import net.minecraft.class_2793;
import net.minecraft.class_2828;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEPlayerMoveC2SPacket;
import qouteall.imm_ptl.core.ducks.IEPlayerPositionLookS2CPacket;
import qouteall.imm_ptl.core.ducks.IEServerPlayNetworkHandler;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.LimitedLogger;

@Mixin(value={class_3244.class}, priority=900)
public abstract class MixinServerGamePacketListenerImpl
implements IEServerPlayNetworkHandler {
    @Shadow
    public class_3222 field_14140;
    @Shadow
    private class_243 field_14119;
    @Shadow
    private int field_14123;
    @Shadow
    private int field_14139;
    @Shadow
    private int field_14118;
    @Shadow
    private double field_14122;
    @Shadow
    private double field_14141;
    @Shadow
    private double field_14120;
    @Shadow
    private double field_14143;
    @Shadow
    private double field_14124;
    @Shadow
    private double field_14142;
    @Shadow
    @Final
    public class_2535 field_14127;
    @Shadow
    @Final
    private MinecraftServer field_14148;
    @Shadow
    private class_1297 field_14147;
    @Shadow
    private boolean field_14129;
    @Shadow
    @Final
    private static Logger field_14121;
    private static LimitedLogger ip_limitedLogger;
    private int ip_dubiousMoveCount = 0;

    @Shadow
    protected abstract boolean method_19507();

    @Shadow
    public abstract void method_14367(class_2561 var1);

    @Inject(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleMovePlayer(Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;)V"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/server/level/ServerLevel;)V")}, cancellable=true)
    private void onProcessMovePacket(class_2828 packet, CallbackInfo ci) {
        class_5321<class_1937> packetDimension = ((IEPlayerMoveC2SPacket)packet).getPlayerDimension();
        if (packetDimension == null) {
            Helper.err((Object)"Player move packet is missing dimension info. Maybe the player client doesn't have ImmPtl");
            IPGlobal.serverTaskList.addTask(() -> {
                this.field_14140.field_13987.method_14367((class_2561)class_2561.method_43470((String)"The client does not have Immersive Portals mod"));
                return true;
            });
            return;
        }
        if (IPGlobal.serverTeleportationManager.isJustTeleported((class_1297)this.field_14140, 100L)) {
            this.cancelTeleportRequest();
        }
        if (this.field_14140.method_37908().method_27983() != packetDimension) {
            ip_limitedLogger.lInfo(field_14121, "[ImmPtl] Ignoring player move packet %s %s".formatted(this.field_14140, packetDimension.method_29177()), new Object[0]);
            ++this.ip_dubiousMoveCount;
            if (this.ip_dubiousMoveCount > 200) {
                field_14121.info("[ImmPtl] Force move player {} {} {}", new Object[]{this.field_14140, this.field_14140.method_37908().method_27983().method_29177(), this.field_14140.method_19538()});
                IPGlobal.serverTeleportationManager.forceTeleportPlayer(this.field_14140, (class_5321<class_1937>)this.field_14140.method_37908().method_27983(), this.field_14140.method_19538());
                this.ip_dubiousMoveCount = 0;
            }
            ci.cancel();
        } else {
            this.ip_dubiousMoveCount = 0;
        }
    }

    @Redirect(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleMovePlayer(Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;isSingleplayerOwner()Z"))
    private boolean redirectIsServerOwnerOnPlayerMove(class_3244 serverPlayNetworkHandler) {
        if (MixinServerGamePacketListenerImpl.shouldAcceptDubiousMovement(this.field_14140)) {
            return true;
        }
        return this.method_19507();
    }

    @Redirect(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleMovePlayer(Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isChangingDimension()Z"), require=0)
    private boolean redirectIsInTeleportationState(class_3222 player) {
        if (MixinServerGamePacketListenerImpl.shouldAcceptDubiousMovement(player)) {
            return true;
        }
        return player.method_14208();
    }

    @Overwrite
    @IPVanillaCopy
    public void method_14360(double x, double y, double z, float yaw, float pitch, Set<class_2709> nonRelative) {
        if (this.field_14140.method_35049() != null) {
            Helper.err((Object)"Tries to send player pos packet to a removed player");
            new Throwable().printStackTrace();
            return;
        }
        double xDiff = nonRelative.contains(class_2709.field_12400) ? this.field_14140.method_23317() : 0.0;
        double yDiff = nonRelative.contains(class_2709.field_12398) ? this.field_14140.method_23318() : 0.0;
        double zDiff = nonRelative.contains(class_2709.field_12403) ? this.field_14140.method_23321() : 0.0;
        float yawDiff = nonRelative.contains(class_2709.field_12401) ? this.field_14140.method_36454() : 0.0f;
        float pitchDiff = nonRelative.contains(class_2709.field_12397) ? this.field_14140.method_36455() : 0.0f;
        this.field_14119 = new class_243(x, y, z);
        if (++this.field_14123 == Integer.MAX_VALUE) {
            this.field_14123 = 0;
        }
        this.field_14139 = this.field_14118;
        this.field_14140.method_5641(x, y, z, yaw, pitch);
        class_2708 lookPacket = new class_2708(x - xDiff, y - yDiff, z - zDiff, yaw - yawDiff, pitch - pitchDiff, nonRelative, this.field_14123);
        ((IEPlayerPositionLookS2CPacket)lookPacket).setPlayerDimension((class_5321<class_1937>)this.field_14140.method_37908().method_27983());
        this.field_14140.field_13987.method_14364((class_2596)lookPacket);
    }

    @Inject(method={"isPlayerCollidingWithAnythingNew"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsPlayerCollidingWithAnythingNew(class_4538 levelReader, class_238 aABB, double d, double e, double f, CallbackInfoReturnable<Boolean> cir) {
        if (MixinServerGamePacketListenerImpl.shouldAcceptDubiousMovement(this.field_14140)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleAcceptTeleportPacket(Lnet/minecraft/network/protocol/game/ServerboundAcceptTeleportationPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onOnTeleportConfirm(class_2793 packet, CallbackInfo ci) {
        if (this.field_14119 == null) {
            ci.cancel();
        }
    }

    private static boolean shouldAcceptDubiousMovement(class_3222 player) {
        if (IPGlobal.serverTeleportationManager.isJustTeleported((class_1297)player, 100L)) {
            return true;
        }
        if (IPGlobal.looseMovementCheck) {
            return true;
        }
        if (((IEEntity)player).ip_isRecentlyCollidingWithPortal()) {
            return true;
        }
        boolean portalsNearby = IPMcHelper.getNearbyPortals((class_1297)player, 16.0).findFirst().isPresent();
        return portalsNearby;
    }

    @Override
    public void cancelTeleportRequest() {
        this.field_14119 = null;
    }

    static {
        ip_limitedLogger = new LimitedLogger(20);
    }
}

