/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.client.render.shader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import net.minecraft.class_281;
import net.minecraft.class_5913;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import qouteall.imm_ptl.core.render.ShaderCodeTransformation;

@Mixin(value={class_281.class})
public class MixinProgram {
    private static final ThreadLocal<class_281.class_282> ip_programType = new ThreadLocal();
    private static final ThreadLocal<String> ip_programName = new ThreadLocal();

    @Inject(method={"compileShaderInternal"}, at={@At(value="HEAD")})
    private static void onBeginCompileShaderInternal(class_281.class_282 type, String name, InputStream shaderData, String sourceName, class_5913 preprocessor, CallbackInfoReturnable<Integer> cir) {
        Validate.isTrue((ip_programType.get() == null ? 1 : 0) != 0);
        Validate.isTrue((ip_programName.get() == null ? 1 : 0) != 0);
        ip_programType.set(type);
        ip_programName.set(name);
    }

    @Inject(method={"compileShaderInternal"}, at={@At(value="RETURN")})
    private static void onEndCompileShaderInternal(class_281.class_282 type, String name, InputStream shaderData, String sourceName, class_5913 preprocessor, CallbackInfoReturnable<Integer> cir) {
        Validate.isTrue((ip_programType.get() == type ? 1 : 0) != 0);
        Validate.isTrue((boolean)Objects.equals(ip_programName.get(), name));
        ip_programType.set(null);
        ip_programName.set(null);
    }

    @Redirect(method={"compileShaderInternal"}, at=@At(value="INVOKE", target="Lorg/apache/commons/io/IOUtils;toString(Ljava/io/InputStream;Ljava/nio/charset/Charset;)Ljava/lang/String;", remap=false))
    private static String redirectReadShaderSource(InputStream inputStream, Charset charset) throws IOException {
        String shaderCode = IOUtils.toString((InputStream)inputStream, (Charset)charset);
        class_281.class_282 type = ip_programType.get();
        String name = ip_programName.get();
        Validate.notNull((Object)type);
        Validate.notNull((Object)name);
        String transformedShaderCode = ShaderCodeTransformation.transform(type, name, shaderCode);
        return transformedShaderCode;
    }
}

