/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_291;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_769;
import net.minecraft.class_846;
import net.minecraft.class_898;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.render.CrossPortalEntityRenderer;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.MyBuiltChunkStorage;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.VisibleSectionDiscovery;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;

@Mixin(value={class_761.class})
public abstract class MixinLevelRenderer
implements IEWorldRenderer {
    @Shadow
    private class_638 field_4085;
    @Shadow
    @Final
    private class_898 field_4109;
    @Shadow
    @Final
    private class_310 field_4088;
    @Shadow
    private class_769 field_4112;
    @Shadow
    private class_846 field_4106;
    @Shadow
    private class_279 field_25279;
    @Mutable
    @Shadow
    @Final
    private class_4599 field_20951;
    @Shadow
    private int field_4062;
    @Shadow
    @Nullable
    private class_276 field_25274;
    @Shadow
    private class_4604 field_27740;
    @Shadow
    @Nullable
    private class_291 field_4113;
    @Shadow
    @Nullable
    private class_291 field_4087;
    @Shadow
    @Nullable
    private class_291 field_4102;
    @Shadow
    @Nullable
    private class_291 field_4094;
    @Mutable
    @Shadow
    @Final
    private ObjectArrayList<class_761.class_762> field_34807;

    @Shadow
    protected abstract void method_22977(class_1297 var1, double var2, double var4, double var6, float var8, class_4587 var9, class_4597 var10);

    @Shadow
    protected abstract void method_29701();

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/DimensionSpecialEffects;constantAmbientLight()Z")})
    private void onAfterCutoutRendering(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        CrossPortalEntityRenderer.onBeginRenderingEntities(matrices);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/Sheets;translucentCullBlockSheet()Lnet/minecraft/client/renderer/RenderType;")})
    private void onMyBeforeTranslucentRendering(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        IPCGlobal.renderer.onBeforeTranslucentRendering(matrices);
        MyGameRenderer.updateFogColor();
        MyGameRenderer.resetFogState();
        MyGameRenderer.resetDiffuseLighting(matrices);
        FrontClipping.disableClipping();
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;endLastBatch()V")})
    private void onEndRenderingEntities(class_4587 poseStack, float partialTick, long finishNanoTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f projectionMatrix, CallbackInfo ci) {
        CrossPortalEntityRenderer.onEndRenderingEntities(poseStack);
    }

    @Inject(method={"renderLevel"}, at={@At(value="RETURN")})
    private void onAfterTranslucentRendering(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        IPCGlobal.renderer.onAfterTranslucentRendering(matrices);
        class_308.method_27869((Matrix4f)matrices.method_23760().method_23761());
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderChunkLayer(Lnet/minecraft/client/renderer/RenderType;Lcom/mojang/blaze3d/vertex/PoseStack;DDDLorg/joml/Matrix4f;)V")})
    private void onBeforeRenderingLayer(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            FrontClipping.setupInnerClipping(PortalRendering.getActiveClippingPlane(), matrices.method_23760().method_23761(), -0.01);
            if (PortalRendering.isRenderingOddNumberOfMirrors()) {
                MyRenderHelper.applyMirrorFaceCulling();
            }
            if (IPGlobal.enableDepthClampForPortalRendering) {
                CHelper.enableDepthClamp();
            }
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderChunkLayer(Lnet/minecraft/client/renderer/RenderType;Lcom/mojang/blaze3d/vertex/PoseStack;DDDLorg/joml/Matrix4f;)V", shift=At.Shift.AFTER)})
    private void onAfterRenderingLayer(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            FrontClipping.disableClipping();
            MyRenderHelper.recoverFaceCulling();
            if (IPGlobal.enableDepthClampForPortalRendering) {
                CHelper.disableDepthClamp();
            }
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/LevelRenderer;setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetupTerrainBegin(class_4184 camera, class_4604 frustum, boolean hasForcedFrustum, boolean spectator, CallbackInfo ci) {
        if (WorldRenderInfo.isRendering() && this.field_4085.method_27983() != RenderStates.originalPlayerDimension) {
            this.field_4106.method_19419(camera.method_19326());
        }
        if (this.ip_allowOverrideTerrainSetup() && WorldRenderInfo.isRendering()) {
            this.field_4085.method_16107().method_15396("ip_terrain_setup");
            VisibleSectionDiscovery.discoverVisibleSections(this.field_4085, (MyBuiltChunkStorage)this.field_4112, camera, new class_4604(frustum).method_38557(8), this.field_34807);
            this.field_4085.method_16107().method_15407();
            ci.cancel();
        }
    }

    private boolean ip_allowOverrideTerrainSetup() {
        return !SodiumInterface.invoker.isSodiumPresent() && !IrisInterface.invoker.isRenderingShadowMap();
    }

    @Inject(method={"Lnet/minecraft/client/renderer/LevelRenderer;setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"}, at={@At(value="RETURN")}, cancellable=true)
    private void onSetupTerrainEnd(class_4184 camera, class_4604 frustum, boolean hasForcedFrustum, boolean spectator, CallbackInfo ci) {
        if (!WorldRenderInfo.isRendering() && this.ip_allowOverrideTerrainSetup()) {
            if (MyGameRenderer.vanillaTerrainSetupOverride > 0) {
                --MyGameRenderer.vanillaTerrainSetupOverride;
                this.field_4085.method_16107().method_15396("ip_terrain_setup");
                VisibleSectionDiscovery.discoverVisibleSections(this.field_4085, (MyBuiltChunkStorage)this.field_4112, camera, new class_4604(frustum).method_38557(8), this.field_34807);
                this.field_4085.method_16107().method_15407();
            } else if (IPGlobal.alwaysOverrideTerrainSetup) {
                this.field_4085.method_16107().method_15396("ip_terrain_setup_debug");
                VisibleSectionDiscovery.discoverVisibleSections(this.field_4085, (MyBuiltChunkStorage)this.field_4112, camera, new class_4604(frustum).method_38557(8), this.field_34807);
                this.field_4085.method_16107().method_15407();
            }
        }
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;clear(IZ)V", remap=false))
    private void redirectClearing(int int_1, boolean boolean_1) {
        if (!IPCGlobal.renderer.replaceFrameBufferClearing()) {
            RenderSystem.clear((int)int_1, (boolean)boolean_1);
        }
    }

    @Redirect(method={"allChanged"}, at=@At(value="NEW", target="net/minecraft/client/renderer/ViewArea"))
    private class_769 redirectConstructingBuildChunkStorage(class_846 chunkBuilder_1, class_1937 world_1, int int_1, class_761 worldRenderer_1) {
        if (IPCGlobal.useHackedChunkRenderDispatcher) {
            return new MyBuiltChunkStorage(chunkBuilder_1, world_1, int_1, worldRenderer_1);
        }
        return new class_769(chunkBuilder_1, world_1, int_1, worldRenderer_1);
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderEntity(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V"))
    private void redirectRenderEntity(class_761 worldRenderer, class_1297 entity, double cameraX, double cameraY, double cameraZ, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider) {
        CrossPortalEntityRenderer.beforeRenderingEntity(entity, matrixStack);
        this.method_22977(entity, cameraX, cameraY, cameraZ, tickDelta, matrixStack, vertexConsumerProvider);
        CrossPortalEntityRenderer.afterRenderingEntity(entity);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V")})
    private void beforeRenderingWeather(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            FrontClipping.setupInnerClipping(PortalRendering.getActiveClippingPlane(), matrices.method_23760().method_23761(), 0.0);
            RenderStates.isRenderingPortalWeather = true;
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V", shift=At.Shift.AFTER)})
    private void afterRenderingWeather(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        if (PortalRendering.isRendering()) {
            FrontClipping.disableClipping();
            RenderStates.isRenderingPortalWeather = false;
        }
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;shouldEntityAppearGlowing(Lnet/minecraft/world/entity/Entity;)Z"))
    private boolean redirectGlowing(class_310 client, class_1297 entity) {
        if (WorldRenderInfo.isRendering()) {
            return false;
        }
        return client.method_27022(entity);
    }

    @Inject(method={"allChanged"}, at={@At(value="HEAD")}, cancellable=true)
    private void onReloadStarted(CallbackInfo ci) {
        if (WorldRenderInfo.isRendering()) {
            Helper.log((Object)"world renderer reloading cancelled during portal rendering");
            ci.cancel();
        }
    }

    @Inject(method={"allChanged"}, at={@At(value="TAIL")})
    private void onReloadFinished(CallbackInfo ci) {
        class_761 this_ = (class_761)this;
        if (ClientWorldLoader.getIsCreatingClientWorld()) {
            return;
        }
        Validate.isTrue((class_310.method_1551().field_1769 == this_ ? 1 : 0) != 0);
        ClientWorldLoader._onWorldRendererReloaded();
    }

    @Inject(method={"renderSky"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderSkyBegin(class_4587 poseStack, Matrix4f matrix4f, float partialTick, class_4184 camera, boolean isFoggy, Runnable runnable, CallbackInfo ci) {
        if (WorldRenderInfo.isRendering() && !WorldRenderInfo.getTopRenderInfo().doRenderSky && !IrisInterface.invoker.isShaders()) {
            ci.cancel();
        }
        if (PortalRendering.isRenderingOddNumberOfMirrors()) {
            MyRenderHelper.applyMirrorFaceCulling();
        }
    }

    @Inject(method={"renderSky"}, at={@At(value="RETURN")})
    private void onRenderSkyEnd(class_4587 poseStack, Matrix4f matrix4f, float f, class_4184 camera, boolean bl, Runnable runnable, CallbackInfo ci) {
        MyRenderHelper.recoverFaceCulling();
    }

    @Redirect(method={"renderSky"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"))
    private class_243 redirectGetEyePositionInSkyRendering(class_746 player, float partialTicks) {
        if (WorldRenderInfo.isRendering()) {
            return WorldRenderInfo.getCameraPos();
        }
        return player.method_5836(partialTicks);
    }

    @Inject(method={"prepareCullFrustum"}, at={@At(value="HEAD")})
    private void onSetupFrustum(class_4587 matrices, class_243 pos, Matrix4f projectionMatrix, CallbackInfo ci) {
        TransformationManager.processTransformation(this.field_4088.field_1773.method_19418(), matrices);
    }

    @Redirect(method={"renderLevel"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;translucentTarget:Lcom/mojang/blaze3d/pipeline/RenderTarget;"))
    private class_276 redirectTranslucentFramebuffer(class_761 this_) {
        if (PortalRendering.isRendering()) {
            return null;
        }
        return this.field_25274;
    }

    @ModifyVariable(method={"Lnet/minecraft/client/renderer/LevelRenderer;setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V"}, at=@At(value="HEAD"), argsOnly=true, ordinal=1)
    private boolean modifyIsSpectator(boolean value) {
        if (WorldRenderInfo.isRendering()) {
            return true;
        }
        return value;
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;pollLightUpdates()V"))
    private void redirectRunQueuedChunkUpdates(class_638 world) {
        ClientWorldLoader.withSwitchedWorld(world, () -> ((class_638)world).method_38534());
    }

    @Inject(method={"isChunkCompiled"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsChunkCompiled(class_2338 blockPos, CallbackInfoReturnable<Boolean> cir) {
        class_769 class_7692;
        if (PortalRendering.isRendering() && !SodiumInterface.invoker.isSodiumPresent() && (class_7692 = this.field_4112) instanceof MyBuiltChunkStorage) {
            MyBuiltChunkStorage myBuiltChunkStorage = (MyBuiltChunkStorage)class_7692;
            cir.setReturnValue((Object)this.ip_isChunkCompiled(myBuiltChunkStorage, blockPos));
        }
    }

    private boolean ip_isChunkCompiled(MyBuiltChunkStorage myBuiltChunkStorage, class_2338 blockPos) {
        class_4076 sectionPos = class_4076.method_18682((class_2338)blockPos);
        class_846.class_851 renderChunk = myBuiltChunkStorage.rawGet(sectionPos.method_18674(), sectionPos.method_18683(), sectionPos.method_18687());
        return renderChunk != null && renderChunk.field_4459.get() != class_846.class_849.field_4451;
    }

    @Override
    public class_898 ip_getEntityRenderDispatcher() {
        return this.field_4109;
    }

    @Override
    public class_769 ip_getBuiltChunkStorage() {
        return this.field_4112;
    }

    @Override
    public class_846 getChunkBuilder() {
        return this.field_4106;
    }

    @Override
    public void ip_myRenderEntity(class_1297 entity, double cameraX, double cameraY, double cameraZ, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider) {
        this.method_22977(entity, cameraX, cameraY, cameraZ, tickDelta, matrixStack, vertexConsumerProvider);
    }

    @Override
    public class_279 portal_getTransparencyShader() {
        return this.field_25279;
    }

    @Override
    public void portal_setTransparencyShader(class_279 arg) {
        this.field_25279 = arg;
    }

    @Override
    public class_4599 ip_getRenderBuffers() {
        return this.field_20951;
    }

    @Override
    public void ip_setRenderBuffers(class_4599 arg) {
        this.field_20951 = arg;
    }

    @Override
    public class_4604 portal_getFrustum() {
        return this.field_27740;
    }

    @Override
    public void portal_setFrustum(class_4604 arg) {
        this.field_27740 = arg;
    }

    @Override
    public void portal_fullyDispose() {
        this.method_29701();
        if (this.field_4113 != null) {
            this.field_4113.close();
        }
        if (this.field_4087 != null) {
            this.field_4087.close();
        }
        if (this.field_4102 != null) {
            this.field_4102.close();
        }
        if (this.field_4094 != null) {
            this.field_4094.close();
        }
        this.field_4085 = null;
    }

    @Override
    public void portal_setChunkInfoList(ObjectArrayList<class_761.class_762> arg) {
        this.field_34807 = arg;
    }

    @Override
    public ObjectArrayList<class_761.class_762> portal_getChunkInfoList() {
        return this.field_34807;
    }
}

