/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.miscellaneous;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.commands.PortalDebugCommands;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class GcMonitor {
    private static boolean memoryNotEnough = false;
    private static final WeakHashMap<GarbageCollectorMXBean, Long> lastCollectCount = new WeakHashMap();
    private static final LimitedLogger limitedLogger = new LimitedLogger(3);
    private static final LimitedLogger limitedLogger2 = new LimitedLogger(3);
    private static long lastUpdateTime = 0L;
    private static long lastLongPauseTime = 0L;

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        IPGlobal.preGameRenderSignal.connect(GcMonitor::update);
    }

    public static void initCommon() {
        IPGlobal.postServerTickSignal.connect(() -> {
            MinecraftServer server = MiscHelper.getServer();
            if (server != null && server.method_3816()) {
                GcMonitor.update();
            }
        });
    }

    private static void update() {
        long currTime;
        double longPauseThresholdSeconds = 0.3;
        if (PortalDebugCommands.toMiB(Runtime.getRuntime().maxMemory()) < 2049L) {
            longPauseThresholdSeconds = 0.1;
        }
        if ((currTime = System.nanoTime()) - lastUpdateTime > Helper.secondToNano((double)longPauseThresholdSeconds)) {
            lastLongPauseTime = currTime;
        }
        lastUpdateTime = currTime;
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long currCount = garbageCollectorMXBean.getCollectionCount();
            Long lastCount = lastCollectCount.get(garbageCollectorMXBean);
            lastCollectCount.put(garbageCollectorMXBean, currCount);
            if (lastCount == null || lastCount == currCount) continue;
            GcMonitor.check();
        }
    }

    private static void check() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        double usage = (double)usedMemory / (double)maxMemory;
        double timeFromLongPause = System.nanoTime() - lastLongPauseTime;
        if (PortalDebugCommands.toMiB(freeMemory) < 300L && timeFromLongPause < (double)Helper.secondToNano((double)2.0)) {
            if (memoryNotEnough && !O_O.isDedicatedServer()) {
                GcMonitor.informMemoryNotEnoughClient();
            }
            limitedLogger2.invoke(() -> {
                Helper.err((Object)"Memory not enough. Try to Shrink loading distance or allocate more memory. If this happens with low loading distance, it usually indicates memory leak");
                long maxMemory1 = Runtime.getRuntime().maxMemory();
                long totalMemory1 = Runtime.getRuntime().totalMemory();
                long freeMemory1 = Runtime.getRuntime().freeMemory();
                long usedMemory1 = totalMemory1 - freeMemory1;
                Helper.err((Object)String.format("Memory: % 2d%% %03d/%03dMB", usedMemory1 * 100L / maxMemory1, PortalDebugCommands.toMiB(usedMemory1), PortalDebugCommands.toMiB(maxMemory1)));
            });
            memoryNotEnough = true;
        } else {
            memoryNotEnough = false;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void informMemoryNotEnoughClient() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && client.field_1724.field_6012 > 40) {
            limitedLogger.invoke(() -> CHelper.printChat((class_2561)class_2561.method_43471((String)"imm_ptl.memory_not_enough").method_10852((class_2561)McHelper.getLinkText("https://filmora.wondershare.com/game-recording/how-to-allocate-more-ram-to-minecraft.html"))));
        }
    }

    public static boolean isMemoryNotEnough() {
        return memoryNotEnough;
    }
}

