/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mc_utils;

import java.util.Random;
import java.util.function.IntSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;
import net.minecraft.class_761;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.StableClientTimer;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.q_misc_util.my_util.Circle;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Sphere;

@Environment(value=EnvType.CLIENT)
public class WireRenderingHelper {
    public static void renderSmallCubeFrame(class_4588 vertexConsumer, class_243 cameraPos, class_243 boxCenter, int color, double scale, class_4587 matrixStack) {
        Random random = new Random(color);
        double boxSize = Math.pow(boxCenter.method_1022(cameraPos), 0.3) * 0.09;
        matrixStack.method_22903();
        matrixStack.method_22904(boxCenter.field_1352 - cameraPos.field_1352, boxCenter.field_1351 - cameraPos.field_1351, boxCenter.field_1350 - cameraPos.field_1350);
        matrixStack.method_22905((float)scale, (float)scale, (float)scale);
        DQuaternion rotation = WireRenderingHelper.getRandomSmoothRotation(random);
        double periodLen = 100.0;
        matrixStack.method_22907(rotation.toMcQuaternion());
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        class_761.method_22980((class_4587)matrixStack, (class_4588)vertexConsumer, (double)(-boxSize / 2.0), (double)(-boxSize / 2.0), (double)(-boxSize / 2.0), (double)(boxSize / 2.0), (double)(boxSize / 2.0), (double)(boxSize / 2.0), (float)red, (float)green, (float)blue, (float)alpha);
        matrixStack.method_22909();
    }

    public static DQuaternion getRandomSmoothRotation(Random random) {
        double time = (double)StableClientTimer.getStableTickTime() + (double)StableClientTimer.getStablePartialTicks();
        DQuaternion rotation = DQuaternion.identity;
        for (int i = 0; i < 6; ++i) {
            rotation = rotation.hamiltonProduct(DQuaternion.rotationByDegrees((class_243)WireRenderingHelper.randomVec(random), (double)(CHelper.getSmoothCycles(random.nextInt(30, 60)) * 360.0)));
        }
        return rotation;
    }

    public static double getRandomSmoothCycle(Random random) {
        double totalFactor = 0.1;
        double total = 0.0;
        for (int i = 0; i < 5; ++i) {
            double smoothCycle = CHelper.getSmoothCycles(random.nextInt(30, 300));
            double sin = Math.sin(Math.PI * 2 * smoothCycle);
            double factor = random.nextDouble(0.1, 1.0);
            totalFactor += factor;
            total += sin * factor;
        }
        return total / totalFactor;
    }

    @NotNull
    public static class_243 randomVec(Random random) {
        return new class_243(random.nextDouble() - 0.5, random.nextDouble() - 0.5, random.nextDouble() - 0.5);
    }

    public static void renderPlane(class_4588 vertexConsumer, class_243 cameraPos, Plane plane, double renderedPlaneScale, int color, class_4587 matrixStack) {
        class_243 lineEnd;
        class_243 lineStart;
        class_243 anyVecNonNormal;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_243 planeCenter = plane.pos();
        class_243 normal = plane.normal();
        if (Math.abs(normal.method_1026(anyVecNonNormal = new class_243(13.0, 29.0, 71.0).method_1029())) > 0.99) {
            anyVecNonNormal = new class_243(1.0, 0.0, 0.0);
        }
        class_243 planeX = normal.method_1036(anyVecNonNormal).method_1029();
        class_243 planeY = normal.method_1036(planeX).method_1029();
        matrixStack.method_22903();
        matrixStack.method_22904(planeCenter.field_1352 - cameraPos.field_1352, planeCenter.field_1351 - cameraPos.field_1351, planeCenter.field_1350 - cameraPos.field_1350);
        matrixStack.method_22907(DQuaternion.rotationByDegrees((class_243)normal, (double)(CHelper.getSmoothCycles(211L) * 360.0)).toMcQuaternion());
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        double cameraDistanceToCenter = player.method_5836(RenderStates.getPartialTick()).method_1022(planeCenter);
        int lineNumPerSide = 10;
        double lineInterval = cameraDistanceToCenter * 0.2 * renderedPlaneScale;
        double lineLenPerSide = (double)lineNumPerSide * lineInterval;
        for (int ix = -lineNumPerSide; ix <= lineNumPerSide; ++ix) {
            lineStart = planeX.method_1021((double)ix * lineInterval).method_1019(planeY.method_1021(-lineLenPerSide));
            lineEnd = planeX.method_1021((double)ix * lineInterval).method_1019(planeY.method_1021(lineLenPerSide));
            WireRenderingHelper.putLineToLineStrip(vertexConsumer, color, planeY, matrix, lineStart, lineEnd);
        }
        for (int iy = -lineNumPerSide; iy <= lineNumPerSide; ++iy) {
            lineStart = planeY.method_1021((double)iy * lineInterval).method_1019(planeX.method_1021(-lineLenPerSide));
            lineEnd = planeY.method_1021((double)iy * lineInterval).method_1019(planeX.method_1021(lineLenPerSide));
            WireRenderingHelper.putLineToLineStrip(vertexConsumer, color, planeX, matrix, lineStart, lineEnd);
        }
        matrixStack.method_22909();
    }

    public static void renderCircle(class_4588 vertexConsumer, class_243 cameraPos, Circle circle, int color, class_4587 matrixStack) {
        class_243 anyVecNonNormal;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_243 planeCenter = circle.plane().pos();
        class_243 normal = circle.plane().normal();
        if (Math.abs(normal.method_1026(anyVecNonNormal = new class_243(0.0, 1.0, 0.0))) > 0.9) {
            anyVecNonNormal = new class_243(1.0, 0.0, 0.0);
        }
        class_243 planeX = normal.method_1036(anyVecNonNormal).method_1029();
        class_243 planeY = normal.method_1036(planeX).method_1029();
        class_243 circleCenter = circle.circleCenter();
        double circleRadius = circle.radius();
        matrixStack.method_22903();
        matrixStack.method_22904(circleCenter.field_1352 - cameraPos.field_1352, circleCenter.field_1351 - cameraPos.field_1351, circleCenter.field_1350 - cameraPos.field_1350);
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        int vertexNum = class_3532.method_15340((int)((int)Math.round(circleRadius * 40.0)), (int)20, (int)400);
        for (int i = 0; i < vertexNum; ++i) {
            double angle = (double)(i * 2) * Math.PI / (double)vertexNum;
            double nextAngle = (double)((i + 1) * 2) * Math.PI / (double)vertexNum;
            boolean isBegin = i == 0;
            boolean isEnd = i == vertexNum - 1;
            class_243 lineStart = planeX.method_1021(Math.cos(angle) * circleRadius).method_1019(planeY.method_1021(Math.sin(angle) * circleRadius));
            class_243 lineEnd = planeX.method_1021(Math.cos(nextAngle) * circleRadius).method_1019(planeY.method_1021(Math.sin(nextAngle) * circleRadius));
            if (isBegin) {
                vertexConsumer.method_22918(matrix, (float)lineStart.field_1352, (float)lineStart.field_1351, (float)lineStart.field_1350).method_39415(0).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
                vertexConsumer.method_22918(matrix, (float)lineStart.field_1352, (float)lineStart.field_1351, (float)lineStart.field_1350).method_39415(color).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
            }
            vertexConsumer.method_22918(matrix, (float)lineEnd.field_1352, (float)lineEnd.field_1351, (float)lineEnd.field_1350).method_39415(color).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
            if (!isEnd) continue;
            vertexConsumer.method_22918(matrix, (float)lineEnd.field_1352, (float)lineEnd.field_1351, (float)lineEnd.field_1350).method_39415(0).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
        }
        matrixStack.method_22909();
    }

    public static void renderLockShape(class_4588 vertexConsumer, class_243 cameraPos, class_243 center, double scale, int color, class_4587 matrixStack) {
        double w = 380.0;
        double h = 270.0;
        double ringWidth = 60.0;
        double ringAreaWidth = 152.0;
        double rightAreaHeight = 136.0;
        class_243[] lineVertices = new class_243[]{new class_243(w / 2.0, h / 2.0, 0.0), new class_243(-w / 2.0, h / 2.0, 0.0), new class_243(-w / 2.0, h / 2.0, 0.0), new class_243(-w / 2.0, -h / 2.0, 0.0), new class_243(-w / 2.0, -h / 2.0, 0.0), new class_243(w / 2.0, -h / 2.0, 0.0), new class_243(w / 2.0, -h / 2.0, 0.0), new class_243(w / 2.0, h / 2.0, 0.0), new class_243(ringAreaWidth / 2.0, h / 2.0, 0.0), new class_243(ringAreaWidth / 2.0, h / 2.0 + rightAreaHeight, 0.0), new class_243(ringAreaWidth / 2.0, h / 2.0 + rightAreaHeight, 0.0), new class_243(-ringAreaWidth / 2.0, h / 2.0 + rightAreaHeight, 0.0), new class_243(-ringAreaWidth / 2.0, h / 2.0 + rightAreaHeight, 0.0), new class_243(-ringAreaWidth / 2.0, h / 2.0, 0.0), new class_243(ringAreaWidth / 2.0 + ringWidth, h / 2.0, 0.0), new class_243(ringAreaWidth / 2.0 + ringWidth, h / 2.0 + rightAreaHeight + ringWidth, 0.0), new class_243(ringAreaWidth / 2.0 + ringWidth, h / 2.0 + rightAreaHeight + ringWidth, 0.0), new class_243(-ringAreaWidth / 2.0 - ringWidth, h / 2.0 + rightAreaHeight + ringWidth, 0.0), new class_243(-ringAreaWidth / 2.0 - ringWidth, h / 2.0 + rightAreaHeight + ringWidth, 0.0), new class_243(-ringAreaWidth / 2.0 - ringWidth, h / 2.0, 0.0)};
        float renderScale = (float)(scale * 0.001);
        DQuaternion rotation = DQuaternion.rotationByDegrees((class_243)new class_243(0.0, 1.0, 0.0), (double)(CHelper.getSmoothCycles(60L) * 360.0));
        WireRenderingHelper.renderLines(vertexConsumer, cameraPos, center, lineVertices, renderScale, rotation, color, matrixStack);
    }

    public static void renderLines(class_4588 vertexConsumer, class_243 cameraPos, class_243 center, class_243[] lineVertices, double scale, DQuaternion rotation, int color, class_4587 matrixStack) {
        matrixStack.method_22903();
        matrixStack.method_22904(center.field_1352 - cameraPos.field_1352, center.field_1351 - cameraPos.field_1351, center.field_1350 - cameraPos.field_1350);
        matrixStack.method_22907(rotation.toMcQuaternion());
        matrixStack.method_22905((float)scale, (float)scale, (float)scale);
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        Matrix3f normalMatrix = matrixStack.method_23760().method_23762();
        for (int i = 0; i < lineVertices.length / 2; ++i) {
            WireRenderingHelper.putLine(vertexConsumer, color, matrix, normalMatrix, lineVertices[i * 2], lineVertices[i * 2 + 1]);
        }
        matrixStack.method_22909();
    }

    public static void putLine(class_4588 vertexConsumer, int color, Matrix4f matrix, Matrix3f normalMatrix, class_243 lineStart, class_243 lineEnd) {
        WireRenderingHelper.putLine(vertexConsumer, color, lineEnd.method_1020(lineStart), matrix, normalMatrix, lineStart, lineEnd);
    }

    public static void putLine(class_4588 vertexConsumer, int color, class_243 normal, Matrix4f matrix, Matrix3f normalMatrix, class_243 lineStart, class_243 lineEnd) {
        vertexConsumer.method_22918(matrix, (float)lineStart.field_1352, (float)lineStart.field_1351, (float)lineStart.field_1350).method_39415(color).method_23763(normalMatrix, (float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
        vertexConsumer.method_22918(matrix, (float)lineEnd.field_1352, (float)lineEnd.field_1351, (float)lineEnd.field_1350).method_39415(color).method_23763(normalMatrix, (float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
    }

    private static void putLineToLineStrip(class_4588 vertexConsumer, int color, class_243 normal, Matrix4f matrix, class_243 lineStart, class_243 lineEnd) {
        vertexConsumer.method_22918(matrix, (float)lineStart.field_1352, (float)lineStart.field_1351, (float)lineStart.field_1350).method_39415(0).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
        vertexConsumer.method_22918(matrix, (float)lineStart.field_1352, (float)lineStart.field_1351, (float)lineStart.field_1350).method_39415(color).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
        vertexConsumer.method_22918(matrix, (float)lineEnd.field_1352, (float)lineEnd.field_1351, (float)lineEnd.field_1350).method_39415(color).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
        vertexConsumer.method_22918(matrix, (float)lineEnd.field_1352, (float)lineEnd.field_1351, (float)lineEnd.field_1350).method_39415(0).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
    }

    public static void renderRectLine(class_4588 vertexConsumer, class_243 cameraPos, UnilateralPortalState rect, int flowCount, int color, double shrinkFactor, int flowDirection, class_4587 matrixStack) {
        matrixStack.method_22903();
        matrixStack.method_22904(rect.position().field_1352 - cameraPos.field_1352, rect.position().field_1351 - cameraPos.field_1351, rect.position().field_1350 - cameraPos.field_1350);
        class_243[] vertices = WireRenderingHelper.getRectVertices(rect, shrinkFactor);
        Random random = new Random(color);
        WireRenderingHelper.renderFlowLines(vertexConsumer, vertices, flowCount, color, flowDirection, matrixStack, () -> random.nextInt(30, 300));
        matrixStack.method_22909();
    }

    public static void renderFlowLines(class_4588 vertexConsumer, class_243[] vertices, int flowCount, int color, int flowDirection, class_4587 matrixStack, IntSupplier randCycleSupplier) {
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        Matrix3f normalMatrix = matrixStack.method_23760().method_23762();
        for (int i = 0; i < flowCount; ++i) {
            double offset = (double)flowDirection * CHelper.getSmoothCycles(randCycleSupplier.getAsInt());
            double totalStartRatio = (double)i * 2.0 / (double)(flowCount * 2) + offset;
            double totalEndRatio = ((double)i * 2.0 + 1.0) / (double)(flowCount * 2) + offset;
            WireRenderingHelper.renderSubLineInLineLoop(vertexConsumer, matrix, normalMatrix, vertices, color, totalStartRatio, totalEndRatio);
        }
    }

    private static class_243[] getRectVertices(UnilateralPortalState rect, double shrinkFactor) {
        class_243 normal = rect.orientation().getNormal();
        class_243 axisW = rect.orientation().getAxisW();
        class_243 axisH = rect.orientation().getAxisH();
        class_243 facingOffset = normal.method_1021(0.01);
        class_243[] vertices = new class_243[]{axisW.method_1021(shrinkFactor * rect.width() / 2.0).method_1019(axisH.method_1021(shrinkFactor * rect.height() / 2.0)).method_1019(facingOffset), axisW.method_1021(shrinkFactor * rect.width() / 2.0).method_1019(axisH.method_1021(-1.0 * shrinkFactor * rect.height() / 2.0)).method_1019(facingOffset), axisW.method_1021(-1.0 * shrinkFactor * rect.width() / 2.0).method_1019(axisH.method_1021(-1.0 * shrinkFactor * rect.height() / 2.0)).method_1019(facingOffset), axisW.method_1021(-1.0 * shrinkFactor * rect.width() / 2.0).method_1019(axisH.method_1021(shrinkFactor * rect.height() / 2.0)).method_1019(facingOffset), axisW.method_1021(shrinkFactor * rect.width() / 2.0).method_1019(axisH.method_1021(shrinkFactor * rect.height() / 2.0)).method_1019(facingOffset)};
        return vertices;
    }

    public static void renderSubLineInLineLoop(class_4588 vertexConsumer, Matrix4f matrix, Matrix3f normalMatrix, class_243[] lineVertices, int color, double totalStartRatio, double totalEndRatio) {
        int lineNum = lineVertices.length - 1;
        double startRatioByLine = totalStartRatio * (double)lineNum;
        double endRatioByLine = totalEndRatio * (double)lineNum;
        int startRatioLineIndex = (int)Math.floor(startRatioByLine);
        int endRatioLineIndex = (int)Math.floor(endRatioByLine);
        for (int lineIndex = startRatioLineIndex; lineIndex <= endRatioLineIndex; ++lineIndex) {
            double startLimit = lineIndex;
            double endLimit = lineIndex + 1;
            double startRatio = Math.max(startLimit, startRatioByLine);
            double endRatio = Math.min(endLimit, endRatioByLine);
            WireRenderingHelper.putLinePart(vertexConsumer, color, matrix, normalMatrix, lineVertices[Math.floorMod(lineIndex, lineNum)], lineVertices[Math.floorMod(lineIndex, lineNum) + 1], startRatio - (double)lineIndex, endRatio - (double)lineIndex);
        }
    }

    private static void putLinePart(class_4588 vertexConsumer, int color, Matrix4f matrix, Matrix3f normalMatrix, class_243 lineStart, class_243 lineEnd, double startRatio, double endRatio) {
        class_243 vec = lineEnd.method_1020(lineStart);
        class_243 partStartPos = lineStart.method_1019(vec.method_1021(startRatio));
        class_243 partEndPos = lineStart.method_1019(vec.method_1021(endRatio));
        WireRenderingHelper.putLine(vertexConsumer, color, matrix, normalMatrix, partStartPos, partEndPos);
    }

    public static void renderSphere(class_4588 vertexConsumer, int color, class_4587 matrixStack, class_243 cameraPos, Sphere sphere, DQuaternion sphereOrientation, double animationProgress, double rotationProgress) {
        int i;
        matrixStack.method_22903();
        matrixStack.method_22904(sphere.center().field_1352 - cameraPos.field_1352, sphere.center().field_1351 - cameraPos.field_1351, sphere.center().field_1350 - cameraPos.field_1350);
        matrixStack.method_22907(sphereOrientation.toMcQuaternion());
        matrixStack.method_22905((float)sphere.radius(), (float)sphere.radius(), (float)sphere.radius());
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        int meridianCount = 30;
        int parallelCount = 15;
        int vertexNum = class_3532.method_15340((int)((int)Math.round(sphere.radius() * 40.0)), (int)20, (int)400);
        int transparentColor = color & 0xFFFFFF;
        for (i = 0; i < meridianCount; ++i) {
            double longitude = ((double)i / (double)meridianCount + rotationProgress) * Math.PI * 2.0;
            for (int j = 0; j < vertexNum; ++j) {
                boolean isLast;
                boolean isFirst;
                double latitudeRatio = (double)j / (double)vertexNum;
                latitudeRatio = Math.min(latitudeRatio, animationProgress);
                double latitude = latitudeRatio * Math.PI - 1.5707963267948966;
                double x = Math.cos(latitude) * Math.cos(longitude);
                double y = Math.sin(latitude);
                double z = Math.cos(latitude) * Math.sin(longitude);
                boolean bl = isFirst = j == 0;
                if (isFirst) {
                    vertexConsumer.method_22918(matrix, (float)x, (float)y, (float)z).method_39415(transparentColor).method_22914(0.0f, 1.0f, 0.0f).method_1344();
                }
                vertexConsumer.method_22918(matrix, (float)x, (float)y, (float)z).method_39415(color).method_22914(0.0f, 1.0f, 0.0f).method_1344();
                boolean bl2 = isLast = j == vertexNum - 1;
                if (!isLast) continue;
                vertexConsumer.method_22918(matrix, (float)x, (float)y, (float)z).method_39415(transparentColor).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            }
        }
        for (i = 0; i < parallelCount; ++i) {
            double latitudeRatio = (double)i / (double)parallelCount + rotationProgress;
            latitudeRatio -= Math.floor(latitudeRatio);
            double latitude = latitudeRatio * Math.PI - 1.5707963267948966;
            for (int j = 0; j <= vertexNum; ++j) {
                boolean isLast;
                boolean isFirst;
                double longitudeRatio = (double)j / (double)vertexNum;
                longitudeRatio = Math.min(longitudeRatio, animationProgress);
                double longitude = longitudeRatio * Math.PI * 2.0;
                double x = Math.cos(latitude) * Math.cos(longitude);
                double y = Math.sin(latitude);
                double z = Math.cos(latitude) * Math.sin(longitude);
                boolean bl = isFirst = j == 0;
                if (isFirst) {
                    vertexConsumer.method_22918(matrix, (float)x, (float)y, (float)z).method_39415(transparentColor).method_22914(0.0f, 1.0f, 0.0f).method_1344();
                }
                vertexConsumer.method_22918(matrix, (float)x, (float)y, (float)z).method_39415(color).method_22914(0.0f, 1.0f, 0.0f).method_1344();
                boolean bl3 = isLast = j == vertexNum;
                if (!isLast) continue;
                vertexConsumer.method_22918(matrix, (float)x, (float)y, (float)z).method_39415(transparentColor).method_22914(0.0f, 1.0f, 0.0f).method_1344();
            }
        }
        matrixStack.method_22909();
    }

    public static void renderRectFrameFlow(class_4587 matrixStack, class_243 cameraPos, class_4588 vertexConsumer, UnilateralPortalState rect, int innerColor, int outerColor) {
        matrixStack.method_22903();
        matrixStack.method_22905(0.5f, 0.5f, 0.5f);
        WireRenderingHelper.renderRectLine(vertexConsumer, cameraPos, rect, 10, innerColor, 0.99, 1, matrixStack);
        WireRenderingHelper.renderRectLine(vertexConsumer, cameraPos, rect, 10, outerColor, 1.01, -1, matrixStack);
        matrixStack.method_22909();
    }

    public static void renderPortalShapeMeshDebug(class_4587 matrixStack, class_4588 vertexConsumer, Portal portal) {
        double cycle = (Math.sin(CHelper.getSmoothCycles(50L) * 2.0 * Math.PI) + 1.0) / 2.0;
        double shrink = 0.03 * cycle;
        GeometryPortalShape shape = portal.specialShape;
        if (shape != null) {
            int triangleNum = shape.triangles.size();
            int vertexNum = triangleNum * 3;
            class_243[] vertexes = new class_243[vertexNum];
            double halfWidth = portal.width / 2.0;
            double halfHeight = portal.height / 2.0;
            class_243 X = portal.axisW.method_1021(halfWidth);
            class_243 Y = portal.axisH.method_1021(halfHeight);
            matrixStack.method_22903();
            Matrix4f matrix = matrixStack.method_23760().method_23761();
            Matrix3f normalMatrix = matrixStack.method_23760().method_23762();
            for (int i = 0; i < shape.triangles.size(); ++i) {
                GeometryPortalShape.TriangleInPlane triangleInPlane = shape.triangles.get(i);
                double centerX = (triangleInPlane.x1 + triangleInPlane.x2 + triangleInPlane.x3) / 3.0;
                double centerY = (triangleInPlane.y1 + triangleInPlane.y2 + triangleInPlane.y3) / 3.0;
                double x1 = triangleInPlane.x1 * (1.0 - shrink) + centerX * shrink;
                double y1 = triangleInPlane.y1 * (1.0 - shrink) + centerY * shrink;
                double x2 = triangleInPlane.x2 * (1.0 - shrink) + centerX * shrink;
                double y2 = triangleInPlane.y2 * (1.0 - shrink) + centerY * shrink;
                double x3 = triangleInPlane.x3 * (1.0 - shrink) + centerX * shrink;
                double y3 = triangleInPlane.y3 * (1.0 - shrink) + centerY * shrink;
                WireRenderingHelper.putLine(vertexConsumer, -2130771968, matrix, normalMatrix, X.method_1021(x1).method_1019(Y.method_1021(y1)), X.method_1021(x2).method_1019(Y.method_1021(y2)));
                WireRenderingHelper.putLine(vertexConsumer, -2130771968, matrix, normalMatrix, X.method_1021(x2).method_1019(Y.method_1021(y2)), X.method_1021(x3).method_1019(Y.method_1021(y3)));
                WireRenderingHelper.putLine(vertexConsumer, -2130771968, matrix, normalMatrix, X.method_1021(x3).method_1019(Y.method_1021(y3)), X.method_1021(x1).method_1019(Y.method_1021(y1)));
            }
            matrixStack.method_22909();
        }
    }
}

