/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat.iris_compatibility;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_4587;
import org.apache.commons.lang3.Validate;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.compat.IPPortingLibCompat;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalRenderInfo;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.PortalRenderable;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.SecondaryFrameBuffer;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;

public class IrisPortalRenderer
extends PortalRenderer {
    public static final IrisPortalRenderer instance = new IrisPortalRenderer();
    private SecondaryFrameBuffer[] deferredFbs = new SecondaryFrameBuffer[0];
    private boolean portalRenderingNeeded = false;
    private boolean nextFramePortalRenderingNeeded = false;

    IrisPortalRenderer() {
        IPGlobal.preGameRenderSignal.connect(() -> this.updateNeedsPortalRendering());
    }

    @Override
    public boolean replaceFrameBufferClearing() {
        return false;
    }

    @Override
    public void prepareRendering() {
        Validate.isTrue((!PortalRendering.isRendering() ? 1 : 0) != 0);
        boolean bl = IPCGlobal.useSeparatedStencilFormat = !IPMcHelper.isNvidiaVideocard();
        if (this.deferredFbs.length != PortalRendering.getMaxPortalLayer() + 1) {
            for (SecondaryFrameBuffer fb : this.deferredFbs) {
                fb.fb.method_1238();
            }
            this.deferredFbs = new SecondaryFrameBuffer[PortalRendering.getMaxPortalLayer() + 1];
            for (int i = 0; i < this.deferredFbs.length; ++i) {
                this.deferredFbs[i] = new SecondaryFrameBuffer();
            }
        }
        CHelper.checkGlError();
        for (SecondaryFrameBuffer deferredFb : this.deferredFbs) {
            deferredFb.prepare();
            IPPortingLibCompat.setIsStencilEnabled((class_276)deferredFb.fb, true);
            deferredFb.fb.method_1235(true);
            GlStateManager._clearColor((float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager._clearDepth((double)1.0);
            GlStateManager._clearStencil((int)0);
            GL11.glClear((int)17664);
            deferredFb.fb.method_1239();
            CHelper.checkGlError();
            deferredFb.fb.method_1240();
        }
        IPPortingLibCompat.setIsStencilEnabled(client.method_1522(), false);
        client.method_1522().method_1235(false);
    }

    private void updateNeedsPortalRendering() {
        this.portalRenderingNeeded = this.nextFramePortalRenderingNeeded;
        this.nextFramePortalRenderingNeeded = false;
    }

    @Override
    public void onBeforeHandRendering(class_4587 matrixStack) {
        this.doMainRenderings(matrixStack);
    }

    private void doMainRenderings(class_4587 matrixStack) {
        CHelper.checkGlError();
        class_276 mcFrameBuffer = client.method_1522();
        int portalLayer = PortalRendering.getPortalLayer();
        if (this.portalRenderingNeeded) {
            CHelper.doCheckGlError();
            GL30.glBindFramebuffer((int)36008, (int)mcFrameBuffer.field_1476);
            GL30.glBindFramebuffer((int)36009, (int)this.deferredFbs[portalLayer].fb.field_1476);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)mcFrameBuffer.field_1480, (int)mcFrameBuffer.field_1477, (int)0, (int)0, (int)mcFrameBuffer.field_1480, (int)mcFrameBuffer.field_1477, (int)256, (int)9728);
            int errorCode = GL11.glGetError();
            if (errorCode != 0) {
                IPGlobal.renderMode = IPGlobal.RenderMode.compatibility;
                CHelper.printChat("[Immersive Portals]Switched to compatibility portal rendering mode. Portal-in-portal wont' be rendered");
            }
            this.initStencilForLayer(portalLayer);
            this.deferredFbs[portalLayer].fb.method_1235(true);
            GL11.glEnable((int)2960);
            GL11.glStencilFunc((int)514, (int)portalLayer, (int)255);
            GL11.glStencilOp((int)7680, (int)7680, (int)7680);
            MyRenderHelper.drawScreenFrameBuffer(mcFrameBuffer, false, true);
            GL11.glDisable((int)2960);
            this.deferredFbs[portalLayer].fb.method_1240();
            mcFrameBuffer.method_1235(false);
        }
        this.renderPortals(matrixStack);
        if (portalLayer == 0) {
            this.finish();
        }
        mcFrameBuffer.method_1235(true);
    }

    @Override
    public void onHandRenderingEnded(class_4587 matrixStack) {
    }

    private void initStencilForLayer(int portalLayer) {
        if (portalLayer == 0) {
            this.deferredFbs[portalLayer].fb.method_1235(true);
            GlStateManager._clearStencil((int)0);
            GL11.glClear((int)1024);
        } else {
            CHelper.checkGlError();
            GL30.glBindFramebuffer((int)36008, (int)this.deferredFbs[portalLayer - 1].fb.field_1476);
            GL30.glBindFramebuffer((int)36009, (int)this.deferredFbs[portalLayer].fb.field_1476);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)this.deferredFbs[0].fb.field_1480, (int)this.deferredFbs[0].fb.field_1477, (int)0, (int)0, (int)this.deferredFbs[0].fb.field_1480, (int)this.deferredFbs[0].fb.field_1477, (int)1024, (int)9728);
            CHelper.checkGlError();
        }
    }

    @Override
    public void onBeforeTranslucentRendering(class_4587 matrixStack) {
    }

    @Override
    public void onAfterTranslucentRendering(class_4587 matrixStack) {
    }

    @Override
    public void finishRendering() {
    }

    private void finish() {
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        if (RenderStates.getRenderedPortalNum() == 0) {
            return;
        }
        if (!this.portalRenderingNeeded) {
            return;
        }
        class_276 mainFrameBuffer = client.method_1522();
        mainFrameBuffer.method_1235(true);
        this.deferredFbs[0].fb.method_1237(mainFrameBuffer.field_1480, mainFrameBuffer.field_1477);
        CHelper.checkGlError();
    }

    protected void doRenderPortal(PortalRenderable portal, class_4587 matrixStack) {
        this.nextFramePortalRenderingNeeded = true;
        if (!this.portalRenderingNeeded) {
            return;
        }
        if (!this.tryRenderViewAreaInDeferredBufferAndIncreaseStencil(portal, matrixStack)) {
            return;
        }
        PortalRendering.pushPortalLayer(portal.getPortalLike());
        client.method_1522().method_1235(true);
        this.renderPortalContent(portal);
        int innerLayer = PortalRendering.getPortalLayer();
        PortalRendering.popPortalLayer();
        int outerLayer = PortalRendering.getPortalLayer();
        if (innerLayer > PortalRendering.getMaxPortalLayer()) {
            return;
        }
        this.deferredFbs[outerLayer].fb.method_1235(true);
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)514, (int)innerLayer, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        MyRenderHelper.drawScreenFrameBuffer((class_276)this.deferredFbs[innerLayer].fb, true, false);
        GL11.glDisable((int)2960);
        this.deferredFbs[outerLayer].fb.method_1240();
    }

    private boolean tryRenderViewAreaInDeferredBufferAndIncreaseStencil(PortalRenderable portal, class_4587 matrixStack) {
        int portalLayer = PortalRendering.getPortalLayer();
        this.initStencilForLayer(portalLayer);
        this.deferredFbs[portalLayer].fb.method_1235(true);
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)514, (int)portalLayer, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7682);
        GlStateManager._enableDepthTest();
        boolean result = PortalRenderInfo.renderAndDecideVisibility(portal.getPortalLike(), () -> ViewAreaRenderer.renderPortalArea(portal, class_243.field_1353, matrixStack.method_23760().method_23761(), RenderSystem.getProjectionMatrix(), true, true, true, true));
        GL11.glDisable((int)2960);
        return result;
    }

    @Override
    public void invokeWorldRendering(WorldRenderInfo worldRenderInfo) {
        MyGameRenderer.renderWorldNew(worldRenderInfo, Runnable::run);
    }

    @Override
    public void renderPortalInEntityRenderer(Portal portal) {
    }

    protected void renderPortals(class_4587 matrixStack) {
        List<PortalRenderable> portalsToRender = this.getPortalsToRender(matrixStack);
        for (PortalRenderable portal : portalsToRender) {
            this.doRenderPortal(portal, matrixStack);
        }
    }
}

