/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat.iris_compatibility;

import java.lang.reflect.Field;
import net.coderbot.iris.Iris;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.Helper;

public class IrisInterface {
    public static Invoker invoker = new Invoker();

    public static class Invoker {
        public boolean isIrisPresent() {
            return false;
        }

        public boolean isShaders() {
            return false;
        }

        public boolean isRenderingShadowMap() {
            return false;
        }

        public Object getPipeline(class_761 worldRenderer) {
            return null;
        }

        public void setPipeline(class_761 worldRenderer, Object pipeline) {
        }

        public void reloadPipelines() {
        }

        @Nullable
        public String getShaderpackName() {
            return null;
        }
    }

    public static class OnIrisPresent
    extends Invoker {
        private Field worldRendererPipelineField = (Field)Helper.noError(() -> {
            Field field = class_761.class.getDeclaredField("pipeline");
            field.setAccessible(true);
            return field;
        });

        @Override
        public boolean isIrisPresent() {
            return true;
        }

        @Override
        public boolean isShaders() {
            return Iris.getCurrentPack().isPresent();
        }

        @Override
        public boolean isRenderingShadowMap() {
            return ShadowRenderer.ACTIVE;
        }

        @Override
        public Object getPipeline(class_761 worldRenderer) {
            return Helper.noError(() -> (WorldRenderingPipeline)this.worldRendererPipelineField.get(worldRenderer));
        }

        @Override
        public void setPipeline(class_761 worldRenderer, Object pipeline) {
            Helper.noError(() -> {
                this.worldRendererPipelineField.set(worldRenderer, pipeline);
                return null;
            });
        }

        @Override
        public void reloadPipelines() {
            Iris.getPipelineManager().destroyPipeline();
        }

        @Override
        @Nullable
        public String getShaderpackName() {
            return Iris.getCurrentPackName();
        }
    }
}

