/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.commands;

import com.google.common.collect.Streams;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.lang.ref.WeakReference;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2423;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2804;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3227;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_5574;
import net.minecraft.class_638;
import net.minecraft.class_746;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.ducks.IEClientWorld;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.IPConfigGUI;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.PortalRenderInfo;
import qouteall.imm_ptl.core.render.MyBuiltChunkStorage;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.MyTaskList;

@Environment(value=EnvType.CLIENT)
public class ClientDebugCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"imm_ptl_client_debug").requires(commandSource -> true)).then(ClientCommandManager.literal((String)"set_max_portal_layer").then(ClientCommandManager.argument((String)"argMaxPortalLayer", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ClientDebugCommand.setMaxPortalLayer(IntegerArgumentType.getInteger((CommandContext)context, (String)"argMaxPortalLayer")))));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"list_portals").executes(context -> {
            RemoteCallables.doListPortals();
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"is_client_chunk_loaded").then(ClientCommandManager.argument((String)"chunkX", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"chunkZ", (ArgumentType)IntegerArgumentType.integer()).executes(ClientDebugCommand::isClientChunkLoaded))));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"report_player_status").executes(context -> {
            RemoteCallables.reportClientPlayerStatus();
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"client_remote_ticking_enable").executes(context -> {
            IPCGlobal.isClientRemoteTickingEnabled = true;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"client_remote_ticking_disable").executes(context -> {
            IPCGlobal.isClientRemoteTickingEnabled = false;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"advanced_frustum_culling_enable").executes(context -> {
            IPCGlobal.doUseAdvancedFrustumCulling = true;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"advanced_frustum_culling_disable").executes(context -> {
            IPCGlobal.doUseAdvancedFrustumCulling = false;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"report_resource_consumption").executes(context1 -> {
            RemoteCallables.reportResourceConsumption();
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"report_render_info_num").executes(context -> {
            String str = Helper.myToString(IPCGlobal.renderInfoNumMap.entrySet().stream());
            ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)str), false);
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"get_player_colliding_portal_client").executes(context -> {
            Portal collidingPortal = ((IEEntity)class_310.method_1551().field_1724).ip_getCollidingPortal();
            CHelper.printChat(collidingPortal != null ? collidingPortal.toString() : "null");
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"report_rendering").executes(context -> {
            StringBuilder sb = new StringBuilder();
            for (List<WeakReference<PortalLike>> rendering : RenderStates.lastPortalRenderInfos) {
                sb.append("----------\n");
                for (WeakReference<PortalLike> portalLikeWeakReference : rendering) {
                    sb.append(((PortalLike)portalLikeWeakReference.get()).toString());
                    sb.append("\n");
                }
            }
            CHelper.printChat(sb.toString());
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"vanilla_chunk_culling_enable").executes(context -> {
            class_310.method_1551().field_1730 = true;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"vanilla_chunk_culling_disable").executes(context -> {
            class_310.method_1551().field_1730 = false;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"render_mode_normal").executes(context -> {
            IPGlobal.renderMode = IPGlobal.RenderMode.normal;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"render_mode_compatibility").executes(context -> {
            IPGlobal.renderMode = IPGlobal.RenderMode.compatibility;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"render_mode_debug").executes(context -> {
            IPGlobal.renderMode = IPGlobal.RenderMode.debug;
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)"render_mode_none").executes(context -> {
            IPGlobal.renderMode = IPGlobal.RenderMode.none;
            return 0;
        }));
        builder.then(ClientCommandManager.literal((String)"check_client_light").executes(context -> {
            class_310 client = class_310.method_1551();
            client.execute(() -> client.field_1687.method_2935().method_12130().method_15551(class_4076.method_18682((class_2338)class_2338.method_49638((class_2374)client.field_1724.method_19538())), false));
            return 0;
        }));
        builder.then(ClientCommandManager.literal((String)"report_client_entities").executes(context -> {
            class_638 world = class_310.method_1551().field_1687;
            CHelper.printChat("client entity manager:");
            for (class_1297 entity : world.method_18112()) {
                CHelper.printChat(entity.toString());
            }
            CHelper.printChat("client entity list:");
            class_5574 entityList = ((IEClientWorld)world).ip_getEntityList();
            entityList.method_31791(e -> CHelper.printChat(e.toString()));
            return 0;
        }));
        builder.then(ClientCommandManager.literal((String)"check_server_light").executes(context -> {
            MiscHelper.getServer().execute(() -> {
                class_3222 player = McHelper.getRawPlayerList().get(0);
                class_2338.method_20437((class_2338)player.method_24515().method_10069(-2, -2, -2), (class_2338)player.method_24515().method_10069(2, 2, 2)).forEach(blockPos -> player.method_37908().method_22336().method_15513(blockPos));
            });
            return 0;
        }));
        builder.then(ClientCommandManager.literal((String)"update_server_light").executes(context -> {
            MiscHelper.getServer().execute(() -> {
                class_3222 player = McHelper.getRawPlayerList().get(0);
                class_3227 lightingProvider = (class_3227)player.method_37908().method_22336();
                lightingProvider.method_17310(player.method_37908().method_22350(player.method_24515()), false);
            });
            return 0;
        }));
        builder.then(ClientCommandManager.literal((String)"report_rebuild_status").executes(context -> {
            class_310.method_1551().execute(() -> ClientWorldLoader.getClientWorlds().forEach(world -> {
                MyBuiltChunkStorage builtChunkStorage = (MyBuiltChunkStorage)((IEWorldRenderer)ClientWorldLoader.getWorldRenderer((class_5321<class_1937>)world.method_27983())).ip_getBuiltChunkStorage();
                CHelper.printChat(world.method_27983().method_29177().toString() + builtChunkStorage.getDebugString());
            }));
            return 0;
        }));
        builder.then(ClientCommandManager.literal((String)"report_portal_groups").executes(context -> {
            for (class_638 clientWorld : ClientWorldLoader.getClientWorlds()) {
                Map<Optional, List<Portal>> result = Streams.stream((Iterable)clientWorld.method_18112()).flatMap(entity -> entity instanceof Portal ? Stream.of((Portal)entity) : Stream.empty()).collect(Collectors.groupingBy(p -> Optional.ofNullable(PortalRenderInfo.getGroupOf(p))));
                CHelper.printChat("\n" + clientWorld.method_27983().method_29177().toString());
                result.forEach((g, l) -> {
                    CHelper.printChat("\n" + g.toString());
                    CHelper.printChat(l.stream().map(Portal::toString).collect(Collectors.joining("\n")));
                });
            }
            return 0;
        }));
        builder.then(ClientCommandManager.literal((String)"report_client_light_status").executes(context -> {
            class_310.method_1551().execute(() -> {
                class_746 player = class_310.method_1551().field_1724;
                class_2804 lightSection = player.method_37908().method_22336().method_15562(class_1944.field_9282).method_15544(class_4076.method_18682((class_2338)player.method_24515()));
                if (lightSection != null) {
                    boolean uninitialized = lightSection.method_12146();
                    byte[] byteArray = lightSection.method_12137();
                    boolean allZero = true;
                    for (byte b : byteArray) {
                        if (b == 0) continue;
                        allZero = false;
                        break;
                    }
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("has light section " + (allZero ? "all zero" : "not all zero") + (uninitialized ? " uninitialized" : " fine"))));
                } else {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"does not have light section"));
                }
            });
            return 0;
        }));
        builder.then(ClientCommandManager.literal((String)"reload_world_renderer").executes(context -> {
            class_310.method_1551().execute(() -> {
                ClientWorldLoader.disposeRenderHelpers();
                class_310.method_1551().field_1769.method_3279();
            });
            return 0;
        }));
        builder.then(ClientCommandManager.literal((String)"config").executes(context -> {
            class_310 client = class_310.method_1551();
            IPGlobal.clientTaskList.addTask(MyTaskList.oneShotTask(() -> client.method_1507(IPConfigGUI.createClothConfigScreen(null))));
            return 0;
        }));
        builder.then(ClientCommandManager.literal((String)"disable_warning").executes(context -> {
            ClientDebugCommand.disableWarning();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"imm_ptl.warning_disabled"));
            return 0;
        }));
        builder.then(ClientCommandManager.literal((String)"disable_warning_for").then(ClientCommandManager.argument((String)"warningKey", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ClientDebugCommand.disableWarningFor(StringArgumentType.getString((CommandContext)context, (String)"warningKey"));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"imm_ptl.warning_disabled"));
            return 0;
        })));
        builder.then(ClientCommandManager.literal((String)"disable_update_check").executes(context -> {
            ClientDebugCommand.disableUpdateCheck();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"imm_ptl.update_check_disabled"));
            return 0;
        }));
        builder.then(ClientCommandManager.literal((String)"view_portal_data").executes(context -> {
            class_310 client = class_310.method_1551();
            Pair pair = PortalCommand.getPlayerPointingPortalRaw((class_1657)client.field_1724, 0.0f, 50.0, true).orElse(null);
            if (pair != null) {
                Portal portal = (Portal)pair.getFirst();
                PortalCommand.sendPortalInfo(c -> {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback(c);
                    Helper.log((Object)c.getString());
                }, portal);
            } else {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"No pointing to a portal."));
            }
            return 0;
        }));
        LiteralArgumentBuilder wandBuilder = ClientCommandManager.literal((String)"wand");
        ClientDebugCommand.registerPortalWandCommands((LiteralArgumentBuilder<FabricClientCommandSource>)wandBuilder);
        builder.then((ArgumentBuilder)wandBuilder);
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "front_clipping", cond -> {
            IPCGlobal.useFrontClipping = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "gl_check_error", cond -> {
            IPGlobal.doCheckGlError = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "early_light_update", cond -> {
            IPCGlobal.lateClientLightUpdate = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "early_remote_upload", cond -> {
            IPCGlobal.earlyRemoteUpload = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "super_advanced_frustum_culling", cond -> {
            IPCGlobal.useSuperAdvancedFrustumCulling = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "cross_portal_entity_rendering", cond -> {
            IPGlobal.correctCrossPortalEntityRendering = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "early_cull_portal", cond -> {
            IPCGlobal.earlyFrustumCullingPortal = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "cache_gl_buffer", cond -> {
            IPGlobal.cacheGlBuffer = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "secondary_vertex_consumer", cond -> {
            IPGlobal.useSecondaryEntityVertexConsumer = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "cull_sections_behind", cond -> {
            IPGlobal.cullSectionsBehind = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "offset_occlusion_query", cond -> {
            IPGlobal.offsetOcclusionQuery = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "cloud_optimization", cond -> {
            IPGlobal.cloudOptimization = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "cross_portal_collision", cond -> {
            IPGlobal.crossPortalCollision = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "nofog", cond -> {
            IPGlobal.debugDisableFog = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "depth_clamp_for_portal_rendering", cond -> {
            IPGlobal.enableDepthClampForPortalRendering = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "shared_block_mesh_builder", cond -> {
            IPGlobal.enableSharedBlockMeshBuffers = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "entity_pos_interpolation", cond -> {
            IPGlobal.allowClientEntityPosInterpolation = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "always_override_terrain_setup", cond -> {
            IPGlobal.alwaysOverrideTerrainSetup = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "view_bob_reduce", cond -> {
            IPGlobal.viewBobbingReduce = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "iris_stencil", cond -> {
            IPCGlobal.debugEnableStencilWithIris = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "another_stencil", cond -> {
            IPCGlobal.useSeparatedStencilFormat = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "experimental_iris_portal_renderer", cond -> {
            IPCGlobal.experimentalIrisPortalRenderer = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "portal_rendering_cave_culling", cond -> {
            MyGameRenderer.enablePortalCaveCulling = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "log_client_player_colliding_portal_update", cond -> {
            IPGlobal.logClientPlayerCollidingPortalUpdate = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "entity_unload_debug", cond -> {
            IPGlobal.entityUnloadDebug = cond;
        });
        ClientDebugCommand.registerSwitchCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, "mesh_render", cond -> {
            IPGlobal.debugRenderPortalShapeMesh = cond;
        });
        builder.then(ClientCommandManager.literal((String)"print_class_path").executes(context -> {
            ClientDebugCommand.printClassPath();
            return 0;
        }));
        builder.then(ClientCommandManager.literal((String)"test_invalid_rpc").executes(context -> {
            McRemoteProcedureCall.tellServerToInvoke((String)"aaa.bbb.WrongClassRemoteCallable.method", (Object[])new Object[0]);
            return 0;
        }));
        dispatcher.register(builder);
    }

    private static void registerPortalWandCommands(LiteralArgumentBuilder<FabricClientCommandSource> builder) {
        builder.then(ClientCommandManager.literal((String)"set_cursor_alignment").then(ClientCommandManager.argument((String)"alignment", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int alignment = IntegerArgumentType.getInteger((CommandContext)context, (String)"alignment");
            IPConfig config = IPConfig.getConfig();
            config.portalWandCursorAlignment = alignment;
            config.saveConfigFile();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"imm_ptl.wand.alignment_updated"));
            return 0;
        })));
    }

    private static void printClassPath() {
        System.out.println(Arrays.stream(((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs()).map(url -> "\"" + url.getFile().substring(1).replace("%20", " ") + "\"").collect(Collectors.joining(",\n")));
    }

    private static void registerSwitchCommand(LiteralArgumentBuilder<FabricClientCommandSource> builder, String name, Consumer<Boolean> setFunction) {
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)(name + "_enable")).executes(context -> {
            setFunction.accept(true);
            return 0;
        }));
        builder = (LiteralArgumentBuilder)builder.then(ClientCommandManager.literal((String)(name + "_disable")).executes(context -> {
            setFunction.accept(false);
            return 0;
        }));
    }

    private static int isClientChunkLoaded(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        int chunkX = IntegerArgumentType.getInteger(context, (String)"chunkX");
        int chunkZ = IntegerArgumentType.getInteger(context, (String)"chunkZ");
        RemoteCallables.reportClientChunkLoadStatus((class_5321<class_1937>)class_310.method_1551().field_1687.method_27983(), chunkX, chunkZ);
        return 0;
    }

    private static int setMaxPortalLayer(int m) {
        IPGlobal.maxPortalLayer = m;
        return 0;
    }

    private static void testRemoteProcedureCall(class_3222 player) {
        class_310.method_1551().execute(() -> {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10566("test", (class_2520)class_2497.method_23247((int)7));
            McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.core.commands.ClientDebugCommand.TestRemoteCallable.clientToServer", (Object[])new Object[]{new UUID(3L, 3L), class_2246.field_10218, class_2246.field_10316.method_9564().method_11657((class_2769)class_2423.field_11310, (Comparable)class_2350.class_2351.field_11051), class_1802.field_8251, new class_1799((class_1935)class_1802.field_8820, 2), compoundTag, class_2561.method_43470((String)"test"), new int[]{777, 765}});
        });
        MiscHelper.getServer().execute(() -> McRemoteProcedureCall.tellClientToInvoke((class_3222)player, (String)"qouteall.imm_ptl.core.commands.ClientDebugCommand.TestRemoteCallable.serverToClient", (Object[])new Object[]{"string", 2, 3.5, new class_2960("imm_ptl:oops"), class_1937.field_25180, class_1972.field_9417, new class_2338(3, 5, 4), new class_243(7.0, 4.0, 1.0)}));
    }

    public static void disableWarning() {
        IPConfig ipConfig = IPConfig.getConfig();
        ipConfig.enableWarning = false;
        ipConfig.saveConfigFile();
    }

    public static void disableWarningFor(String warningKey) {
        IPConfig ipConfig = IPConfig.getConfig();
        ipConfig.disabledWarnings.add(warningKey);
        ipConfig.saveConfigFile();
    }

    public static void disableUpdateCheck() {
        IPConfig ipConfig = IPConfig.getConfig();
        ipConfig.enableUpdateNotification = false;
        ipConfig.saveConfigFile();
    }

    public static class RemoteCallables {
        public static void reportClientChunkLoadStatus(class_5321<class_1937> dimension, int chunkX, int chunkZ) {
            class_638 world = ClientWorldLoader.getWorld(dimension);
            class_2818 chunk = world.method_8497(chunkX, chunkZ);
            CHelper.printChat(chunk != null && !(chunk instanceof class_2812) ? "client loaded" : "client not loaded");
        }

        public static void reportClientPlayerStatus() {
            class_746 playerSP = class_310.method_1551().field_1724;
            CHelper.printChat(String.format("On Client %s %s removal:%s added:%s age:%s", playerSP.method_37908().method_27983().method_29177(), playerSP.method_24515(), playerSP.method_35049(), playerSP.method_37908().method_8469(playerSP.method_5628()) != null, playerSP.field_6012));
        }

        public static void doListPortals() {
            StringBuilder result = new StringBuilder();
            result.append("Client Portals\n");
            ClientWorldLoader.getClientWorlds().forEach(world -> {
                result.append(world.method_27983().method_29177().toString() + "\n");
                for (class_1297 e : world.method_18112()) {
                    if (!(e instanceof Portal)) continue;
                    result.append(e.toString());
                    result.append("\n");
                }
            });
            CHelper.printChat(result.toString());
        }

        public static void reportResourceConsumption() {
            StringBuilder str = new StringBuilder();
            str.append("Client Chunk:\n");
            ClientWorldLoader.getClientWorlds().forEach(world -> str.append(String.format("%s %s\n", world.method_27983().method_29177(), world.method_2935().method_14151())));
            str.append("Chunk Mesh Sections:\n");
            ClientWorldLoader.worldRendererMap.forEach((dimension, worldRenderer) -> str.append(String.format("%s %s\n", dimension.method_29177(), ((MyBuiltChunkStorage)((IEWorldRenderer)worldRenderer).ip_getBuiltChunkStorage()).getManagedSectionNum())));
            String result = str.toString();
            CHelper.printChat(result);
        }

        public static void setNoFog(boolean cond) {
            IPGlobal.debugDisableFog = cond;
        }
    }

    public static class TestRemoteCallable {
        public static void serverToClient(String str, int integer, double doubleNum, class_2960 identifier, class_5321<class_1937> dimension, class_5321<class_1959> biomeKey, class_2338 blockPos, class_243 vec3d) {
            Helper.log((Object)(str + integer + doubleNum + identifier + dimension + biomeKey + blockPos + vec3d));
        }

        public static void clientToServer(class_3222 player, UUID uuid, class_2248 block, class_2680 blockState, class_1792 item, class_1799 itemStack, class_2487 compoundTag, class_2561 text, int[] intArray) {
            Helper.log((Object)(player.method_5477().getString() + uuid + block + blockState + item + itemStack + compoundTag + text.getString() + Arrays.toString(intArray)));
        }
    }
}

