/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.collision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.collision.CollisionHelper;
import qouteall.imm_ptl.core.collision.PortalCollisionEntry;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.q_misc_util.Helper;

public class PortalCollisionHandler {
    private static final int maxCollidingPortals = 6;
    public long lastActiveTime;
    public final List<PortalCollisionEntry> portalCollisions = new ArrayList<PortalCollisionEntry>();

    public boolean isRecentlyCollidingWithPortal(class_1297 entity) {
        return (long)PortalCollisionHandler.getTiming(entity) - this.lastActiveTime < 20L;
    }

    public void update(class_1297 entity) {
        this.portalCollisions.removeIf(p -> {
            if (p.portal.method_37908() != entity.method_37908()) {
                return true;
            }
            class_238 stretchedBoundingBox = CollisionHelper.getStretchedBoundingBox(entity);
            if (!stretchedBoundingBox.method_1014(0.5).method_994(p.portal.method_5829())) {
                return true;
            }
            if (Math.abs((long)PortalCollisionHandler.getTiming(entity) - p.activeTime) >= 3L) {
                return true;
            }
            return !CollisionHelper.canCollideWithPortal(entity, p.portal, 0.0f);
        });
    }

    private static int getTiming(class_1297 entity) {
        return entity.field_6012;
    }

    public class_243 handleCollision(class_1297 entity, class_243 attemptedMove) {
        if (this.portalCollisions.isEmpty()) {
            return attemptedMove;
        }
        entity.method_37908().method_16107().method_15396("cross_portal_collision");
        this.portalCollisions.sort(Comparator.comparingLong(p -> p.activeTime).reversed());
        class_243 result = PortalCollisionHandler.doHandleCollision(entity, attemptedMove, 1, this.portalCollisions, entity.method_5829());
        entity.method_37908().method_16107().method_15407();
        return result;
    }

    private static class_243 doHandleCollision(class_1297 entity, class_243 attemptedMove, int portalLayer, List<PortalCollisionEntry> portalCollisions, class_238 originalBoundingBox) {
        class_243 currentMove = attemptedMove;
        currentMove = PortalCollisionHandler.handleThisSideMove(entity, currentMove, originalBoundingBox, portalCollisions);
        for (PortalCollisionEntry portalCollision : portalCollisions) {
            currentMove = PortalCollisionHandler.handleOtherSideMove(entity, currentMove, portalCollision.portal, originalBoundingBox, portalLayer);
        }
        return new class_243(CollisionHelper.fixCoordinateFloatingPointError(attemptedMove.field_1352, currentMove.field_1352), CollisionHelper.fixCoordinateFloatingPointError(attemptedMove.field_1351, currentMove.field_1351), CollisionHelper.fixCoordinateFloatingPointError(attemptedMove.field_1350, currentMove.field_1350));
    }

    private static class_243 handleOtherSideMove(class_1297 entity, class_243 attemptedMove, Portal collidingPortal, class_238 originalBoundingBox, int portalLayer) {
        if (!collidingPortal.getHasCrossPortalCollision()) {
            return attemptedMove;
        }
        if (portalLayer >= 5) {
            return attemptedMove;
        }
        class_243 transformedAttemptedMove = collidingPortal.transformLocalVec(attemptedMove);
        class_238 boxOtherSide = CollisionHelper.transformBox(collidingPortal, originalBoundingBox);
        if (boxOtherSide == null) {
            return attemptedMove;
        }
        class_1937 destinationWorld = collidingPortal.getDestWorld();
        if (!destinationWorld.method_22340(class_2338.method_49638((class_2374)boxOtherSide.method_1005()))) {
            return PortalCollisionHandler.handleOtherSideChunkNotLoaded(entity, attemptedMove, collidingPortal, originalBoundingBox);
        }
        List<Portal> indirectCollidingPortals = McHelper.findEntitiesByBox(Portal.class, collidingPortal.getDestinationWorld(), boxOtherSide.method_18804(transformedAttemptedMove), IPGlobal.maxNormalPortalRadius, p -> CollisionHelper.canCollideWithPortal(entity, p, 0.0f) && collidingPortal.isOnDestinationSide(p.getOriginPos(), 0.1));
        PortalLike collisionHandlingUnit = CollisionHelper.getCollisionHandlingUnit(collidingPortal);
        class_2350 transformedGravityDirection = collidingPortal.getTransformedGravityDirection(GravityChangerInterface.invoker.getGravityDirection(entity));
        class_243 collided = transformedAttemptedMove;
        collided = CollisionHelper.handleCollisionWithShapeProcessor(entity, boxOtherSide, destinationWorld, collided, shape -> {
            class_265 current = CollisionHelper.clipVoxelShape(shape, collidingPortal.getDestPos(), collidingPortal.getContentDirection());
            if (current == null) {
                return null;
            }
            if (!indirectCollidingPortals.isEmpty()) {
                current = PortalCollisionHandler.processThisSideCollisionShape(current, indirectCollidingPortals);
            }
            return current;
        }, transformedGravityDirection, collidingPortal.getScale());
        if (!indirectCollidingPortals.isEmpty()) {
            for (Portal indirectCollidingPortal : indirectCollidingPortals) {
                collided = PortalCollisionHandler.handleOtherSideMove(entity, collided, indirectCollidingPortal, boxOtherSide, portalLayer + 1);
            }
        }
        collided = new class_243(CollisionHelper.fixCoordinateFloatingPointError(transformedAttemptedMove.field_1352, collided.field_1352), CollisionHelper.fixCoordinateFloatingPointError(transformedAttemptedMove.field_1351, collided.field_1351), CollisionHelper.fixCoordinateFloatingPointError(transformedAttemptedMove.field_1350, collided.field_1350));
        class_243 result = collidingPortal.inverseTransformLocalVec(collided);
        return result;
    }

    private static class_243 handleOtherSideChunkNotLoaded(class_1297 entity, class_243 attemptedMove, Portal collidingPortal, class_238 originalBoundingBox) {
        class_243 innerDirection;
        if (entity instanceof class_1657 && entity.method_37908().method_8608()) {
            CollisionHelper.informClientStagnant();
        }
        if (attemptedMove.method_1026(innerDirection = collidingPortal.getNormal().method_1021(-1.0)) < 0.0) {
            return attemptedMove;
        }
        double innerSignedDistance = Arrays.stream(Helper.eightVerticesOf((class_238)originalBoundingBox)).mapToDouble(pos -> pos.method_1020(collidingPortal.getOriginPos()).method_1026(collidingPortal.getNormal())).min().orElseThrow();
        if (innerSignedDistance < 0.0) {
            return attemptedMove.method_1019(collidingPortal.getNormal().method_1021(-innerSignedDistance)).method_1020(innerDirection.method_1021(innerDirection.method_1026(attemptedMove)));
        }
        return attemptedMove.method_1020(innerDirection.method_1021(innerDirection.method_1026(attemptedMove)));
    }

    private static class_243 handleThisSideMove(class_1297 entity, class_243 attemptedMove, class_238 originalBoundingBox, List<PortalCollisionEntry> portalCollisions) {
        class_2350 gravity = GravityChangerInterface.invoker.getGravityDirection(entity);
        return CollisionHelper.handleCollisionWithShapeProcessor(entity, entity.method_5829(), entity.method_37908(), attemptedMove, shape -> PortalCollisionHandler.processThisSideCollisionShape(shape, Helper.mappedListView((List)portalCollisions, e -> e.portal)), gravity, 1.0);
    }

    @Nullable
    private static class_265 processThisSideCollisionShape(class_265 originalShape, List<Portal> portalCollisions) {
        class_265 shape = originalShape;
        if (shape.method_1110()) {
            return shape;
        }
        class_238 shapeBounds = shape.method_1107();
        for (int i = 0; i < portalCollisions.size(); ++i) {
            Portal portal = portalCollisions.get(i);
            boolean boxFullyBehindPlane = CollisionHelper.isBoxFullyBehindPlane(portal.getOriginPos(), portal.getNormal(), shapeBounds);
            if (!boxFullyBehindPlane) continue;
            class_265 exclusion = portal.getThisSideCollisionExclusion();
            if (Helper.boxContains((class_238)exclusion.method_1107(), (class_238)shapeBounds)) {
                return null;
            }
            if ((shape = class_259.method_1082((class_265)shape, (class_265)exclusion, (class_247)class_247.field_16886)).method_1110()) {
                return shape;
            }
            shapeBounds = shape.method_1107();
        }
        return shape;
    }

    @Nullable
    public class_238 getActiveCollisionBox(class_1297 entity, class_238 rawBoundingBox) {
        class_238 currentBox = rawBoundingBox;
        for (PortalCollisionEntry portalCollision : this.portalCollisions) {
            Portal portal = portalCollision.portal;
            class_238 newBox = CollisionHelper.clipBox(currentBox, portal.getOriginPos(), portal.getNormal());
            if (newBox == null) {
                return null;
            }
            currentBox = newBox;
        }
        return currentBox;
    }

    public static void updateCollidingPortalAfterTeleportation(class_1297 entity, class_243 newEyePos, class_243 newLastTickEyePos, float partialTicks) {
        ((IEEntity)entity).ip_clearCollidingPortal();
        McHelper.findEntitiesByBox(Portal.class, entity.method_37908(), CollisionHelper.getStretchedBoundingBox(entity), IPGlobal.maxNormalPortalRadius, p -> true).forEach(p -> CollisionHelper.notifyCollidingPortals(p, partialTicks));
        McHelper.setEyePos(entity, newEyePos, newLastTickEyePos);
        McHelper.updateBoundingBox(entity);
    }

    public boolean hasCollisionEntry() {
        return !this.portalCollisions.isEmpty();
    }

    public void notifyCollidingWithPortal(class_1297 entity, Portal portal) {
        if (this.portalCollisions.size() >= 6) {
            return;
        }
        long timing = PortalCollisionHandler.getTiming(entity);
        int i = Helper.indexOf(this.portalCollisions, p -> p.portal == portal);
        if (i == -1) {
            this.portalCollisions.add(new PortalCollisionEntry(portal, timing));
        } else {
            this.portalCollisions.get((int)i).activeTime = timing;
        }
        portal.onCollidingWithEntity(entity);
        this.lastActiveTime = timing;
    }

    public List<Portal> getCollidingPortals() {
        return Helper.mappedListView(this.portalCollisions, p -> p.portal);
    }
}

