/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2666;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.ChunkVisibility;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTickets;
import qouteall.imm_ptl.core.chunk_loading.PerformanceLevel;
import qouteall.imm_ptl.core.ducks.IEThreadedAnvilChunkStorage;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.SignalBiArged;

public class NewChunkTrackingGraph {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int updateInterval = 13;
    public static final int defaultDelayUnloadGenerations = 4;
    private static final Map<class_5321<class_1937>, Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord>>> chunkWatchRecords = new Object2ObjectOpenHashMap();
    private static final ArrayList<ChunkLoader> additionalChunkLoaders = new ArrayList();
    private static final Object2ObjectOpenHashMap<class_3222, PlayerInfo> playerInfoMap = new Object2ObjectOpenHashMap();
    public static final SignalBiArged<class_3222, DimensionalChunkPos> beginWatchChunkSignal = new SignalBiArged();
    public static final SignalBiArged<class_3222, DimensionalChunkPos> endWatchChunkSignal = new SignalBiArged();
    private static int generationCounter = 0;

    private static Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord>> getDimChunkWatchRecords(class_5321<class_1937> dimension) {
        return chunkWatchRecords.computeIfAbsent(dimension, k -> new Long2ObjectOpenHashMap());
    }

    public static PlayerInfo getPlayerInfo(class_3222 player) {
        return (PlayerInfo)playerInfoMap.computeIfAbsent((Object)player, k -> new PlayerInfo());
    }

    public static void updateForPlayer(class_3222 player) {
        PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
        playerInfo.visibleDimensions.clear();
        int lastLoadedChunks = playerInfo.loadedChunks;
        playerInfo.loadedChunks = 0;
        ObjectOpenHashSet chunkLoaders = new ObjectOpenHashSet();
        ChunkVisibility.foreachBaseChunkLoaders(player, arg_0 -> ((ObjectOpenHashSet)chunkLoaders).add(arg_0));
        chunkLoaders.addAll(playerInfo.additionalChunkLoaders);
        MinecraftServer server = MiscHelper.getServer();
        for (ChunkLoader chunkLoader : chunkLoaders) {
            class_5321<class_1937> dimension = chunkLoader.center.dimension;
            Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord>> chunkRecordMap = NewChunkTrackingGraph.getDimChunkWatchRecords(dimension);
            class_3218 world = server.method_3847(dimension);
            if (world == null) {
                LOGGER.warn("Dimension not loaded {} in chunk loader {}", dimension, (Object)chunkLoader);
                return;
            }
            playerInfo.visibleDimensions.add(dimension);
            ImmPtlChunkTickets ticketInfo = ImmPtlChunkTickets.get(world);
            chunkLoader.foreachChunkPos((dim, x, z, distanceToSource) -> {
                long chunkPos = class_1923.method_8331((int)x, (int)z);
                Object2ObjectOpenHashMap records = (Object2ObjectOpenHashMap)chunkRecordMap.computeIfAbsent(chunkPos, k -> new Object2ObjectOpenHashMap());
                ticketInfo.markForLoading(chunkPos, distanceToSource, generationCounter);
                records.compute((Object)player, (k, record) -> {
                    boolean isBoundary;
                    boolean bl = isBoundary = distanceToSource == chunkLoader.radius;
                    if (record == null) {
                        PlayerWatchRecord newRecord = new PlayerWatchRecord(player, dimension, chunkPos, generationCounter, distanceToSource, false, isBoundary);
                        playerInfo.markPendingLoading(newRecord);
                        ++playerInfo.loadedChunks;
                        return newRecord;
                    }
                    int oldDistance = record.distanceToSource;
                    if (record.lastWatchGeneration == generationCounter) {
                        if (distanceToSource < oldDistance) {
                            record.distanceToSource = distanceToSource;
                            playerInfo.markPendingLoading((PlayerWatchRecord)record);
                        }
                        record.isBoundary = record.isBoundary && isBoundary;
                    } else {
                        ++playerInfo.loadedChunks;
                        if (distanceToSource < oldDistance) {
                            playerInfo.markPendingLoading((PlayerWatchRecord)record);
                        }
                        record.distanceToSource = distanceToSource;
                        record.lastWatchGeneration = generationCounter;
                        record.isBoundary = isBoundary;
                    }
                    return record;
                });
            });
        }
    }

    public static void flushPendingLoading(class_3222 player, int generation) {
        PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
        int limit = NewChunkTrackingGraph.getChunkDeliveringLimitPerTick(player);
        int loaded = 0;
        for (int distance = 0; distance < playerInfo.distanceToPendingChunks.size(); ++distance) {
            ArrayDeque<PlayerWatchRecord> records = playerInfo.distanceToPendingChunks.get(distance);
            if (records == null) continue;
            while (!records.isEmpty() && loaded < limit) {
                PlayerWatchRecord record = records.pollFirst();
                if (!record.isValid || record.isLoadedToPlayer) continue;
                record.isLoadedToPlayer = true;
                class_3218 world = MiscHelper.getServer().method_3847(record.dimension);
                if (world != null) {
                    class_1923 chunkPos = new class_1923(record.chunkPos);
                    beginWatchChunkSignal.emit((Object)player, (Object)new DimensionalChunkPos(record.dimension, chunkPos));
                    ++loaded;
                    continue;
                }
                LOGGER.error("Missing dimension when flushing pending loading {}", (Object)record.dimension.method_29177());
            }
        }
    }

    private static int getChunkDeliveringLimitPerTick(class_3222 player) {
        return 200;
    }

    private static void purge(Object2ObjectOpenHashMap<class_5321<class_1937>, LongOpenHashSet> additionalLoadedChunks) {
        chunkWatchRecords.forEach((dimension, chunkRecords) -> chunkRecords.long2ObjectEntrySet().removeIf(entry -> {
            long chunkPosLong = entry.getLongKey();
            Object2ObjectOpenHashMap dimChunkWatchRecords = (Object2ObjectOpenHashMap)entry.getValue();
            dimChunkWatchRecords.entrySet().removeIf(e -> {
                boolean shouldRemove;
                class_3222 player = (class_3222)e.getKey();
                if (player.method_31481()) {
                    return true;
                }
                PlayerWatchRecord record = (PlayerWatchRecord)e.getValue();
                int delayUnloadGenerations = NewChunkTrackingGraph.getDelayUnloadGenerationForPlayer(player);
                boolean bl = shouldRemove = generationCounter - record.lastWatchGeneration > delayUnloadGenerations;
                if (shouldRemove) {
                    if (record.isLoadedToPlayer) {
                        endWatchChunkSignal.emit((Object)record.player, (Object)new DimensionalChunkPos((class_5321<class_1937>)dimension, class_1923.method_8325((long)chunkPosLong), class_1923.method_8332((long)chunkPosLong)));
                    }
                    record.isValid = false;
                }
                return shouldRemove;
            });
            return dimChunkWatchRecords.isEmpty();
        }));
        playerInfoMap.entrySet().removeIf(e -> ((class_3222)e.getKey()).method_31481());
        MinecraftServer server = MiscHelper.getServer();
        for (class_3218 world : server.method_3738()) {
            class_5321 dimension2 = world.method_27983();
            @Nullable LongOpenHashSet additional = (LongOpenHashSet)additionalLoadedChunks.get((Object)dimension2);
            Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord>> watchRecs = chunkWatchRecords.get(dimension2);
            ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
            dimTicketManager.purge(world, chunkPos -> {
                if (watchRecs != null && watchRecs.containsKey(chunkPos)) {
                    return true;
                }
                return additional != null && additional.contains(chunkPos);
            });
        }
    }

    private static int getDelayUnloadGenerationForPlayer(class_3222 player) {
        PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
        if (playerInfo == null) {
            return 4;
        }
        int loadedChunks = playerInfo.loadedChunks;
        if (loadedChunks > 2000) {
            return 1;
        }
        if (loadedChunks > 1200) {
            return 2;
        }
        return 4;
    }

    private static Object2ObjectOpenHashMap<class_5321<class_1937>, LongOpenHashSet> refreshAdditionalChunkLoaders() {
        Object2ObjectOpenHashMap additionalLoadedChunks = new Object2ObjectOpenHashMap();
        additionalChunkLoaders.removeIf(chunkLoader -> {
            class_5321<class_1937> dimension = chunkLoader.center.dimension;
            class_3218 world = MiscHelper.getServer().method_3847(dimension);
            if (world == null) {
                LOGGER.error("Missing dimension in chunk loader {}", (Object)dimension.method_29177());
                return true;
            }
            final ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
            final LongOpenHashSet set = (LongOpenHashSet)additionalLoadedChunks.computeIfAbsent(dimension, k -> new LongOpenHashSet());
            chunkLoader.foreachChunkPos(new ChunkLoader.ChunkPosConsumer(){

                @Override
                public void consume(class_5321<class_1937> dimension, int x, int z, int distanceToSource) {
                    long chunkPos = class_1923.method_8331((int)x, (int)z);
                    dimTicketManager.markForLoading(chunkPos, distanceToSource, generationCounter);
                    set.add(chunkPos);
                }
            });
            return false;
        });
        return additionalLoadedChunks;
    }

    private static void tick() {
        MinecraftServer server = MiscHelper.getServer();
        server.method_16044().method_15396("portal_chunk_tracking");
        long gameTime = McHelper.getOverWorldOnServer().method_8510();
        server.method_3760().method_14571().forEach(player -> {
            PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
            if (playerInfo.shouldUpdateImmediately || (long)(player.method_5628() % 13) == gameTime % 13L) {
                playerInfo.shouldUpdateImmediately = false;
                NewChunkTrackingGraph.updateForPlayer(player);
            }
            NewChunkTrackingGraph.flushPendingLoading(player, generationCounter);
        });
        if (gameTime % 13L == 0L) {
            Object2ObjectOpenHashMap<class_5321<class_1937>, LongOpenHashSet> additionalLoadedChunks = NewChunkTrackingGraph.refreshAdditionalChunkLoaders();
            NewChunkTrackingGraph.purge(additionalLoadedChunks);
            ++generationCounter;
        }
        for (class_3218 world : MiscHelper.getServer().method_3738()) {
            ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
            IEThreadedAnvilChunkStorage chunkMap = (IEThreadedAnvilChunkStorage)world.method_14178().field_17254;
            dimTicketManager.tick(world);
        }
        server.method_16044().method_15407();
    }

    public static void init() {
        IPGlobal.postServerTickSignal.connect(NewChunkTrackingGraph::tick);
        IPGlobal.serverCleanupSignal.connect(NewChunkTrackingGraph::cleanup);
    }

    public static boolean isPlayerWatchingChunk(class_3222 player, class_5321<class_1937> dimension, int x, int z, Predicate<PlayerWatchRecord> predicate) {
        long chunkPos = class_1923.method_8331((int)x, (int)z);
        Object2ObjectOpenHashMap recordMap = (Object2ObjectOpenHashMap)NewChunkTrackingGraph.getDimChunkWatchRecords(dimension).get(chunkPos);
        if (recordMap == null) {
            return false;
        }
        PlayerWatchRecord record = (PlayerWatchRecord)recordMap.get((Object)player);
        if (record == null) {
            return false;
        }
        if (!record.isLoadedToPlayer) {
            return false;
        }
        return predicate.test(record);
    }

    public static boolean isPlayerWatchingChunk(class_3222 player, class_5321<class_1937> dimension, int x, int z) {
        return NewChunkTrackingGraph.isPlayerWatchingChunk(player, dimension, x, z, r -> true);
    }

    public static boolean isPlayerWatchingChunkWithinRadius(class_3222 player, class_5321<class_1937> dimension, int x, int z, int radiusBlocks) {
        return NewChunkTrackingGraph.isPlayerWatchingChunk(player, dimension, x, z, r -> r.distanceToSource * 16 <= radiusBlocks);
    }

    private static void cleanup() {
        chunkWatchRecords.clear();
        additionalChunkLoaders.clear();
        playerInfoMap.clear();
    }

    public static Stream<class_3222> getPlayersViewingChunk(class_5321<class_1937> dimension, int x, int z) {
        Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord> records = NewChunkTrackingGraph.getPlayerWatchListRecord(dimension, x, z);
        if (records == null) {
            return Stream.empty();
        }
        return records.values().stream().filter(e -> e.isLoadedToPlayer).map(e -> e.player);
    }

    public static List<class_3222> getPlayersViewingChunk(class_5321<class_1937> dimension, int x, int z, boolean boundaryOnly) {
        Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord> recs = NewChunkTrackingGraph.getPlayerWatchListRecord(dimension, x, z);
        if (recs == null) {
            return Collections.emptyList();
        }
        ArrayList<class_3222> result = new ArrayList<class_3222>();
        for (PlayerWatchRecord rec : recs.values()) {
            if (!rec.isLoadedToPlayer || boundaryOnly && !rec.isBoundary) continue;
            result.add(rec.player);
        }
        return result;
    }

    @Nullable
    public static Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord> getPlayerWatchListRecord(class_5321<class_1937> dimension, int x, int z) {
        return (Object2ObjectOpenHashMap)NewChunkTrackingGraph.getDimChunkWatchRecords(dimension).get(class_1923.method_8331((int)x, (int)z));
    }

    public static void forceRemovePlayer(class_3222 player) {
        chunkWatchRecords.forEach((dim, dimMap) -> dimMap.long2ObjectEntrySet().removeIf(e -> {
            long chunkPos = e.getLongKey();
            Object2ObjectOpenHashMap records = (Object2ObjectOpenHashMap)e.getValue();
            PlayerWatchRecord rec = (PlayerWatchRecord)records.remove((Object)player);
            if (rec != null) {
                PacketRedirection.sendRedirectedMessage(player, (class_5321<class_1937>)dim, (class_2596)new class_2666(class_1923.method_8325((long)chunkPos), class_1923.method_8332((long)chunkPos)));
            }
            return records.isEmpty();
        }));
    }

    public static void forceRemoveDimension(class_5321<class_1937> dim) {
        Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord>> map = chunkWatchRecords.get(dim);
        if (map == null) {
            return;
        }
        map.forEach((chunkPos, records) -> {
            class_2596<class_2602> unloadPacket = PacketRedirection.createRedirectedMessage(dim, (class_2596<class_2602>)new class_2666(class_1923.method_8325((long)chunkPos), class_1923.method_8332((long)chunkPos)));
            for (PlayerWatchRecord record : records.values()) {
                if (record.isValid && record.isLoadedToPlayer) {
                    record.player.field_13987.method_14364(unloadPacket);
                }
                record.isValid = false;
            }
        });
        chunkWatchRecords.remove(dim);
        additionalChunkLoaders.removeIf(chunkLoader -> chunkLoader.center.dimension == dim);
        for (PlayerInfo playerInfo : playerInfoMap.values()) {
            playerInfo.additionalChunkLoaders.removeIf(l -> l.center.dimension == dim);
        }
    }

    public static boolean shouldLoadDimension(class_5321<class_1937> dimension) {
        if (!chunkWatchRecords.containsKey(dimension)) {
            return false;
        }
        Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<class_3222, PlayerWatchRecord>> map = chunkWatchRecords.get(dimension);
        return !map.isEmpty();
    }

    public static void addGlobalAdditionalChunkLoader(ChunkLoader chunkLoader) {
        additionalChunkLoaders.add(chunkLoader);
        class_5321<class_1937> dimension = chunkLoader.center.dimension;
        class_3218 world = MiscHelper.getServer().method_3847(dimension);
        if (world == null) {
            LOGGER.error("Missing dimension in chunk loader {}", (Object)dimension.method_29177());
            return;
        }
        ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
        chunkLoader.foreachChunkPos((dim, x, z, distanceToSource) -> dimTicketManager.markForLoading(class_1923.method_8331((int)x, (int)z), distanceToSource, generationCounter));
    }

    public static void removeGlobalAdditionalChunkLoader(ChunkLoader chunkLoader) {
        additionalChunkLoaders.removeIf(c -> c == chunkLoader);
    }

    public static int getLoadedChunkNum(class_5321<class_1937> dimension) {
        return NewChunkTrackingGraph.getDimChunkWatchRecords(dimension).size();
    }

    public static void addPerPlayerAdditionalChunkLoader(class_3222 player, ChunkLoader chunkLoader) {
        PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
        playerInfo.additionalChunkLoaders.add(chunkLoader);
        playerInfo.shouldUpdateImmediately = true;
    }

    public static void removePerPlayerAdditionalChunkLoader(class_3222 player, ChunkLoader chunkLoader) {
        ArrayList<ChunkLoader> chunkLoaderList = NewChunkTrackingGraph.getPlayerInfo((class_3222)player).additionalChunkLoaders;
        chunkLoaderList.removeIf(c -> c == chunkLoader);
    }

    public static Set<class_5321<class_1937>> getVisibleDimensions(class_3222 player) {
        return NewChunkTrackingGraph.getPlayerInfo((class_3222)player).visibleDimensions;
    }

    public static class PlayerInfo {
        public final Set<class_5321<class_1937>> visibleDimensions = new ObjectOpenHashSet();
        public final ArrayList<ChunkLoader> additionalChunkLoaders = new ArrayList();
        public final ArrayList<ArrayDeque<PlayerWatchRecord>> distanceToPendingChunks = new ArrayList();
        public int loadedChunks = 0;
        public boolean shouldUpdateImmediately = false;
        public PerformanceLevel performanceLevel = PerformanceLevel.bad;

        public void markPendingLoading(PlayerWatchRecord record) {
            ((ArrayDeque)Helper.arrayListComputeIfAbsent(this.distanceToPendingChunks, (int)record.distanceToSource, ArrayDeque::new)).add(record);
        }
    }

    public static class PlayerWatchRecord {
        public final class_3222 player;
        public final class_5321<class_1937> dimension;
        public final long chunkPos;
        public int lastWatchGeneration;
        public int distanceToSource;
        public boolean isLoadedToPlayer;
        public boolean isValid = true;
        public boolean isBoundary = false;

        public PlayerWatchRecord(class_3222 player, class_5321<class_1937> dimension, long chunkPos, int lastWatchGeneration, int distanceToSource, boolean isLoadedToPlayer, boolean isBoundary) {
            this.player = player;
            this.dimension = dimension;
            this.chunkPos = chunkPos;
            this.lastWatchGeneration = lastWatchGeneration;
            this.distanceToSource = distanceToSource;
            this.isLoadedToPlayer = isLoadedToPlayer;
            this.isBoundary = isBoundary;
        }

        public String toString() {
            return String.format("%s (%d,%d) distance:%d valid:%s loaded:%s", this.dimension.method_29177(), class_1923.method_8325((long)this.chunkPos), class_1923.method_8332((long)this.chunkPos), this.distanceToSource, this.isValid, this.isLoadedToPlayer);
        }
    }

    public static class RemoteCallables {
        public static void acceptClientPerformanceInfo(class_3222 player, PerformanceLevel performanceLevel) {
            PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
            playerInfo.performanceLevel = performanceLevel;
        }
    }
}

