/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_5568;
import net.minecraft.server.MinecraftServer;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IEEntityTracker;
import qouteall.imm_ptl.core.ducks.IEThreadedAnvilChunkStorage;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DynamicDimensionsImpl;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class EntitySync {
    private static final LimitedLogger limitedLogger = new LimitedLogger(100);

    public static void init() {
        IPGlobal.postServerTickSignal.connect(EntitySync::tick);
        DynamicDimensionsImpl.beforeRemovingDimensionSignal.connect(EntitySync::forceRemoveDimension);
    }

    private static void tick() {
        MinecraftServer server = MiscHelper.getServer();
        server.method_16044().method_15396("ip_entity_tracking");
        List<class_3222> playerList = McHelper.getRawPlayerList();
        ArrayList<class_3222> dirtyPlayers = new ArrayList<class_3222>();
        for (class_3222 player : playerList) {
            class_3898 storage = ((class_3218)player.method_37908()).method_14178().field_17254;
            Int2ObjectMap<class_3898.class_3208> entityTrackerMap = ((IEThreadedAnvilChunkStorage)storage).ip_getEntityTrackerMap();
            class_3898.class_3208 playerItselfTracker = (class_3898.class_3208)entityTrackerMap.get(player.method_5628());
            if (playerItselfTracker == null || !EntitySync.isDirty(playerItselfTracker)) continue;
            dirtyPlayers.add(player);
        }
        server.method_3738().forEach(world -> {
            class_3898 storage = world.method_14178().field_17254;
            Int2ObjectMap<class_3898.class_3208> entityTrackerMap = ((IEThreadedAnvilChunkStorage)storage).ip_getEntityTrackerMap();
            PacketRedirection.withForceRedirect(world, () -> {
                for (class_3898.class_3208 tracker : entityTrackerMap.values()) {
                    ((IEEntityTracker)tracker).tickEntry();
                    boolean dirty = EntitySync.isDirty(tracker);
                    List updatedPlayerList = dirty ? playerList : dirtyPlayers;
                    for (class_3222 player : updatedPlayerList) {
                        ((IEEntityTracker)tracker).updateEntityTrackingStatus(player);
                    }
                    if (!dirty) continue;
                    EntitySync.markUnDirty(tracker);
                }
            });
        });
        server.method_16044().method_15407();
    }

    private static boolean isDirty(class_3898.class_3208 tracker) {
        class_4076 newPos = class_4076.method_42614((class_5568)((IEEntityTracker)tracker).getEntity_());
        return !((IEEntityTracker)tracker).getLastCameraPosition().equals((Object)newPos);
    }

    private static void markUnDirty(class_3898.class_3208 tracker) {
        class_4076 currPos = class_4076.method_42614((class_5568)((IEEntityTracker)tracker).getEntity_());
        ((IEEntityTracker)tracker).setLastCameraPosition(currPos);
    }

    private static void forceRemoveDimension(class_5321<class_1937> dimension) {
    }
}

