/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2666;
import net.minecraft.class_2672;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3227;
import net.minecraft.class_3568;
import net.minecraft.class_5321;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.chunk_loading.NewChunkTrackingGraph;
import qouteall.imm_ptl.core.ducks.IEThreadedAnvilChunkStorage;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DynamicDimensionsImpl;

public class ChunkDataSyncManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int unloadWaitingTickTime = 200;
    private static final boolean debugLightStatus = true;

    public ChunkDataSyncManager() {
        NewChunkTrackingGraph.beginWatchChunkSignal.connectWithWeakRef((Object)this, ChunkDataSyncManager::onBeginWatch);
        NewChunkTrackingGraph.endWatchChunkSignal.connectWithWeakRef((Object)this, ChunkDataSyncManager::onEndWatch);
        DynamicDimensionsImpl.beforeRemovingDimensionSignal.connectWithWeakRef((Object)this, ChunkDataSyncManager::onDimensionRemove);
    }

    private void onBeginWatch(class_3222 player, DimensionalChunkPos chunkPos) {
        MiscHelper.getServer().method_16044().method_15396("begin_watch");
        IEThreadedAnvilChunkStorage ieStorage = McHelper.getIEStorage(chunkPos.dimension);
        this.sendChunkDataPacketNow(player, chunkPos, ieStorage);
        MiscHelper.getServer().method_16044().method_15407();
    }

    private void sendChunkDataPacketNow(class_3222 player, DimensionalChunkPos chunkPos, IEThreadedAnvilChunkStorage ieStorage) {
        class_2818 chunk;
        class_3193 chunkHolder = ieStorage.ip_getChunkHolder(chunkPos.getChunkPos().method_8324());
        class_3227 lightingProvider = ieStorage.ip_getLightingProvider();
        if (chunkHolder != null && (chunk = chunkHolder.method_16144()) != null) {
            MiscHelper.getServer().method_16044().method_15396("ptl_create_chunk_packet");
            PacketRedirection.sendRedirectedMessage(player, chunkPos.dimension, (class_2596)new class_2672(chunk, (class_3568)lightingProvider, null, null));
            ieStorage.ip_updateEntityTrackersAfterSendingChunkPacket(chunk, player);
            MiscHelper.getServer().method_16044().method_15407();
            return;
        }
    }

    public void onChunkProvidedDeferred(class_2818 chunk) {
        class_5321 dimension = chunk.method_12200().method_27983();
        IEThreadedAnvilChunkStorage ieStorage = McHelper.getIEStorage((class_5321<class_1937>)dimension);
        class_3227 lightingProvider = ieStorage.ip_getLightingProvider();
        MiscHelper.getServer().method_16044().method_15396("ptl_create_chunk_packet");
        Supplier chunkDataPacketRedirected = Helper.cached(() -> PacketRedirection.createRedirectedMessage((class_5321<class_1937>)dimension, (class_2596<class_2602>)new class_2672(chunk, (class_3568)lightingProvider, null, null)));
        NewChunkTrackingGraph.getPlayersViewingChunk((class_5321<class_1937>)dimension, chunk.method_12004().field_9181, chunk.method_12004().field_9180).forEach(arg_0 -> ChunkDataSyncManager.lambda$onChunkProvidedDeferred$1((Supplier)chunkDataPacketRedirected, ieStorage, chunk, arg_0));
        MiscHelper.getServer().method_16044().method_15407();
    }

    private void onEndWatch(class_3222 player, DimensionalChunkPos chunkPos) {
        player.field_13987.method_14364(PacketRedirection.createRedirectedMessage(chunkPos.dimension, (class_2596<class_2602>)new class_2666(chunkPos.x, chunkPos.z)));
    }

    public void removePlayerFromChunkTrackersAndEntityTrackers(class_3222 oldPlayer) {
        for (class_3218 world : MiscHelper.getServer().method_3738()) {
            class_3215 chunkManager = world.method_14178();
            IEThreadedAnvilChunkStorage storage = (IEThreadedAnvilChunkStorage)chunkManager.field_17254;
            storage.ip_onPlayerUnload(oldPlayer);
        }
        NewChunkTrackingGraph.forceRemovePlayer(oldPlayer);
    }

    @Deprecated
    public void removePlayerFromEntityTrackersWithoutSendingPacket(class_3222 player) {
        for (class_3218 world : MiscHelper.getServer().method_3738()) {
            class_3215 chunkManager = world.method_14178();
            IEThreadedAnvilChunkStorage storage = (IEThreadedAnvilChunkStorage)chunkManager.field_17254;
            storage.ip_onPlayerDisconnected(player);
        }
    }

    public void onDimensionRemove(class_5321<class_1937> dimension) {
        class_3218 world = McHelper.getServerWorld(dimension);
        class_3215 chunkManager = world.method_14178();
        IEThreadedAnvilChunkStorage storage = (IEThreadedAnvilChunkStorage)chunkManager.field_17254;
        storage.ip_onDimensionRemove();
        NewChunkTrackingGraph.forceRemoveDimension(dimension);
    }

    private static /* synthetic */ void lambda$onChunkProvidedDeferred$1(Supplier chunkDataPacketRedirected, IEThreadedAnvilChunkStorage ieStorage, class_2818 chunk, class_3222 player) {
        player.field_13987.method_14364((class_2596)chunkDataPacketRedirected.get());
        ieStorage.ip_updateEntityTrackersAfterSendingChunkPacket(chunk, player);
    }
}

