/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.api;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.NewChunkTrackingGraph;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;

public class PortalAPI {
    public static void setPortalPositionOrientationAndSize(Portal portal, class_243 position, DQuaternion orientation, double width, double height) {
        portal.setOriginPos(position);
        portal.setOrientationAndSize(McHelper.getAxisWFromOrientation(orientation), McHelper.getAxisHFromOrientation(orientation), width, height);
    }

    public static void setPortalOrthodoxShape(Portal portal, class_2350 facing, class_238 portalArea) {
        class_3545 directions = Helper.getPerpendicularDirections((class_2350)facing);
        class_243 areaSize = Helper.getBoxSize((class_238)portalArea);
        class_238 boxSurface = Helper.getBoxSurface((class_238)portalArea, (class_2350)facing);
        class_243 center = boxSurface.method_1005();
        portal.method_5814(center.field_1352, center.field_1351, center.field_1350);
        portal.axisW = class_243.method_24954((class_2382)((class_2350)directions.method_15442()).method_10163());
        portal.axisH = class_243.method_24954((class_2382)((class_2350)directions.method_15441()).method_10163());
        portal.width = Helper.getCoordinate((class_243)areaSize, (class_2350.class_2351)((class_2350)directions.method_15442()).method_10166());
        portal.height = Helper.getCoordinate((class_243)areaSize, (class_2350.class_2351)((class_2350)directions.method_15441()).method_10166());
    }

    public static void setPortalTransformation(Portal portal, class_5321<class_1937> destinationDimension, class_243 destinationPosition, @Nullable DQuaternion rotation, double scale) {
        portal.setDestinationDimension(destinationDimension);
        portal.setDestination(destinationPosition);
        portal.setRotation(rotation);
        portal.setScaleTransformation(scale);
    }

    public static DQuaternion getPortalOrientationQuaternion(Portal portal) {
        return PortalManipulation.getPortalOrientationQuaternion(portal.axisW, portal.axisH);
    }

    public static void setPortalOrientationQuaternion(Portal portal, DQuaternion quaternion) {
        PortalManipulation.setPortalOrientationQuaternion(portal, quaternion);
    }

    public static void spawnServerEntity(class_1297 entity) {
        McHelper.spawnServerEntity(entity);
    }

    public static <T extends Portal> T createReversePortal(T portal) {
        return PortalManipulation.createReversePortal(portal, portal.method_5864());
    }

    public static <T extends Portal> T createFlippedPortal(T portal) {
        return PortalManipulation.createFlippedPortal(portal, portal.method_5864());
    }

    public static <T extends Portal> T copyPortal(Portal portal, class_1299<T> entityType) {
        return (T)PortalManipulation.copyPortal(portal, entityType);
    }

    public static void addGlobalPortal(class_3218 world, Portal portal) {
        McHelper.validateOnServerThread();
        GlobalPortalStorage.get(world).addPortal(portal);
    }

    public static void removeGlobalPortal(class_3218 world, Portal portal) {
        McHelper.validateOnServerThread();
        GlobalPortalStorage.get(world).removePortal(portal);
    }

    public static void addChunkLoaderForPlayer(class_3222 player, ChunkLoader chunkLoader) {
        McHelper.validateOnServerThread();
        NewChunkTrackingGraph.addPerPlayerAdditionalChunkLoader(player, chunkLoader);
    }

    public static void removeChunkLoaderForPlayer(class_3222 player, ChunkLoader chunkLoader) {
        McHelper.validateOnServerThread();
        NewChunkTrackingGraph.removePerPlayerAdditionalChunkLoader(player, chunkLoader);
    }

    public static void teleportEntity(class_1297 entity, class_3218 targetWorld, class_243 targetPos) {
        ServerTeleportationManager.teleportEntityGeneral(entity, targetPos, targetWorld);
    }
}

