/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_22;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_761;
import net.minecraft.class_7924;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IECamera;
import qouteall.imm_ptl.core.ducks.IEClientPlayNetworkHandler;
import qouteall.imm_ptl.core.ducks.IEClientWorld;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.ducks.IEParticleManager;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.mixin.client.accessor.IEClientLevel_Accessor;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.context_management.DimensionRenderHelper;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.api.DimensionAPI;
import qouteall.q_misc_util.dimension.DimensionTypeSync;
import qouteall.q_misc_util.my_util.LimitedLogger;
import qouteall.q_misc_util.my_util.SignalArged;

@Environment(value=EnvType.CLIENT)
public class ClientWorldLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientWorldLoader.class);
    public static final SignalArged<class_5321<class_1937>> clientDimensionDynamicRemoveSignal = new SignalArged();
    public static final SignalArged<class_638> clientWorldLoadSignal = new SignalArged();
    public static boolean isFlatWorld = false;
    private static final Map<class_5321<class_1937>, class_638> clientWorldMap = new HashMap<class_5321<class_1937>, class_638>();
    public static final Map<class_5321<class_1937>, class_761> worldRendererMap = new HashMap<class_5321<class_1937>, class_761>();
    public static final Map<class_5321<class_1937>, DimensionRenderHelper> renderHelperMap = new HashMap<class_5321<class_1937>, DimensionRenderHelper>();
    private static final class_310 client = class_310.method_1551();
    private static boolean isInitialized = false;
    private static boolean isCreatingClientWorld = false;
    public static boolean isClientRemoteTicking = false;
    private static boolean isWorldSwitched = false;
    private static final LimitedLogger limitedLogger = new LimitedLogger(10);
    private static boolean isReloadingOtherWorldRenderers = false;

    public static void init() {
        IPGlobal.clientCleanupSignal.connect(ClientWorldLoader::cleanUp);
        DimensionAPI.clientDimensionUpdateEvent.register(serverDimensions -> {
            if (ClientWorldLoader.getIsInitialized()) {
                List<class_5321> dimensionsToRemove = clientWorldMap.keySet().stream().filter(dim -> !serverDimensions.contains(dim)).toList();
                for (class_5321 dim2 : dimensionsToRemove) {
                    ClientWorldLoader.disposeDimensionDynamically((class_5321<class_1937>)dim2);
                }
            }
        });
    }

    public static boolean getIsInitialized() {
        return isInitialized;
    }

    public static boolean getIsCreatingClientWorld() {
        return isCreatingClientWorld;
    }

    public static void tick() {
        if (IPCGlobal.isClientRemoteTickingEnabled) {
            isClientRemoteTicking = true;
            clientWorldMap.values().forEach(world -> {
                if (ClientWorldLoader.client.field_1687 != world) {
                    ClientWorldLoader.tickRemoteWorld(world);
                }
            });
            worldRendererMap.values().forEach(worldRenderer -> {
                if (worldRenderer != ClientWorldLoader.client.field_1769) {
                    worldRenderer.method_3252();
                }
            });
            isClientRemoteTicking = false;
        }
        boolean lightmapTextureConflict = false;
        for (DimensionRenderHelper helper : renderHelperMap.values()) {
            helper.tick();
            if (helper.world == ClientWorldLoader.client.field_1687 || helper.lightmapTexture != ClientWorldLoader.client.field_1773.method_22974()) continue;
            Helper.err((Object)String.format("Lightmap Texture Conflict %s %s", helper.world.method_27983(), ClientWorldLoader.client.field_1687.method_27983()));
            lightmapTextureConflict = true;
        }
        if (lightmapTextureConflict) {
            ClientWorldLoader.disposeRenderHelpers();
            Helper.log((Object)"Refreshed Lightmaps");
        }
    }

    public static void disposeRenderHelpers() {
        renderHelperMap.values().forEach(DimensionRenderHelper::cleanUp);
        renderHelperMap.clear();
    }

    private static void tickRemoteWorld(class_638 newWorld) {
        List nearbyPortals = CHelper.getClientNearbyPortals(10.0).collect(Collectors.toList());
        ClientWorldLoader.withSwitchedWorld(newWorld, () -> {
            try {
                newWorld.method_18116();
                newWorld.method_8441(() -> true);
                if (!client.method_1493()) {
                    ClientWorldLoader.tickRemoteWorldRandomTicksClient(newWorld, nearbyPortals);
                }
                newWorld.method_38534();
            }
            catch (Throwable e) {
                limitedLogger.invoke(e::printStackTrace);
            }
        });
    }

    private static void tickRemoteWorldRandomTicksClient(class_638 newWorld, List<Portal> nearbyPortals) {
        nearbyPortals.stream().filter(portal -> portal.dimensionTo == newWorld.method_27983()).findFirst().ifPresent(portal -> {
            class_243 playerPos = ClientWorldLoader.client.field_1724.method_19538();
            class_243 center = portal.transformPoint(playerPos);
            class_4184 camera = ClientWorldLoader.client.field_1773.method_19418();
            class_243 oldCameraPos = camera.method_19326();
            ((IECamera)camera).portal_setPos(center);
            if (newWorld.method_8510() % 2L == 0L) {
                newWorld.method_2941((int)center.field_1352, (int)center.field_1351, (int)center.field_1350);
            }
            ClientWorldLoader.client.field_1713.method_3057();
            ((IECamera)camera).portal_setPos(oldCameraPos);
        });
    }

    private static void cleanUp() {
        worldRendererMap.values().forEach(ClientWorldLoader::disposeWorldRenderer);
        for (class_638 clientWorld : clientWorldMap.values()) {
            ((IEClientWorld)clientWorld).resetWorldRendererRef();
        }
        clientWorldMap.clear();
        worldRendererMap.clear();
        ClientWorldLoader.disposeRenderHelpers();
        isInitialized = false;
    }

    private static void disposeWorldRenderer(class_761 worldRenderer) {
        worldRenderer.method_3244(null);
        if (worldRenderer != ClientWorldLoader.client.field_1769) {
            worldRenderer.close();
            ((IEWorldRenderer)worldRenderer).portal_fullyDispose();
        }
    }

    private static void disposeDimensionDynamically(class_5321<class_1937> dimension) {
        Validate.isTrue((ClientWorldLoader.client.field_1687.method_27983() != dimension ? 1 : 0) != 0);
        Validate.isTrue((ClientWorldLoader.client.field_1724.method_37908().method_27983() != dimension ? 1 : 0) != 0);
        Validate.isTrue((boolean)client.method_18854());
        class_761 worldRenderer = worldRendererMap.get(dimension);
        ClientWorldLoader.disposeWorldRenderer(worldRenderer);
        worldRendererMap.remove(dimension);
        Validate.isTrue((ClientWorldLoader.client.field_1769 != worldRenderer ? 1 : 0) != 0);
        class_638 clientWorld = clientWorldMap.get(dimension);
        ((IEClientWorld)clientWorld).resetWorldRendererRef();
        clientWorldMap.remove(dimension);
        DimensionRenderHelper renderHelper = renderHelperMap.remove(dimension);
        if (renderHelper != null) {
            renderHelper.cleanUp();
        }
        Helper.log((Object)("Client Dynamically Removed Dimension " + dimension.method_29177()));
        if (clientWorld.method_2935().method_14151() > 0) {
            Helper.err((Object)"The chunks of that dimension was not cleared before removal");
        }
        if (clientWorld.method_18120() > 0) {
            Helper.err((Object)"The entities of that dimension was not cleared before removal");
        }
        ClientWorldLoader.client.field_1773.method_3203();
        clientDimensionDynamicRemoveSignal.emit(dimension);
    }

    @NotNull
    public static class_761 getWorldRenderer(class_5321<class_1937> dimension) {
        ClientWorldLoader.initializeIfNeeded();
        class_761 result = worldRendererMap.get(dimension);
        if (result == null) {
            LOGGER.warn("Acquiring LevelRenderer before acquiring Level. Something is probably wrong. {}", (Object)dimension.method_29177(), (Object)new Throwable());
            ClientWorldLoader.getWorld(dimension);
            result = worldRendererMap.get(dimension);
            if (result == null) {
                throw new RuntimeException("Unable to get LevelRenderer of " + dimension.method_29177());
            }
        }
        return result;
    }

    @NotNull
    public static class_638 getWorld(class_5321<class_1937> dimension) {
        Validate.notNull(dimension);
        Validate.isTrue((boolean)client.method_18854());
        ClientWorldLoader.initializeIfNeeded();
        if (!clientWorldMap.containsKey(dimension)) {
            return ClientWorldLoader.createSecondaryClientWorld(dimension);
        }
        class_638 result = clientWorldMap.get(dimension);
        Validate.notNull((Object)result);
        return result;
    }

    @Nullable
    public static class_638 getOptionalWorld(class_5321<class_1937> dimension) {
        Validate.notNull(dimension);
        Validate.isTrue((boolean)client.method_18854());
        if (ClientWorldLoader.getServerDimensions().contains(dimension)) {
            return ClientWorldLoader.getWorld(dimension);
        }
        return null;
    }

    public static DimensionRenderHelper getDimensionRenderHelper(class_5321<class_1937> dimension) {
        ClientWorldLoader.initializeIfNeeded();
        DimensionRenderHelper result = renderHelperMap.computeIfAbsent(dimension, dimensionType -> new DimensionRenderHelper((class_1937)ClientWorldLoader.getWorld(dimension)));
        Validate.isTrue((result.world.method_27983() == dimension ? 1 : 0) != 0);
        return result;
    }

    public static void initializeIfNeeded() {
        if (!isInitialized) {
            Validate.isTrue((ClientWorldLoader.client.field_1687 != null ? 1 : 0) != 0, (String)"level is null", (Object[])new Object[0]);
            Validate.isTrue((ClientWorldLoader.client.field_1769 != null ? 1 : 0) != 0, (String)"levelRenderer is null", (Object[])new Object[0]);
            Validate.notNull((Object)ClientWorldLoader.client.field_1724, (String)"player is null. This may be caused by prior initialization failure. The log may provide useful information.", (Object[])new Object[0]);
            Validate.isTrue((ClientWorldLoader.client.field_1724.method_37908() == ClientWorldLoader.client.field_1687 ? 1 : 0) != 0, (String)"The player level is not the same as client level", (Object[])new Object[0]);
            class_5321 playerDimension = ClientWorldLoader.client.field_1687.method_27983();
            clientWorldMap.put((class_5321<class_1937>)playerDimension, ClientWorldLoader.client.field_1687);
            worldRendererMap.put((class_5321<class_1937>)playerDimension, ClientWorldLoader.client.field_1769);
            renderHelperMap.put((class_5321<class_1937>)ClientWorldLoader.client.field_1687.method_27983(), new DimensionRenderHelper((class_1937)ClientWorldLoader.client.field_1687));
            isInitialized = true;
        }
    }

    private static class_638 createSecondaryClientWorld(class_5321<class_1937> dimension) {
        class_638 newWorld;
        Validate.notNull((Object)ClientWorldLoader.client.field_1724);
        Validate.isTrue((boolean)client.method_18854());
        Set<class_5321<class_1937>> dimIds = ClientWorldLoader.getServerDimensions();
        if (!dimIds.contains(dimension)) {
            throw new RuntimeException("Cannot create invalid client dimension " + dimension.method_29177());
        }
        isCreatingClientWorld = true;
        client.method_16011().method_15396("create_world");
        int chunkLoadDistance = 3;
        class_761 worldRenderer = new class_761(client, client.method_1561(), client.method_31975(), client.method_22940());
        try {
            class_634 mainNetHandler = ClientWorldLoader.client.field_1724.field_3944;
            Map<String, class_22> mapData = ((IEClientLevel_Accessor)ClientWorldLoader.client.field_1687).ip_getMapData();
            class_5321 dimensionTypeKey = DimensionTypeSync.getDimensionTypeKey(dimension);
            class_638.class_5271 currentProperty = (class_638.class_5271)((IEWorld)ClientWorldLoader.client.field_1687).myGetProperties();
            class_5455 registryManager = mainNetHandler.method_29091();
            int simulationDistance = ClientWorldLoader.client.field_1687.method_39024();
            class_6880.class_6883 dimensionType = registryManager.method_30530(class_7924.field_41241).method_40290(dimensionTypeKey);
            class_638.class_5271 properties = new class_638.class_5271(currentProperty.method_207(), currentProperty.method_152(), isFlatWorld);
            newWorld = new class_638(mainNetHandler, properties, dimension, (class_6880)dimensionType, chunkLoadDistance, simulationDistance, () -> ((class_310)client).method_16011(), worldRenderer, ClientWorldLoader.client.field_1687.method_27982(), ClientWorldLoader.client.field_1687.method_22385().field_20641);
            ((IEClientLevel_Accessor)newWorld).ip_setMapData(mapData);
        }
        catch (Exception e) {
            throw new IllegalStateException("Creating Client World " + dimension + " " + clientWorldMap.keySet(), e);
        }
        worldRenderer.method_3244(newWorld);
        worldRenderer.method_14491(client.method_1478());
        clientWorldMap.put(dimension, newWorld);
        worldRendererMap.put(dimension, worldRenderer);
        Helper.log((Object)("Client World Created " + dimension.method_29177()));
        isCreatingClientWorld = false;
        clientWorldLoadSignal.emit((Object)newWorld);
        client.method_16011().method_15407();
        return newWorld;
    }

    public static Set<class_5321<class_1937>> getServerDimensions() {
        return ClientWorldLoader.client.field_1724.field_3944.method_29356();
    }

    public static Collection<class_638> getClientWorlds() {
        Validate.isTrue((boolean)isInitialized);
        return clientWorldMap.values();
    }

    public static void _onWorldRendererReloaded() {
        Validate.isTrue((boolean)client.method_18854());
        if (ClientWorldLoader.client.field_1687 != null) {
            Helper.log((Object)("WorldRenderer reloaded " + ClientWorldLoader.client.field_1687.method_27983().method_29177()));
        }
        if (isReloadingOtherWorldRenderers) {
            return;
        }
        if (PortalRendering.isRendering()) {
            return;
        }
        if (ClientWorldLoader.getIsCreatingClientWorld()) {
            return;
        }
        isReloadingOtherWorldRenderers = true;
        List toReload = worldRendererMap.keySet().stream().filter(d -> d != ClientWorldLoader.client.field_1687.method_27983()).collect(Collectors.toList());
        for (class_5321 dim : toReload) {
            class_638 world = clientWorldMap.get(dim);
            Validate.notNull((Object)world);
            ClientWorldLoader.withSwitchedWorld(world, () -> ClientWorldLoader.client.field_1769.method_3279());
        }
        isReloadingOtherWorldRenderers = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withSwitchedWorld(class_638 newWorld, Supplier<T> supplier) {
        Validate.isTrue((boolean)client.method_18854());
        Validate.isTrue((ClientWorldLoader.client.field_1724 != null ? 1 : 0) != 0);
        class_634 networkHandler = client.method_1562();
        class_638 originalWorld = ClientWorldLoader.client.field_1687;
        class_761 originalWorldRenderer = ClientWorldLoader.client.field_1769;
        class_638 originalNetHandlerWorld = networkHandler.method_2890();
        boolean originalIsWorldSwitched = isWorldSwitched;
        class_761 newWorldRenderer = ClientWorldLoader.getWorldRenderer((class_5321<class_1937>)newWorld.method_27983());
        Validate.notNull((Object)newWorldRenderer);
        ClientWorldLoader.client.field_1687 = newWorld;
        ((IEParticleManager)ClientWorldLoader.client.field_1713).ip_setWorld(newWorld);
        ((IEMinecraftClient)client).setWorldRenderer(newWorldRenderer);
        ((IEClientPlayNetworkHandler)networkHandler).ip_setWorld(newWorld);
        isWorldSwitched = true;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            if (ClientWorldLoader.client.field_1687 != newWorld) {
                Helper.err((Object)"Respawn packet should not be redirected");
                originalWorld = ClientWorldLoader.client.field_1687;
                originalWorldRenderer = ClientWorldLoader.client.field_1769;
            }
            ClientWorldLoader.client.field_1687 = originalWorld;
            ((IEMinecraftClient)client).setWorldRenderer(originalWorldRenderer);
            ((IEParticleManager)ClientWorldLoader.client.field_1713).ip_setWorld(originalWorld);
            ((IEClientPlayNetworkHandler)networkHandler).ip_setWorld(originalNetHandlerWorld);
            isWorldSwitched = originalIsWorldSwitched;
        }
    }

    public static void withSwitchedWorld(class_638 newWorld, Runnable runnable) {
        ClientWorldLoader.withSwitchedWorld(newWorld, () -> {
            runnable.run();
            return null;
        });
    }

    public static void withSwitchedWorldFailSoft(class_5321<class_1937> dim, Runnable runnable) {
        class_638 world = ClientWorldLoader.getOptionalWorld(dim);
        if (world == null) {
            Helper.err((Object)"Ignoring redirected task of invalid dimension %s".formatted(dim.method_29177()));
            return;
        }
        ClientWorldLoader.withSwitchedWorld(world, runnable);
    }

    public static boolean getIsWorldSwitched() {
        return isWorldSwitched;
    }

    public static class RemoteCallables {
        public static void checkBiomeRegistry(Map<String, Integer> idMap) {
            class_5455 registryAccess = class_310.method_1551().field_1724.field_3944.method_29091();
            class_2378 biomes = registryAccess.method_30530(class_7924.field_41236);
            for (Map.Entry<String, Integer> entry : idMap.entrySet()) {
                class_2960 id = new class_2960(entry.getKey());
                int expectedId = entry.getValue();
                if (biomes.method_10206((Object)((class_1959)biomes.method_10223(id))) == expectedId) continue;
                LOGGER.error("Biome id mismatch: " + id + " " + expectedId);
            }
            if (idMap.size() != biomes.method_10235().size()) {
                LOGGER.error("Biome id mismatch: size not equal");
            }
            LOGGER.info("Biome id check finished");
        }
    }
}

