/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core;

import com.mojang.logging.LogUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_640;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.ducks.IEClientWorld;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.StableClientTimer;
import qouteall.q_misc_util.Helper;

@Environment(value=EnvType.CLIENT)
public class CHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static int reportedErrorNum = 0;

    public static class_640 getClientPlayerListEntry() {
        return class_310.method_1551().method_1562().method_2871(class_310.method_1551().field_1724.method_7334().getId());
    }

    public static class_1937 getClientWorld(class_5321<class_1937> dimension) {
        return ClientWorldLoader.getWorld(dimension);
    }

    @Nullable
    public static List<Portal> getClientGlobalPortal(class_1937 world) {
        if (world instanceof class_638) {
            return ((IEClientWorld)world).getGlobalPortals();
        }
        return null;
    }

    public static Stream<Portal> getClientNearbyPortals(double range) {
        return IPMcHelper.getNearbyPortals((class_1297)class_310.method_1551().field_1724, range);
    }

    public static void checkGlError() {
        if (!IPGlobal.doCheckGlError) {
            return;
        }
        if (reportedErrorNum > 100) {
            return;
        }
        CHelper.doCheckGlError();
    }

    public static void doCheckGlError() {
        int errorCode = GL11.glGetError();
        if (errorCode != 0) {
            Helper.err((Object)("OpenGL Error" + errorCode));
            new Throwable().printStackTrace();
            ++reportedErrorNum;
        }
    }

    public static void printChat(String str) {
        Helper.log((Object)str);
        CHelper.printChat((class_2561)class_2561.method_43470((String)str));
    }

    public static void printChat(class_2561 text) {
        class_310.method_1551().field_1705.method_1743().method_1812(text);
    }

    public static void openLinkConfirmScreen(class_437 parent, String link) {
        class_310 client = class_310.method_1551();
        client.method_1507((class_437)new class_407(result -> {
            if (result) {
                try {
                    class_156.method_668().method_673(new URI(link));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            client.method_1507(parent);
        }, link, true));
    }

    public static class_243 getCurrentCameraPos() {
        return class_310.method_1551().field_1773.method_19418().method_19326();
    }

    public static Iterable<class_1297> getWorldEntityList(class_1937 world) {
        if (!(world instanceof class_638)) {
            return (Iterable)((Object)Collections.emptyList().iterator());
        }
        class_638 clientWorld = (class_638)world;
        return clientWorld.method_18112();
    }

    public static double getSmoothCycles(long unitTicks) {
        return (double)((float)(StableClientTimer.getStableTickTime() % unitTicks) + StableClientTimer.getStablePartialTicks()) / (double)unitTicks;
    }

    public static void disableDepthClamp() {
        if (IPGlobal.enableClippingMechanism) {
            GL11.glDisable((int)34383);
        }
    }

    public static void enableDepthClamp() {
        if (IPGlobal.enableClippingMechanism) {
            GL11.glEnable((int)34383);
        }
    }

    @Nullable
    public static class_2960 getDimensionIconPath(class_5321<class_1937> dimension) {
        class_2960 dimensionId = dimension.method_29177();
        class_2960 dimIconPath = new class_2960(dimensionId.method_12836(), "textures/dimension/" + dimensionId.method_12832() + ".png");
        Optional resource = class_310.method_1551().method_1478().method_14486(dimIconPath);
        if (resource.isEmpty()) {
            LOGGER.info("Cannot load texture {}", (Object)dimIconPath);
            class_2960 modIconLocation = O_O.getModIconLocation(dimensionId.method_12836());
            if (modIconLocation == null) {
                return null;
            }
            class_2960 modIconPath = new class_2960(modIconLocation.method_12836(), modIconLocation.method_12832());
            Optional modIconResource = class_310.method_1551().method_1478().method_14486(modIconPath);
            if (modIconResource.isEmpty()) {
                LOGGER.info("Cannot load texture {}", (Object)modIconPath);
                return null;
            }
            return modIconPath;
        }
        return dimIconPath;
    }
}

