/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.utils;

import com.tterrag.registrate.providers.RegistrateLangProvider;
import dev.xkmc.l2library.util.math.MathHelper;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUtils {
    public static final int MAX_USE_TIME = 72000;

    public static int getEnchSize(ItemStack stack) {
        return EnchantmentHelper.m_44831_((ItemStack)stack).size();
    }

    public static int getCurseEnchSize(ItemStack stack) {
        int totalCurses = 0;
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        for (Enchantment enchantment : enchantments.keySet()) {
            if (!enchantment.m_6589_() || (Integer)enchantments.get(enchantment) <= 0) continue;
            ++totalCurses;
        }
        return totalCurses;
    }

    public static int getAllSlotCurseEnchSize(Player player) {
        int total = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            int curseEnch = ItemUtils.getCurseEnchSize(player.m_6844_(slot));
            total += curseEnch;
        }
        return total;
    }

    public static int getTotalEnchLevelOfArmors(Player player) {
        int level = 0;
        for (ItemStack stack : player.m_6168_()) {
            if (stack.m_41793_()) continue;
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
            for (Map.Entry entry : enchantments.entrySet()) {
                level += ((Integer)entry.getValue()).intValue();
            }
        }
        return level;
    }

    public static boolean hasInHand(Player player, ItemStack stack) {
        int n = 0;
        InteractionHand[] interactionHandArray = InteractionHand.values();
        int n2 = interactionHandArray.length;
        if (n < n2) {
            InteractionHand hand = interactionHandArray[n];
            return player.m_21120_(hand).equals(stack);
        }
        return false;
    }

    public static String getPathAfterSlash(String path) {
        int index = path.lastIndexOf("/");
        if (index != -1 && index < path.length() - 1) {
            return path.substring(index + 1);
        }
        return path;
    }

    public static void defaultAnvilOutput(AnvilUpdateEvent event, ItemStack output) {
        ItemUtils.defaultAnvilOutput(event, output, 10);
    }

    public static void defaultAnvilOutput(AnvilUpdateEvent event, ItemStack output, int expCost) {
        event.setMaterialCost(1);
        event.setCost(expCost);
        event.setOutput(output);
    }

    public static int calculateRef(RandomSource random, int origin, double chance) {
        return ItemUtils.calculateRef(origin, random.m_188500_() < chance, 1);
    }

    public static int calculateRef(int origin, boolean canReduce, int toAdd) {
        int newInt = 0;
        for (int i = 0; i < origin; ++i) {
            if (!canReduce) continue;
            newInt += toAdd;
        }
        return newInt;
    }

    public static void toShrink(ItemStack stack, Player player) {
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
    }

    @Nullable
    public static ResourceLocation getKey(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static List<ItemStack> getDefaultLootStacks(ResourceLocation lootTable, ServerPlayer player) {
        LootParams lootParams = new LootParams.Builder(player.m_284548_()).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287239_(player.m_36336_()).m_287235_(LootContextParamSets.f_81416_);
        return ItemUtils.getLootStacks(lootTable, player, lootParams);
    }

    public static List<ItemStack> getLootStacks(ResourceLocation lootTable, ServerPlayer player, LootParams lootParams) {
        MinecraftServer server = player.m_9236_().m_7654_();
        if (server == null || lootTable.equals((Object)BuiltInLootTables.f_78712_)) {
            return List.of();
        }
        return server.m_278653_().m_278676_(lootTable).m_287195_(lootParams);
    }

    public static void repairStack(ItemStack stack) {
        ItemUtils.repairStack(stack, 1);
    }

    public static void repairStack(ItemStack stack, int value) {
        if (stack.m_41768_()) {
            stack.m_41721_(stack.m_41773_() - value);
        }
    }

    public static int getDurability(ItemStack stack) {
        return stack.m_41776_() - stack.m_41773_();
    }

    public static void directDamage(ItemStack stack, int value) {
        int toDamage = stack.m_41773_() + value;
        if (stack.m_41776_() > toDamage) {
            stack.m_41721_(toDamage);
        } else {
            stack.m_41774_(1);
        }
    }

    public static AttributeModifier.Operation getOperation(int id) {
        return AttributeModifier.Operation.m_22236_((int)id);
    }

    public static AttributeModifier addMod(String name, double amount, AttributeModifier.Operation operation) {
        return new AttributeModifier(MathHelper.getUUIDFromString((String)name), name, amount, operation);
    }

    public static AttributeModifier addMod(String name, double amount, int operation) {
        return ItemUtils.addMod(name, amount, ItemUtils.getOperation(operation));
    }

    public static MutableComponent getUSNameInfo(String info) {
        return Component.m_237113_((String)RegistrateLangProvider.toEnglishName((String)info));
    }

    @Deprecated
    public static Component addTranslatable(String info, @Nullable ChatFormatting color) {
        MutableComponent tip = Component.m_237115_((String)info);
        if (color != null) {
            return tip.m_130940_(color);
        }
        return tip;
    }

    @Deprecated
    public static Component addTranslatable(String info, @Nullable ChatFormatting color, Object ... objects) {
        MutableComponent tip = Component.m_237110_((String)info, (Object[])objects);
        if (color != null) {
            return tip.m_130940_(color);
        }
        return tip;
    }

    @Deprecated(forRemoval=true)
    public static class ItemTag {
        public static boolean tagCheck(ItemStack stack) {
            return !stack.m_41619_() && stack.m_41783_() != null;
        }

        public static void removeTag(ItemStack stack, String tag) {
            if (ItemTag.tagCheck(stack)) {
                stack.m_41783_().m_128473_(tag);
            }
        }

        public static boolean getBoolean(ItemStack stack, String tag) {
            return ItemTag.tagCheck(stack) && stack.m_41783_().m_128471_(tag);
        }

        public static boolean isBoolean(ItemStack stack, String tag, boolean value) {
            return ItemTag.tagCheck(stack) && stack.m_41783_().m_128471_(tag) == value;
        }

        public static void setBoolean(ItemStack stack, String tag, boolean value) {
            stack.m_41784_().m_128379_(tag, value);
        }

        public static int getInt(ItemStack stack, String tag) {
            return ItemTag.tagCheck(stack) ? stack.m_41783_().m_128451_(tag) : 0;
        }

        public static int getInt(ItemStack stack, String tag, int def) {
            return ItemTag.tagCheck(stack) ? stack.m_41783_().m_128451_(tag) : def;
        }

        public static void setInt(ItemStack stack, String tag, int value) {
            stack.m_41784_().m_128405_(tag, value);
        }

        public static float getFloat(ItemStack stack, String tag) {
            return ItemTag.tagCheck(stack) ? stack.m_41783_().m_128457_(tag) : 0.0f;
        }

        public static float getFloat(ItemStack stack, String tag, float def) {
            return ItemTag.tagCheck(stack) ? stack.m_41783_().m_128457_(tag) : def;
        }

        public static void setFloat(ItemStack stack, String tag, float value) {
            stack.m_41784_().m_128350_(tag, value);
        }

        public static double getDouble(ItemStack stack, String tag) {
            return ItemTag.tagCheck(stack) ? stack.m_41783_().m_128459_(tag) : 0.0;
        }

        public static double getDouble(ItemStack stack, String tag, double def) {
            return ItemTag.tagCheck(stack) ? stack.m_41783_().m_128459_(tag) : def;
        }

        public static void setDouble(ItemStack stack, String tag, double value) {
            stack.m_41784_().m_128347_(tag, value);
        }

        public static String getString(ItemStack stack, String tag) {
            return stack.m_41784_().m_128461_(tag);
        }

        public static boolean hasStringTag(ItemStack stack, String tag, String value) {
            return stack.m_41784_().m_128461_(tag).equals(value);
        }

        public static void setString(ItemStack stack, String tag, String value) {
            stack.m_41784_().m_128359_(tag, value);
        }

        public static CompoundTag getCompound(ItemStack stack, String tag) {
            return stack.m_41784_().m_128469_(tag);
        }

        public static void setCompound(ItemStack stack, String tag, CompoundTag value) {
            stack.m_41784_().m_128365_(tag, (Tag)value);
        }

        public static ListTag getListTag(ItemStack stack, String tag, int type) {
            return stack.m_41784_().m_128437_(tag, type);
        }
    }
}

