/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class DelayUtils {
    private static final Map<ResourceLocation, DelayUtils> MAP = new HashMap<ResourceLocation, DelayUtils>();
    public int runTick = 0;
    public int runCount = 0;
    public int needRunTick;
    public int needRunCount;
    public final Runnable action;
    public boolean isEnd;

    public DelayUtils(int singleRunTick, Runnable action) {
        this.needRunTick = singleRunTick;
        this.needRunCount = 1;
        this.action = action;
    }

    public DelayUtils(int needRunTick, int needRunCount, Runnable action) {
        this.needRunTick = needRunTick;
        this.needRunCount = needRunCount;
        this.action = action;
    }

    public static Optional<DelayUtils> getUtils(ResourceLocation id) {
        return Optional.ofNullable(MAP.get(id));
    }

    public static void serverTick() {
        if (MAP.isEmpty()) {
            return;
        }
        MAP.forEach((key, utils) -> {
            if (utils.runTick >= utils.needRunTick) {
                utils.action.run();
                ++utils.runCount;
                if (utils.runCount >= utils.needRunCount) {
                    utils.isEnd = true;
                } else {
                    utils.runTick = 0;
                    utils.isEnd = false;
                }
            } else {
                ++utils.runTick;
                utils.isEnd = false;
            }
        });
        MAP.entrySet().removeIf(entry -> ((DelayUtils)entry.getValue()).isEnd);
    }

    public static void schedule(ResourceLocation id, int needRunTick, Runnable action) {
        DelayUtils utils = new DelayUtils(needRunTick, action);
        MAP.put(id, utils);
    }

    public static void schedule(ResourceLocation id, int needRunTick, int needRunCount, Runnable action) {
        DelayUtils utils = new DelayUtils(needRunTick, needRunCount, action);
        MAP.put(id, utils);
    }
}

