/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.utils;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class CCUtils {
    public static final UUID BYPASS_ARMOR_UUID = UUID.fromString("CB3F55D3-2213-B01A-A497-9C23A33DB5CF");
    public static final UUID BYPASS_TOUGHNESS_UUID = UUID.fromString("CB3F55D3-2214-B024-A497-9C23A33DB5CF");

    public static Vec3 getCenterOf(Vec3i pos) {
        if (pos.equals((Object)Vec3i.f_123288_)) {
            return new Vec3(0.5, 0.5, 0.5);
        }
        return Vec3.m_82528_((Vec3i)pos).m_82520_(0.5, 0.5, 0.5);
    }

    public static float getMoonFactor(Level level) {
        int moonPhase = (int)(level.m_46468_() / 24000L % 8L);
        float moonPhaseFactor = moonPhase == 0 ? 1.0f : (moonPhase == 1 || moonPhase == 7 ? 0.75f : (moonPhase == 2 || moonPhase == 6 ? 0.5f : (moonPhase == 3 || moonPhase == 5 ? 0.25f : 0.0f)));
        return moonPhaseFactor;
    }

    public static boolean isFullMoon(Level level) {
        return CCUtils.getMoonFactor(level) == 1.0f;
    }

    public static void addFlySpeed(LivingEntity entity, float speed) {
        Vec3 look = entity.m_20154_();
        Vec3 motion = entity.m_20184_();
        entity.m_20256_(motion.m_82520_(look.f_82479_ * 0.1 + (look.f_82479_ * (double)speed - motion.f_82479_) * 0.5, look.f_82480_ * 0.1 + (look.f_82480_ * (double)speed - motion.f_82480_) * 0.5, look.f_82481_ * 0.1 + (look.f_82481_ * (double)speed - motion.f_82481_) * 0.5));
    }

    public static int getLight(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            return sl.m_46803_(pos);
        }
        return level.m_46849_(pos, CCUtils.getSkyDarken(level));
    }

    public static int getSkyDarken(Level level) {
        double d0 = 1.0f - level.m_46722_(1.0f) * 5.0f / 16.0f;
        double d1 = 1.0f - level.m_46661_(1.0f) * 5.0f / 16.0f;
        double d2 = 0.5 + 2.0 * Mth.m_14008_((double)Mth.m_14089_((float)(level.m_46942_(1.0f) * ((float)Math.PI * 2))), (double)-0.25, (double)0.25);
        return (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public static void attractItem(LivingEntity entity, AABB range, float speed) {
        CCUtils.attractEntity(entity, ItemEntity.class, range, speed);
    }

    public static <E extends Entity> void attractEntity(LivingEntity entity, Class<E> targets, AABB range, float speed) {
        List list = entity.m_9236_().m_45976_(targets, range);
        for (Entity target : list) {
            if (target.m_213877_()) continue;
            Vec3 sub = entity.m_20182_().m_82492_(target.m_20185_(), target.m_20186_(), target.m_20189_()).m_82541_().m_82490_((double)speed);
            if (target.m_20068_()) {
                sub = sub.m_82520_(0.0, (double)0.04f, 0.0);
            }
            target.m_20256_(sub);
        }
    }

    public static <E extends Event> E fireEvent(E event) {
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }
}

