/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.register;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.NoConfigBuilder;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.xiaoyue.celestial_core.CelestialCore;
import com.xiaoyue.celestial_core.content.effects.AttributeEffect;
import com.xiaoyue.celestial_core.content.effects.FearCurse;
import com.xiaoyue.celestial_core.content.effects.Hidden;
import com.xiaoyue.celestial_core.content.effects.ReinforcedBlade;
import com.xiaoyue.celestial_core.content.effects.RottenCurse;
import com.xiaoyue.celestial_core.content.effects.SoulShatter;
import com.xiaoyue.celestial_core.content.generic.CelestialEffect;
import com.xiaoyue.celestial_core.register.CCAttributes;
import com.xiaoyue.celestial_core.register.CCItems;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import dev.xkmc.l2library.base.L2Registrate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.registries.ForgeRegistries;

public class CCEffects {
    public static final List<RegistryEntry<? extends Potion>> POTION_LIST = new ArrayList<RegistryEntry<? extends Potion>>();
    private static final List<Runnable> TEMP = new ArrayList<Runnable>();
    public static final RegistryEntry<AttributeEffect> CRIT_RATE = CCEffects.genEffect("crit_rate", () -> new AttributeEffect(0, -3057888, (Attribute)L2DamageTracker.CRIT_RATE.get(), CelestialCore.loc("crit_rate"), (double)0.1f, 0), "Increase crit rate");
    public static final RegistryEntry<AttributeEffect> CRIT_DAMAGE = CCEffects.genEffect("crit_damage", () -> new AttributeEffect(0, -1988756, (Attribute)L2DamageTracker.CRIT_DMG.get(), CelestialCore.loc("crit_damage"), (double)0.1f, 0), "Increase crit damage");
    public static final RegistryEntry<AttributeEffect> ARROW_DAMAGE = CCEffects.genEffect("arrow_damage", () -> new AttributeEffect(0, -3045088, (Attribute)L2DamageTracker.BOW_STRENGTH.get(), CelestialCore.loc("arrow_damage"), (double)0.2f, 0), "Increase arrow damage");
    public static final RegistryEntry<AttributeEffect> REPLY_POWER = CCEffects.genEffect("regen_rate", () -> new AttributeEffect(0, -3071843, (Attribute)CCAttributes.REPLY_POWER.get(), CelestialCore.loc("regen_rate"), (double)0.2f, 0), "Increase regeneration rate");
    public static final RegistryEntry<CelestialEffect> VIOLENT = CCEffects.genEffect("violent", () -> new CelestialEffect(MobEffectCategory.NEUTRAL, -8119011), "Melee damage bypass armor");
    public static final RegistryEntry<CelestialEffect> SILENT = CCEffects.genEffect("silent", () -> new CelestialEffect(MobEffectCategory.NEUTRAL, -1), "You won't make a vibration");
    public static final RegistryEntry<CelestialEffect> UNYIELDING = CCEffects.genEffect("unyielding", () -> new CelestialEffect(MobEffectCategory.BENEFICIAL, -3173), "Stop you from dying");
    public static final RegistryEntry<Hidden> HIDDEN = CCEffects.genEffect("hidden", Hidden::new, "Cannot be seen as enemy. Removed on attack");
    public static final RegistryEntry<RottenCurse> ROTTEN_CURSE = CCEffects.genEffect("rotten_curse", RottenCurse::new, "Inflict damage after being attacked, prevents teleport");
    public static final RegistryEntry<ReinforcedBlade> BLADE_MODIFIER = CCEffects.genEffect("reinforced_blade", ReinforcedBlade::new, "Increase attack damage and crit rate");
    public static final RegistryEntry<SoulShatter> SOUL_SHATTER = CCEffects.genEffect("soul_shatter", SoulShatter::new, "Reduce max health and movement speed");
    public static final RegistryEntry<FearCurse> FEAR_CURSE = CCEffects.genEffect("fear_curse", FearCurse::new, "You will get hurt when you attack");

    private static <T extends MobEffect> RegistryEntry<T> genEffect(String name, NonNullSupplier<T> sup, String desc) {
        return ((NoConfigBuilder)CelestialCore.REGISTRATE.effect(name, sup, desc).lang(MobEffect::m_19481_)).register();
    }

    private static <T extends Potion> RegistryEntry<T> genPotion(String name, NonNullSupplier<T> sup) {
        L2Registrate reg = CelestialCore.REGISTRATE;
        RegistryEntry ans = ((NoConfigBuilder)reg.entry(name, cb -> new NoConfigBuilder((AbstractRegistrate)reg, (Object)reg, name, cb, ForgeRegistries.Keys.POTIONS, sup))).register();
        POTION_LIST.add((RegistryEntry<? extends Potion>)ans);
        return ans;
    }

    public static void registerBrewingRecipe() {
        TEMP.forEach(Runnable::run);
    }

    private static void initGradesPotion(String id, Supplier<MobEffect> sup, Supplier<Item> item, int dur, int durLong) {
        RegistryEntry potion = CCEffects.genPotion(id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), dur)}));
        RegistryEntry longPotion = CCEffects.genPotion("long_" + id, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)sup.get(), durLong)}));
        TEMP.add(() -> {
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)item.get()), (Potion)((Potion)potion.get()));
            PotionBrewing.m_43513_((Potion)((Potion)potion.get()), (Item)Items.f_42451_, (Potion)((Potion)longPotion.get()));
        });
    }

    public static void register() {
    }

    static {
        CCEffects.initGradesPotion("crit_rate", () -> CRIT_RATE.get(), () -> CCItems.OCEAN_ESSENCE.get(), 6000, 9600);
        CCEffects.initGradesPotion("crit_damage", () -> CRIT_DAMAGE.get(), () -> CCItems.FIRE_ESSENCE.get(), 6000, 9600);
        CCEffects.initGradesPotion("regen_rate", () -> REPLY_POWER.get(), () -> CCItems.HEART_FRAGMENT.get(), 6000, 9600);
        CCEffects.initGradesPotion("arrow_damage", () -> ARROW_DAMAGE.get(), () -> CCItems.LIGHT_FRAGMENT.get(), 6000, 9600);
    }
}

