/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.events;

import com.xiaoyue.celestial_core.register.CCAttributes;
import com.xiaoyue.celestial_core.register.CCEffects;
import com.xiaoyue.celestial_core.utils.CCUtils;
import com.xiaoyue.celestial_core.utils.EntityUtils;
import com.xiaoyue.celestial_core.utils.ItemUtils;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.damage.DamageState;
import dev.xkmc.l2damagetracker.contents.damage.DefaultDamageState;
import java.util.Optional;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;

public class CCAttackListener
implements AttackListener {
    private Optional<AttributeInstance> getAttr(LivingEntity entity, Attribute attr) {
        return Optional.ofNullable(entity.m_21051_(attr));
    }

    public void onCreateSource(CreateSourceEvent event) {
        if (event.getResult() != null && event.getResult().toRoot().validState((DamageState)DefaultDamageState.BYPASS_ARMOR) && event.getAttacker().m_21023_((MobEffect)CCEffects.VIOLENT.get())) {
            event.enable((DamageState)DefaultDamageState.BYPASS_ARMOR);
        }
    }

    public void onAttack(AttackCache cache, ItemStack weapon) {
        LivingEntity target = cache.getAttackTarget();
        LivingEntity attacker = cache.getAttacker();
        if (attacker == null) {
            return;
        }
        this.getAttr(target, Attributes.f_22284_).ifPresent(ins -> {
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                double ap = player.m_21133_((Attribute)CCAttributes.ARMOR_PENETRATION.get());
                ins.m_22120_(CCUtils.BYPASS_ARMOR_UUID);
                AttributeModifier modifier = new AttributeModifier(CCUtils.BYPASS_ARMOR_UUID, "celestial_bypass_armor", -ap, ItemUtils.getOperation(2));
                ins.m_22118_(modifier);
            }
        });
        this.getAttr(target, Attributes.f_22285_).ifPresent(ins -> {
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                double tp = player.m_21133_((Attribute)CCAttributes.TOUGHNESS_PENETRATION.get());
                ins.m_22120_(CCUtils.BYPASS_TOUGHNESS_UUID);
                AttributeModifier modifier = new AttributeModifier(CCUtils.BYPASS_TOUGHNESS_UUID, "celestial_bypass_toughness", -tp, ItemUtils.getOperation(2));
                ins.m_22118_(modifier);
            }
        });
    }

    public void onHurtMaximized(AttackCache cache, ItemStack weapon) {
        LivingEntity attacker = cache.getAttacker();
        if (attacker != null && attacker.m_21023_((MobEffect)CCEffects.FEAR_CURSE.get())) {
            int level = EntityUtils.getEffectLevel(attacker, (MobEffect)CCEffects.FEAR_CURSE.get());
            EntityUtils.hurtByPlayerOrMob(attacker, attacker.m_21188_(), (float)level * cache.getPreDamage() * 0.2f);
        }
    }

    public void onDamageFinalized(AttackCache cache, ItemStack weapon) {
        LivingEntity attacker;
        LivingDamageEvent event = cache.getLivingDamageEvent();
        assert (event != null);
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)CCEffects.UNYIELDING.get()) && event.getAmount() >= entity.m_21223_()) {
            event.setCanceled(true);
        }
        if ((attacker = cache.getAttacker()) != null && attacker.m_21023_((MobEffect)CCEffects.HIDDEN.get())) {
            attacker.m_21195_((MobEffect)CCEffects.HIDDEN.get());
        }
        this.getAttr(entity, Attributes.f_22284_).ifPresent(ins -> ins.m_22120_(CCUtils.BYPASS_ARMOR_UUID));
        this.getAttr(entity, Attributes.f_22285_).ifPresent(ins -> ins.m_22120_(CCUtils.BYPASS_TOUGHNESS_UUID));
    }
}

