/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.content.loot;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

public record IntConfigValue(String path, List<String> line) {
    public static IntConfigValue of(String file, ForgeConfigSpec.ConfigValue<Integer> config) {
        return new IntConfigValue(file, config.getPath());
    }

    public static IntConfigValue of(String data) {
        int last = data.lastIndexOf(47);
        String[] line = data.substring(last + 1).split("\\.");
        return new IntConfigValue(data.substring(0, last), List.of(line));
    }

    public int get() {
        Object object;
        ModConfig file = (ModConfig)ConfigTracker.INSTANCE.fileMap().get(this.path);
        if (file != null && (object = file.getConfigData().get(this.line())) instanceof Number) {
            Number val = (Number)object;
            return val.intValue();
        }
        return 0;
    }

    public String toData() {
        StringBuilder lines = new StringBuilder();
        for (String e : this.line) {
            if (!lines.isEmpty()) {
                lines.append(".");
            }
            lines.append(e);
        }
        return this.path + "/" + lines;
    }
}

