/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.content.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.xiaoyue.celestial_core.content.loot.DoubleConfigValue;
import com.xiaoyue.celestial_core.content.loot.IntConfigValue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishingCooldownModifier
extends LootModifier {
    public static final Codec<FishingCooldownModifier> CODEC = RecordCodecBuilder.create(inst -> FishingCooldownModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("condition").forGetter(m -> m.condition)).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("result").forGetter(m -> m.result)).and((App)Codec.STRING.optionalFieldOf("cooldown").forGetter(m -> Optional.ofNullable(m.cooldown).map(IntConfigValue::toData))).and((App)Codec.STRING.optionalFieldOf("chance").forGetter(m -> Optional.ofNullable(m.chance).map(DoubleConfigValue::toData))).apply((Applicative)inst, FishingCooldownModifier::new));
    private final Item condition;
    private final Item result;
    @Nullable
    private final IntConfigValue cooldown;
    @Nullable
    private final DoubleConfigValue chance;

    protected FishingCooldownModifier(LootItemCondition[] conditionsIn, Item condition, Item result, Optional<String> cooldown, Optional<String> chance) {
        super(conditionsIn);
        this.condition = condition;
        this.result = result;
        this.cooldown = cooldown.map(IntConfigValue::of).orElse(null);
        this.chance = chance.map(DoubleConfigValue::of).orElse(null);
    }

    public FishingCooldownModifier(Item condition, Item result, LootItemCondition ... conditionsIn) {
        super(conditionsIn);
        this.condition = condition;
        this.result = result;
        this.cooldown = null;
        this.chance = null;
    }

    public FishingCooldownModifier(Item condition, Item result, IntConfigValue cooldown, DoubleConfigValue chance, LootItemCondition ... conditionsIn) {
        super(conditionsIn);
        this.condition = condition;
        this.result = result;
        this.cooldown = cooldown;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        FishingHook hook;
        Player player;
        if (!context.m_78936_(LootContextParams.f_81455_)) {
            return generatedLoot;
        }
        Object object = context.m_165124_(LootContextParams.f_81455_);
        if (object instanceof FishingHook && (player = (hook = (FishingHook)object).m_37168_()) != null && !player.m_36335_().m_41519_(this.condition) && (this.chance == null || context.m_230907_().m_188500_() <= this.chance.get())) {
            int cooldownTime = this.cooldown == null ? 0 : this.cooldown.get();
            player.m_36335_().m_41524_(this.condition, cooldownTime);
            return ObjectArrayList.of((Object[])new ItemStack[]{new ItemStack((ItemLike)this.result)});
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

