/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.content.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.xiaoyue.celestial_core.content.loot.DoubleConfigValue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraDropModifier
extends LootModifier {
    public static final Codec<ExtraDropModifier> CODEC = RecordCodecBuilder.create(i -> ExtraDropModifier.codecStart((RecordCodecBuilder.Instance)i).and(i.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item), (App)Codec.STRING.optionalFieldOf("chance").forGetter(m -> Optional.ofNullable(m.chance).map(DoubleConfigValue::toData)))).apply((Applicative)i, ExtraDropModifier::new));
    public final Item item;
    @Nullable
    public final DoubleConfigValue chance;

    protected ExtraDropModifier(LootItemCondition[] conditionsIn, Item item, Optional<String> chance) {
        super(conditionsIn);
        this.item = item;
        this.chance = chance.map(DoubleConfigValue::of).orElse(null);
    }

    public ExtraDropModifier(Item item, @Nullable DoubleConfigValue chance, LootItemCondition ... conditionsIn) {
        super(conditionsIn);
        this.item = item;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!generatedLoot.isEmpty()) {
            return generatedLoot;
        }
        if (this.chance == null || context.m_230907_().m_188500_() <= this.chance.get()) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

