/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.content.client.render;

import com.xiaoyue.celestial_core.content.client.render.RenderContext;
import net.minecraft.client.gui.GuiGraphics;

public abstract class RenderElement {
    public static final RenderElement EMPTY = new RenderElement(){

        @Override
        public void render(GuiGraphics graphics) {
        }
    };
    protected int width = 16;
    protected int height = 16;
    protected float x = 0.0f;
    protected float y = 0.0f;
    protected float z = 0.0f;
    protected float alpha = 1.0f;

    public static RenderElement of(RenderContext context) {
        return new SimpleRenderElement(context);
    }

    public <T extends RenderElement> T at(float x, float y) {
        this.x = x;
        this.y = y;
        return (T)this;
    }

    public <T extends RenderElement> T at(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return (T)this;
    }

    public <T extends RenderElement> T withBounds(int width, int height) {
        this.width = width;
        this.height = height;
        return (T)this;
    }

    public <T extends RenderElement> T withAlpha(float alpha) {
        this.alpha = alpha;
        return (T)this;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public abstract void render(GuiGraphics var1);

    public void render(GuiGraphics graphics, int x, int y) {
        ((RenderElement)this.at(x, y)).render(graphics);
    }

    public static class SimpleRenderElement
    extends RenderElement {
        private final RenderContext context;

        public SimpleRenderElement(RenderContext context) {
            this.context = context;
        }

        @Override
        public void render(GuiGraphics graphics) {
            this.context.render(graphics, (int)this.x, (int)this.y);
        }
    }
}

