/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.compat;

import com.xiaoyue.celestial_core.CelestialCore;
import com.xiaoyue.celestial_core.compat.CCJeiPlugin;
import com.xiaoyue.celestial_core.content.client.render.GuiRenderHandler;
import com.xiaoyue.celestial_core.content.client.render.RenderElement;
import com.xiaoyue.celestial_core.content.recipes.TransformationRecipe;
import com.xiaoyue.celestial_core.data.CCLangData;
import com.xiaoyue.celestial_core.register.CCItems;
import dev.xkmc.l2library.serial.recipe.BaseRecipeCategory;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class TransformationRecipeCategory
extends BaseRecipeCategory<TransformationRecipe, TransformationRecipeCategory> {
    public IDrawable arrow;
    public IDrawable slotBackground;
    public IJeiHelpers jeiHelpers;

    public TransformationRecipeCategory() {
        super(CelestialCore.loc("special"), TransformationRecipe.class);
    }

    public TransformationRecipeCategory init(IJeiHelpers jeiHelpers) {
        this.jeiHelpers = jeiHelpers;
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        this.background = guiHelper.createBlankDrawable(166, 66);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)CCItems.EARTH_CORE.asStack());
        this.arrow = guiHelper.createDrawable(CCJeiPlugin.TEXTURE, 0, 17, 24, 17);
        this.slotBackground = guiHelper.createDrawable(CCJeiPlugin.TEXTURE, 0, 34, 18, 18);
        return this;
    }

    public Component getTitle() {
        return CCLangData.TRANSFORMATION_RECIPE_TITLE.get(new Object[0]);
    }

    private void renderInfo(GuiGraphics guiGraphics, List<Component> info, double mx, double my, double x, double y) {
        GuiRenderHandler.renderInfoFromMouse(guiGraphics, info, mx, my, x, y, 18.0, 18.0);
    }

    public void draw(TransformationRecipe recipe, IRecipeSlotsView view, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 61, 23);
        this.arrow.draw(guiGraphics, 112, 23);
        IModIdHelper modIdHelper = this.jeiHelpers.getModIdHelper();
        List<MutableComponent> inputInfo = List.of(recipe.stat.m_49954_(), Component.m_237113_((String)modIdHelper.getFormattedModNameForModId(ForgeRegistries.BLOCKS.getKey((Object)recipe.stat).m_135827_())));
        this.renderInfo(guiGraphics, inputInfo, mouseX, mouseY, 90.0, 22.0);
        if (recipe.stat.m_49966_().m_60819_().m_76178_()) {
            ((RenderElement)GuiRenderHandler.of((ItemLike)recipe.stat).rotateBlock(12.5, 202.5, 0.0).scale(12.0).lighting(GuiRenderHandler.BLOCK_LIGHTING).atLocal(0.1, 0.1, 0.0).at(90.0f, 22.0f)).render(guiGraphics);
        } else {
            ((RenderElement)GuiRenderHandler.of(recipe.stat.m_49966_().m_60819_().m_76152_()).rotateBlock(12.5, 202.5, 0.0).scale(12.0).lighting(GuiRenderHandler.BLOCK_LIGHTING).atLocal(0.1, 0.2, 0.0).at(90.0f, 22.0f)).render(guiGraphics);
        }
        if (recipe.after != null) {
            List<MutableComponent> afterInfo = List.of(recipe.after.m_49954_(), Component.m_237113_((String)modIdHelper.getFormattedModNameForModId(ForgeRegistries.BLOCKS.getKey((Object)recipe.after).m_135827_())));
            this.renderInfo(guiGraphics, afterInfo, mouseX, mouseY, 142.0, 31.0);
            if (recipe.after.m_49966_().m_60819_().m_76178_()) {
                ((RenderElement)GuiRenderHandler.of((ItemLike)recipe.after).rotateBlock(12.5, 202.5, 0.0).scale(12.0).lighting(GuiRenderHandler.BLOCK_LIGHTING).atLocal(0.1, 0.1, 0.0).at(141.0f, 33.0f)).render(guiGraphics);
            } else {
                ((RenderElement)GuiRenderHandler.of(recipe.after.m_49966_().m_60819_().m_76152_()).rotateBlock(12.5, 202.5, 0.0).scale(12.0).lighting(GuiRenderHandler.BLOCK_LIGHTING).atLocal(0.1, 0.2, 0.0).at(141.0f, 31.0f)).render(guiGraphics);
            }
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TransformationRecipe recipe, IFocusGroup group) {
        int y = 5;
        int x = 5;
        for (int i = 0; i < 9; ++i) {
            if (recipe.inputs.size() > i) {
                builder.addSlot(RecipeIngredientRole.INPUT, x + 1, y + 1).setSlotName("input" + i).addIngredients(recipe.inputs.get(i));
            }
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, x + 1, y + 1).setSlotName("background" + i).setBackground(this.slotBackground, -1, -1);
            if ((y += 18) < 54) continue;
            y -= 54;
            x += 18;
        }
        boolean hasAfter = recipe.after != null;
        builder.addSlot(RecipeIngredientRole.OUTPUT, 142, hasAfter ? 14 : 25).setSlotName("output").setBackground(this.slotBackground, -1, -1).addItemStack(recipe.output);
        builder.addSlot(RecipeIngredientRole.CATALYST, 92, 24).setBackground(this.slotBackground, -1, -1);
        if (!hasAfter) {
            return;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 142, 34).setBackground(this.slotBackground, -1, -1);
    }
}

