/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.csg.commands;

import com.brandon3055.csg.DataManager;
import com.brandon3055.csg.lib.PlayerSlot;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CSGCommand {
    private static Logger LOGGER = LogManager.getLogger();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"csg_config").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"set").executes(CSGCommand::set))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"give").executes(context -> CSGCommand.give((CommandContext<CommandSourceStack>)context, (Player)((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(context -> CSGCommand.give((CommandContext<CommandSourceStack>)context, (Player)EntityArgument.m_91474_((CommandContext)context, (String)"target")))))).then(Commands.m_82127_((String)"item_deletion_blacklist").then(Commands.m_82129_((String)"target", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            ArrayList<String> suggestions = new ArrayList<String>();
            suggestions.addAll(ForgeRegistries.ITEMS.getKeys().stream().map(ResourceLocation::toString).toList());
            suggestions.addAll(ModList.get().getMods().stream().map(IModInfo::getModId).toList());
            return SharedSuggestionProvider.m_82970_(suggestions, (SuggestionsBuilder)builder);
        }).executes(context -> CSGCommand.blackList((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"target"))))));
    }

    private static int set(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack stack;
        int i;
        DataManager.spawnInventory = new HashMap<PlayerSlot, CompoundTag>();
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        for (i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (stack.m_41619_()) continue;
            DataManager.spawnInventory.put(new PlayerSlot(i, PlayerSlot.EnumInvCategory.MAIN), stack.serializeNBT());
        }
        for (i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
            stack = (ItemStack)player.m_150109_().f_35975_.get(i);
            if (stack.m_41619_()) continue;
            DataManager.spawnInventory.put(new PlayerSlot(i, PlayerSlot.EnumInvCategory.ARMOR), stack.serializeNBT());
        }
        for (i = 0; i < player.m_150109_().f_35976_.size(); ++i) {
            stack = (ItemStack)player.m_150109_().f_35976_.get(i);
            if (stack.m_41619_()) continue;
            DataManager.spawnInventory.put(new PlayerSlot(i, PlayerSlot.EnumInvCategory.OFF_HAND), stack.serializeNBT());
        }
        try {
            DataManager.saveConfig();
        }
        catch (IOException e) {
            LOGGER.error("Something when wrong while saving inventory!");
            e.printStackTrace();
            throw new CommandRuntimeException((Component)Component.m_237113_((String)(e.getMessage() + " [See console for stacktrace]")));
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Your current inventory has been saved and will be given to players when they login for the first time!").m_130940_(ChatFormatting.GREEN), true);
        return 0;
    }

    private static int give(CommandContext<CommandSourceStack> ctx, Player player) {
        DataManager.givePlayerStartGear(player);
        return 0;
    }

    private static int blackList(CommandContext<CommandSourceStack> ctx, String target) {
        boolean isMod;
        boolean bl = isMod = !target.contains(":");
        if (DataManager.wipeBlacklist.contains(target)) {
            DataManager.wipeBlacklist.remove(target);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed " + (isMod ? "Mod" : "Item") + " " + target + " from wipe black list.")), true);
            try {
                DataManager.saveConfig();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new CommandRuntimeException((Component)Component.m_237113_((String)e.getMessage()));
            }
            return 0;
        }
        if (isMod) {
            if (!ModList.get().isLoaded(target)) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Could not find mod with id " + target)));
                return 1;
            }
        } else if (!ForgeRegistries.ITEMS.containsKey(new ResourceLocation(target))) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Could not find item with id " + target)));
            return 1;
        }
        DataManager.wipeBlacklist.add(target);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Added " + (isMod ? "Mod" : "Item") + " " + target + " to wipe black list.")), true);
        try {
            DataManager.saveConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommandRuntimeException((Component)Component.m_237113_((String)e.getMessage()));
        }
        return 0;
    }
}

