/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.entity;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_machinery.Common;
import immersive_machinery.Items;
import immersive_machinery.Sounds;
import immersive_machinery.Utils;
import immersive_machinery.client.KeyBindings;
import immersive_machinery.entity.MachineEntity;
import immersive_machinery.network.c2s.TunnelDiggerControlsUpdate;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class TunnelDigger
extends MachineEntity {
    public int drillY = 0;
    public boolean drilling = false;
    public boolean drillOn = true;
    public float drillingAnimation = 0.0f;
    public float lastDrillingAnimation = 0.0f;
    public float drillPower = 0.0f;

    public TunnelDigger(EntityType<? extends TunnelDigger> entityType, Level world) {
        super(entityType, world, true);
    }

    public Item asItem() {
        return Items.TUNNEL_DIGGER.get();
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20160_()) {
            this.drillY = 0;
            this.drilling = false;
        } else if (this.drilling) {
            Level level;
            this.drillPower = Math.min(this.drillPower + this.getDrillSpeed() / 20.0f, 1.0f);
            if (this.drillPower > 0.0f && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
                float front = -0.25f;
                float height = 1.5f;
                Vector3f forwardDirection = this.getForwardDirection();
                Vector3f rightDirection = this.getRightDirection();
                Vector3f upDirection = this.getTopDirection();
                Vector3f center = new Vector3f((Vector3fc)forwardDirection).mul(front).add(0.0f, height, 0.0f);
                center = center.add((float)this.m_20185_(), (float)this.m_20186_(), (float)this.m_20189_());
                for (int x = -1; x <= 1; ++x) {
                    for (int z = 0; z <= 3; ++z) {
                        for (int y = -1 - Math.max(0, -this.drillY); y <= 1 + Math.max(0, this.drillY); ++y) {
                            if (this.drillY > 0 && y == 2 && z == 0 || this.drillY > 0 && y == -2 && z == 3 || this.drillY < 0 && y == 2 && z == 0 || this.drillY < 0 && y == -2 && z == 3) continue;
                            double px = center.x + rightDirection.x * (float)x + upDirection.x * (float)y + forwardDirection.x * (float)z;
                            double py = center.y + rightDirection.y * (float)x + upDirection.y * (float)y + forwardDirection.y * (float)z;
                            double pz = center.z + rightDirection.z * (float)x + upDirection.z * (float)y + forwardDirection.z * (float)z;
                            positions.add(Utils.doubleToPos(px, py, pz));
                        }
                    }
                }
                while (!positions.isEmpty() && this.drillPower > 0.0f) {
                    BlockPos blockPos = (BlockPos)positions.remove(this.f_19796_.m_188503_(positions.size()));
                    float destroySpeed = Utils.mineBlock(level2, blockPos, this);
                    this.burnShards(destroySpeed);
                    this.drillPower -= destroySpeed;
                }
            }
        }
        this.lastDrillingAnimation = this.drillingAnimation;
        this.drillingAnimation += (float)(this.drilling ? 1 : 0) * 0.1f;
        this.m_274367_(this.drillY > 0 || !this.drilling ? 1.1f : 0.55f);
        if (this.m_9236_().m_5776_()) {
            double chance = this.engineSpinUpStrength + this.getEnginePower();
            if (this.m_9236_().f_46441_.m_188500_() < chance) {
                boolean fire = this.m_9236_().f_46441_.m_188501_() < this.engineSpinUpStrength;
                Matrix4f transform = this.getVehicleTransform();
                Vector4f pos = this.transformPosition(transform, 1.0f, 2.45f, -0.9375f);
                this.m_9236_().m_7106_((ParticleOptions)(fire ? ParticleTypes.f_175834_ : ParticleTypes.f_123762_), (double)pos.x, (double)pos.y, (double)pos.z, 0.0, 0.1, 0.0);
            }
        }
    }

    public float getDrillSpeed() {
        return (this.hasShards() ? 10.0f : 5.0f) * this.getProperties().get(Common.DRILLING_SPEED);
    }

    public boolean hasShards() {
        return this.getSlots(Common.SLOT_SHARDS).stream().anyMatch(slot -> !slot.m_41619_());
    }

    public void burnShards(float destroySpeed) {
        List shards;
        if ((double)this.f_19796_.m_188501_() < (double)destroySpeed / 64.0 && !(shards = this.getSlots(Common.SLOT_SHARDS)).isEmpty()) {
            ((ItemStack)shards.get(this.f_19796_.m_188503_(shards.size()))).m_41774_(1);
        }
    }

    @Override
    protected void updateController() {
        boolean newDilling;
        super.updateController();
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        int newDrillY = this.movementY > 0.0f ? 1 : (this.movementY < 0.0f ? -1 : 0);
        boolean bl = newDilling = (this.movementY != 0.0f || this.movementZ > 0.0f) && this.drillOn && this.getEnginePower() > 0.1f;
        if (newDrillY != this.drillY || newDilling != this.drilling) {
            this.drillY = newDrillY;
            this.drilling = newDilling;
            NetworkHandler.sendToServer((Message)new TunnelDiggerControlsUpdate(this.drillY, this.drilling));
        }
        if (this.movementX == 0.0f) {
            float yRot = this.m_146908_();
            double step = 90.0;
            double targetRotation = (double)Math.round((double)yRot / step) * step;
            double speed = 0.06f;
            this.m_146922_((float)((double)yRot * (1.0 - speed) + targetRotation * speed));
            if (this.movementZ == 0.0f) {
                double vSpeed = 0.04f;
                Vec3 deltaMovement = this.m_20184_();
                double dx = this.m_20185_() - ((double)Math.round(this.m_20185_() - 0.5) + 0.5);
                double dz = this.m_20189_() - ((double)Math.round(this.m_20189_() - 0.5) + 0.5);
                this.m_20256_(deltaMovement.m_82520_(-dx * vSpeed, 0.0, -dz * vSpeed));
            }
        }
        if (KeyBindings.HORN.m_90859_()) {
            this.toggleDrill();
        }
    }

    public void toggleDrill() {
        this.drillOn = !this.drillOn;
        LivingEntity pilot = this.m_6688_();
        if (pilot != null) {
            pilot.m_213846_((Component)Component.m_237115_((String)(this.drillOn ? "immersive_machinery.tunnel_digger.drill_on" : "immersive_machinery.tunnel_digger.drill_off")));
        }
    }

    public Vec3 attemptToDismount(LivingEntity passenger, float ox, float oy, float oz) {
        Vector3f p = new Vector3f((float)this.m_20185_() + ox * 2.0f, (float)this.m_20186_() + oy * 2.0f, (float)this.m_20189_() + oz * 2.0f);
        Vec3 position = new Vec3((double)p.x, (double)p.y, (double)p.z);
        for (Pose entityPose : passenger.m_7431_()) {
            if (!DismountHelper.m_150279_((CollisionGetter)this.m_9236_(), (Vec3)position, (LivingEntity)passenger, (Pose)entityPose)) continue;
            passenger.m_20124_(entityPose);
            return position;
        }
        return null;
    }

    @NotNull
    public Vec3 m_7688_(LivingEntity passenger) {
        Vector3f forwardDirection = this.getForwardDirection();
        Vec3 dismountLocation = this.attemptToDismount(passenger, -forwardDirection.x(), 0.0f, -forwardDirection.z());
        if (dismountLocation != null) {
            return dismountLocation;
        }
        Vector3f rightDirection = this.getRightDirection();
        dismountLocation = this.attemptToDismount(passenger, rightDirection.x(), 0.0f, rightDirection.z());
        if (dismountLocation != null) {
            return dismountLocation;
        }
        dismountLocation = this.attemptToDismount(passenger, -rightDirection.x(), 0.0f, -rightDirection.z());
        if (dismountLocation != null) {
            return dismountLocation;
        }
        dismountLocation = this.attemptToDismount(passenger, forwardDirection.x(), 0.0f, forwardDirection.z());
        if (dismountLocation != null) {
            return dismountLocation;
        }
        return super.m_7688_(passenger);
    }

    public boolean isTrackMoving() {
        return this.getSpeedVector().m_82556_() > (double)1.0E-5f;
    }

    public void setAnimationVariables(float tickDelta) {
        super.setAnimationVariables(tickDelta);
        BBAnimationVariables.set((String)"drill", (float)(this.getDrillingAnimation(tickDelta) * 64.0f));
        BBAnimationVariables.set((String)"drill_rx", (float)0.0f);
        BBAnimationVariables.set((String)"drill_rz", (float)0.0f);
        double p = this.enginePower.getSmooth();
        BBAnimationVariables.set((String)"engine_vibration_x", (float)((float)((this.f_19796_.m_188500_() - 0.5) * p)));
        BBAnimationVariables.set((String)"engine_vibration_y", (float)((float)((this.f_19796_.m_188500_() - 0.5) * p)));
        BBAnimationVariables.set((String)"engine_vibration_z", (float)((float)((this.f_19796_.m_188500_() - 0.5) * p)));
    }

    public float getDrillingAnimation(float tickDelta) {
        return this.lastDrillingAnimation + (this.drillingAnimation - this.lastDrillingAnimation) * tickDelta;
    }

    public double getZoom() {
        return 4.0;
    }

    protected SoundEvent getEngineSound() {
        return this.drilling ? Sounds.TUNNEL_DIGGER_DRILLING.get() : Sounds.TUNNEL_DIGGER.get();
    }
}

