/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.client.render.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import immersive_aircraft.client.render.entity.renderer.utils.ModelPartRenderHandler;
import immersive_machinery.Common;
import immersive_machinery.client.render.entity.renderer.MachineryRenderer;
import immersive_machinery.config.Config;
import immersive_machinery.entity.Copperfin;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FogType;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class CopperfinRenderer<T extends Copperfin>
extends MachineryRenderer<T> {
    private static final ResourceLocation ID = Common.locate("copperfin");
    private final ModelPartRenderHandler<T> model = new ModelPartRenderHandler();

    private Matrix3f getVehicleNormalTransform(T entity, float yaw, float tickDelta) {
        Matrix3f transform = new Matrix3f();
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-yaw));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_(entity.m_5686_(tickDelta)));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(entity.getRoll(tickDelta)));
        return transform;
    }

    public void renderWaterMask(T entity, float yaw, float tickDelta, PoseStack matrixStack, MultiBufferSource source, int light) {
        Matrix3f transform = this.getVehicleNormalTransform(entity, yaw, tickDelta);
        float z = 0.04f;
        float waterHeight = (float)((double)(((Copperfin)((Object)entity)).waterSurface + z) - (entity.m_20186_() * (double)tickDelta + ((Copperfin)((Object)entity)).f_19791_ * (1.0 - (double)tickDelta)));
        boolean firstPerson = Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON;
        float iz = firstPerson ? z : -z;
        Vector3f b0 = new Vector3f(-0.75f + iz, 0.125f + iz, -0.25f + iz);
        Vector3f b1 = new Vector3f(0.75f - iz, 0.125f + iz, -0.25f + iz);
        Vector3f b2 = new Vector3f(0.75f - iz, 0.125f + iz, 0.9375f - iz);
        Vector3f b3 = new Vector3f(-0.75f + iz, 0.125f + iz, 0.9375f - iz);
        float h0 = Math.fma((float)transform.m01(), (float)b0.x, (float)Math.fma((float)transform.m11(), (float)b0.y, (float)(transform.m21() * b0.z)));
        float h1 = Math.fma((float)transform.m01(), (float)b1.x, (float)Math.fma((float)transform.m11(), (float)b1.y, (float)(transform.m21() * b1.z)));
        float h2 = Math.fma((float)transform.m01(), (float)b2.x, (float)Math.fma((float)transform.m11(), (float)b2.y, (float)(transform.m21() * b2.z)));
        float h3 = Math.fma((float)transform.m01(), (float)b3.x, (float)Math.fma((float)transform.m11(), (float)b3.y, (float)(transform.m21() * b3.z)));
        float ht0 = Math.fma((float)transform.m01(), (float)b0.x, (float)Math.fma((float)transform.m11(), (float)(b0.y + 1.0f), (float)(transform.m21() * b0.z)));
        float ht1 = Math.fma((float)transform.m01(), (float)b1.x, (float)Math.fma((float)transform.m11(), (float)(b1.y + 1.0f), (float)(transform.m21() * b1.z)));
        float ht2 = Math.fma((float)transform.m01(), (float)b2.x, (float)Math.fma((float)transform.m11(), (float)(b2.y + 1.0f), (float)(transform.m21() * b2.z)));
        float ht3 = Math.fma((float)transform.m01(), (float)b3.x, (float)Math.fma((float)transform.m11(), (float)(b3.y + 1.0f), (float)(transform.m21() * b3.z)));
        float maxHeight = 1.5f - z;
        float f0 = java.lang.Math.max(0.0f, java.lang.Math.min(maxHeight, (waterHeight - h0) / (ht0 - h0)));
        float f1 = java.lang.Math.max(0.0f, java.lang.Math.min(maxHeight, (waterHeight - h1) / (ht1 - h1)));
        float f2 = java.lang.Math.max(0.0f, java.lang.Math.min(maxHeight, (waterHeight - h2) / (ht2 - h2)));
        float f3 = java.lang.Math.max(0.0f, java.lang.Math.min(maxHeight, (waterHeight - h3) / (ht3 - h3)));
        if (f0 == 0.0f || f1 == 0.0f || f2 == 0.0f || f3 == 0.0f) {
            return;
        }
        Vector3f t0 = new Vector3f(0.0f, f0, 0.0f).add((Vector3fc)b0);
        Vector3f t1 = new Vector3f(0.0f, f1, 0.0f).add((Vector3fc)b1);
        Vector3f t2 = new Vector3f(0.0f, f2, 0.0f).add((Vector3fc)b2);
        Vector3f t3 = new Vector3f(0.0f, f3, 0.0f).add((Vector3fc)b3);
        Vector3f[][] faces = new Vector3f[][]{{t0, t1, t2, t3}, {t3, t2, t1, t0}, {b3, b2, b1, b0}, {b0, b1, t1, t0}, {b1, b2, t2, t1}, {b2, b3, t3, t2}, {b3, b0, t0, t3}};
        Vector3f[] normals = new Vector3f[]{new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 0.0f)};
        int averageWaterColor = BiomeColors.m_108811_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)entity.m_20097_());
        boolean renderTop = f0 < maxHeight || f1 < maxHeight || f2 < maxHeight || f3 < maxHeight;
        boolean cameraInFluid = Minecraft.m_91087_().f_91063_.m_109153_().m_167685_() != FogType.NONE;
        for (int j = renderTop ? 0 : 2; j < (firstPerson || !cameraInFluid ? 7 : 2); ++j) {
            VertexConsumer buffer = j < 2 ? source.m_6299_(RenderType.m_110478_()) : source.m_6299_(RenderType.m_110473_((ResourceLocation)Common.locate("textures/white.png")));
            for (int i = 0; i < 4; ++i) {
                Vector3f v = faces[j][i];
                Vector3f n = normals[i];
                Vector4f v2 = matrixStack.m_85850_().m_252922_().transform(new Vector4f(v.x, v.y + (j == 0 ? -z * 2.0f : 0.0f), v.z, 1.0f));
                buffer.m_5483_((double)v2.x, (double)v2.y, (double)v2.z);
                buffer.m_193479_(averageWaterColor | 0x70000000);
                buffer.m_7421_(0.5f, 0.5f);
                buffer.m_86008_(OverlayTexture.f_118083_);
                buffer.m_85969_(light);
                buffer.m_252939_(matrixStack.m_85850_().m_252943_(), n.x, n.y, n.z);
                buffer.m_5752_();
            }
        }
    }

    public void renderLocal(T entity, float yaw, float tickDelta, PoseStack matrixStack, PoseStack.Pose peek, MultiBufferSource vertexConsumerProvider, int light) {
        super.renderLocal(entity, yaw, tickDelta, matrixStack, peek, vertexConsumerProvider, light);
        if (Config.getInstance().waterRenderingFixForCopperfin) {
            this.renderWaterMask(entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
        }
    }

    protected ResourceLocation getModelId() {
        return ID;
    }

    public CopperfinRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.6f;
    }

    protected ModelPartRenderHandler<T> getModel(T entity) {
        return this.model;
    }
}

