/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util;

import java.net.URL;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.Logger;
import org.zeith.hammerlib.client.adapter.ChatMessageAdapter;
import org.zeith.hammerlib.core.adapter.ModSourceAdapter;
import org.zeith.hammerlib.event.fml.FMLFingerprintCheckEvent;
import org.zeith.hammerlib.proxy.HLConstants;

public class CommonMessages {
    private static final String EMPTY_KEY = HLConstants.id("empty").m_214296_("info");
    public static final Component CRAFTING_MATERIAL = Component.m_237115_((String)HLConstants.id("material").m_214296_("info")).m_130940_(ChatFormatting.GRAY);
    public static final Supplier<Component> EMPTY = () -> Component.m_237115_((String)EMPTY_KEY);

    public static CheckResult printMessageOnIllegalRedistribution(Class<?> modClass, Logger log, String modName, String downloadUrl) {
        ModSourceAdapter.ModSource illegalSourceNotice = ModSourceAdapter.getModSource(modClass).filter(ModSourceAdapter.ModSource::wasDownloadedIllegally).orElse(null);
        if (illegalSourceNotice != null) {
            log.error("=".repeat(52));
            log.fatal("== WARNING: " + modName + " was downloaded from " + illegalSourceNotice.referrerDomain() + ", which has been marked as illegal site over at stopmodreposts.org.");
            log.fatal("== Please download the mod from " + downloadUrl);
            log.error("=".repeat(52));
            MutableComponent illegalUri = Component.m_237113_((String)illegalSourceNotice.referrerDomain()).m_130938_(s -> s.m_131140_(ChatFormatting.RED));
            MutableComponent smrUri = Component.m_237113_((String)"stopmodreposts.org").m_130938_(s -> s.m_131140_(ChatFormatting.BLUE).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://stopmodreposts.org/")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to open webpage."))));
            String host = downloadUrl;
            try {
                host = new URL(downloadUrl).getAuthority();
            }
            catch (Exception exception) {
                // empty catch block
            }
            MutableComponent curseforgeUri = Component.m_237113_((String)host).m_130938_(s -> s.m_131140_(ChatFormatting.BLUE).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, downloadUrl)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to open webpage."))));
            ChatMessageAdapter.sendOnFirstWorldLoad((Component)Component.m_237113_((String)("WARNING: " + modName + " was downloaded from ")).m_7220_((Component)illegalUri).m_130946_(", which has been marked as illegal site over at ").m_7220_((Component)smrUri).m_130946_(". Please download the mod from ").m_7220_((Component)curseforgeUri).m_130946_("."));
            return CheckResult.VIOLATION_FOUND;
        }
        return CheckResult.OK;
    }

    public static CheckResult printMessageOnFingerprintViolation(FMLFingerprintCheckEvent event, String expectFingerprint, Logger log, String modName, String downloadUrl) {
        if (event.isViolated(expectFingerprint)) {
            log.error("=".repeat(52));
            log.fatal("== WARNING: Somebody has been tampering with " + modName + "'s jar! (" + event.getModContainer().getModInfo().getOwningFile().getFile().getFileName() + ")");
            log.fatal("== It is highly recommended that you re-download it from " + downloadUrl);
            Set<String> set = event.getInvalidSignedFiles();
            if (!set.isEmpty()) {
                log.fatal("== Here are " + set.size() + " files that have been found to be corrupted:");
                for (String e : set) {
                    log.fatal("== " + e);
                }
            }
            log.error("=".repeat(52));
            String host = downloadUrl;
            try {
                host = new URL(downloadUrl).getAuthority();
            }
            catch (Exception e) {
                // empty catch block
            }
            MutableComponent curseforgeUri = Component.m_237113_((String)host).m_130938_(s -> s.m_131140_(ChatFormatting.BLUE).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, downloadUrl)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to open webpage."))));
            ChatMessageAdapter.sendOnFirstWorldLoad((Component)Component.m_237113_((String)("WARNING: " + modName + " was tampered by someone. Please download the mod from ")).m_7220_((Component)curseforgeUri).m_130946_("."));
            return CheckResult.VIOLATION_FOUND;
        }
        return CheckResult.OK;
    }

    public static enum CheckResult {
        OK,
        VIOLATION_FOUND;

    }
}

