/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.items.tooltip;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Comparator;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.zeith.hammerlib.util.colors.ColorHelper;

public class TooltipColoredLine
implements TooltipComponent {
    private final IntList colors;

    public TooltipColoredLine(int[] colors) {
        this.colors = new IntArrayList(colors);
        this.colors.sort(IntComparators.asIntComparator(Comparator.comparingInt(this::getHue).thenComparingDouble(ColorHelper::luma)));
    }

    public int getHue(int rgb) {
        float max;
        int red = ColorHelper.getRedi(rgb);
        int green = ColorHelper.getGreeni(rgb);
        int blue = ColorHelper.getBluei(rgb);
        float min = Math.min(Math.min(red, green), blue);
        if (min == (max = (float)Math.max(Math.max(red, green), blue))) {
            return 0;
        }
        float hue = max == (float)red ? (float)(green - blue) / (max - min) : (max == (float)green ? 2.0f + (float)(blue - red) / (max - min) : 4.0f + (float)(red - green) / (max - min));
        if ((hue *= 60.0f) < 0.0f) {
            hue += 360.0f;
        }
        return Math.round(hue);
    }

    public IntList getColors() {
        return this.colors;
    }
}

