/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackTemplates;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.DatapackBackpackTemplateManager;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.command.BackpackTemplateArgumentType;
import net.p3pp3rf1y.sophisticatedbackpacks.command.DynamicCommand;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;

public class TemplateCommand {
    private TemplateCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register(RegisterCommandsEvent event) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"template").then(DynamicCommand.register(event.getBuildContext()))).then(Commands.m_82127_((String)"list").executes(context -> TemplateCommand.templateDetailComponent((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"create").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"templateName", (ArgumentType)BackpackTemplateArgumentType.templateName()).executes(context -> TemplateCommand.createTemplate((CommandSourceStack)context.getSource(), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "templateName"), false))).then(Commands.m_82129_((String)"override", (ArgumentType)BoolArgumentType.bool()).executes(context -> TemplateCommand.createTemplate((CommandSourceStack)context.getSource(), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "templateName"), BoolArgumentType.getBool((CommandContext)context, (String)"override"))))))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"templateName", (ArgumentType)BackpackTemplateArgumentType.templateName(false)).executes(context -> TemplateCommand.deleteTemplate((CommandSourceStack)context.getSource(), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "templateName")))))).then(Commands.m_82127_((String)"give").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"templateName", (ArgumentType)BackpackTemplateArgumentType.templateName()).executes(context -> TemplateCommand.giveBackpackFromTemplate((CommandSourceStack)context.getSource(), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "templateName"), List.of(((CommandSourceStack)context.getSource()).m_230896_())))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(context -> TemplateCommand.giveBackpackFromTemplate((CommandSourceStack)context.getSource(), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "templateName"), EntityArgument.m_91477_((CommandContext)context, (String)"targets"))))))).then(Commands.m_82127_((String)"export").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"templateName", (ArgumentType)BackpackTemplateArgumentType.templateName()).executes(context -> TemplateCommand.exportTemplate((CommandSourceStack)context.getSource(), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "templateName"), false))).then(Commands.m_82129_((String)"delete", (ArgumentType)BoolArgumentType.bool()).executes(context -> TemplateCommand.exportTemplate((CommandSourceStack)context.getSource(), BackpackTemplateArgumentType.getId((CommandContext<CommandSourceStack>)context, "templateName"), true)))));
    }

    private static int templateDetailComponent(CommandSourceStack source) {
        source.m_288197_(() -> Component.m_237115_((String)"commands.sophisticatedbackpacks.template.list.header"), false);
        source.m_288197_(() -> Component.m_237113_((String)"Datapack"), false);
        DatapackBackpackTemplateManager.getBackpackTemplates().keySet().forEach(templateName -> source.m_288197_(() -> TemplateCommand.templateDetailComponent(templateName, false), false));
        source.m_288197_(() -> Component.m_237113_((String)"Local"), false);
        BackpackTemplates.getTemplateNames(false).forEach(templateName -> source.m_288197_(() -> TemplateCommand.templateDetailComponent(templateName, true), false));
        return 0;
    }

    private static MutableComponent templateDetailComponent(ResourceLocation templateName, boolean includeNonDatapackMessages) {
        MutableComponent message = Component.m_237113_((String)templateName.toString());
        message.m_7220_((Component)Component.m_237113_((String)", "));
        message.m_7220_((Component)Component.m_237115_((String)"commands.sophisticatedbackpacks.template.list.give").m_130938_(s -> s.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/sophisticatedbackpacks template give " + String.valueOf(templateName))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"commands.sophisticatedbackpacks.template.list.give.tooltip", (Object[])new Object[]{templateName.toString()})))));
        if (includeNonDatapackMessages) {
            message.m_7220_((Component)Component.m_237113_((String)", "));
            message.m_7220_((Component)Component.m_237115_((String)"commands.sophisticatedbackpacks.template.list.export").m_130938_(s -> s.m_131140_(ChatFormatting.AQUA).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/sophisticatedbackpacks template export " + String.valueOf(templateName))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"commands.sophisticatedbackpacks.template.list.export.tooltip", (Object[])new Object[]{templateName.toString()})))));
            message.m_7220_((Component)Component.m_237113_((String)", "));
            message.m_7220_((Component)Component.m_237115_((String)"commands.sophisticatedbackpacks.template.list.delete").m_130938_(s -> s.m_131140_(ChatFormatting.RED).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/sophisticatedbackpacks template delete " + String.valueOf(templateName))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"commands.sophisticatedbackpacks.template.list.delete.tooltip", (Object[])new Object[]{templateName.toString()})))));
        }
        return message;
    }

    private static int createTemplate(CommandSourceStack source, ResourceLocation templateName, boolean override) {
        if (!source.m_230897_()) {
            return 1;
        }
        ServerPlayer player = source.m_230896_();
        ItemStack backpack = player.m_21205_();
        if (!(backpack.m_41720_() instanceof BackpackItem)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.sophisticatedbackpacks.template.create.nobackpack"));
            return 2;
        }
        BackpackWrapper backpackWrapper = new BackpackWrapper(backpack);
        Optional backpackUuid = backpackWrapper.getContentsUuid();
        if (backpackUuid.isEmpty() || InventoryHelper.isEmpty((IItemHandler)backpackWrapper.getInventoryHandler()) && InventoryHelper.isEmpty((IItemHandler)backpackWrapper.getUpgradeHandler())) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.sophisticatedbackpacks.template.backpackempty"));
            return 3;
        }
        if (BackpackTemplates.getTemplateNames().contains(templateName) && !override) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.sophisticatedbackpacks.template.create.alreadyexists", (Object[])new Object[]{templateName.toString()}));
            return 4;
        }
        BackpackTemplates.setBackpackTemplate(templateName, backpackWrapper);
        source.m_288197_(() -> Component.m_237110_((String)"commands.sophisticatedbackpacks.template.create.success", (Object[])new Object[]{templateName.toString()}), true);
        return 0;
    }

    private static int deleteTemplate(CommandSourceStack source, ResourceLocation templateName) {
        BackpackTemplates.removeBackpackTemplate(templateName);
        source.m_288197_(() -> Component.m_237110_((String)"commands.sophisticatedbackpacks.template.delete.success", (Object[])new Object[]{templateName.toString()}), true);
        return 0;
    }

    private static int giveBackpackFromTemplate(CommandSourceStack source, ResourceLocation templateName, Collection<ServerPlayer> players) {
        Optional<CompoundTag> templateData = BackpackTemplates.getBackpackTemplate(templateName);
        if (templateData.isEmpty()) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.sophisticatedbackpacks.template.give.failure.notemplate", (Object[])new Object[]{templateName.toString()}));
            return 1;
        }
        ItemStack backpack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(templateData.get().m_128461_("backpackItemRegistryName"))));
        BackpackWrapper wrapper = new BackpackWrapper(backpack);
        wrapper.setTemplate(templateName);
        players.forEach(p -> TemplateCommand.giveBackpackToPlayer(backpack.m_41777_(), p));
        if (players.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.sophisticatedbackpacks.template.give.backpack.success", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.sophisticatedbackpacks.template.give.backpack.success", (Object[])new Object[]{players.size()}), true);
        }
        return 0;
    }

    private static void giveBackpackToPlayer(ItemStack backpack, ServerPlayer p) {
        ItemEntity itemEntity;
        boolean flag = p.m_150109_().m_36054_(backpack);
        if (flag && backpack.m_41619_()) {
            backpack.m_41764_(1);
            itemEntity = p.m_36176_(backpack, false);
            if (itemEntity != null) {
                itemEntity.m_32065_();
            }
            p.m_9236_().m_6263_(null, p.m_20185_(), p.m_20186_(), p.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne((RandomSource)p.m_217043_()) * 0.7f + 1.0f) * 2.0f);
            p.f_36095_.m_38946_();
        } else {
            ItemEntity itementity = p.m_36176_(backpack, false);
            if (itementity != null) {
                itementity.m_32061_();
                itementity.m_32052_(p.m_20148_());
            }
        }
        itemEntity = p.m_36176_(backpack, false);
        if (itemEntity != null) {
            itemEntity.m_32065_();
        }
    }

    private static int exportTemplate(CommandSourceStack source, ResourceLocation templateName, boolean deleteTemplate) {
        Optional<CompoundTag> templateData = BackpackTemplates.getBackpackTemplateNoDatapack(templateName);
        if (templateData.isEmpty()) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.sophisticatedbackpacks.template.export.failure.notemplate", (Object[])new Object[]{templateName.toString()}));
            return 1;
        }
        BackpackTemplates.exportTemplate(source.m_230896_(), templateName, templateData.get());
        if (deleteTemplate) {
            BackpackTemplates.removeBackpackTemplate(templateName);
        }
        return 0;
    }
}

