/*
 * Decompiled with CFR 0.152.
 */
package fr.shoqapik.w2w2;

import fr.shoqapik.w2w2.WaystoneActivatedPacket;
import java.io.IOException;
import java.util.ArrayList;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneActivatedEvent;
import net.blay09.mods.waystones.api.WaystoneUpdateReceivedEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.IXaeroMinimapClientPlayNetHandler;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModSettings;
import xaero.minimap.XaeroMinimap;

@Mod(value="w2w2")
public class W2w2Mod {
    public static final String MODID = "w2w2";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("w2w2", "main"), () -> "1", "1"::equals, "1"::equals);

    public W2w2Mod() {
        INSTANCE.registerMessage(0, WaystoneActivatedPacket.class, WaystoneActivatedPacket::encode, WaystoneActivatedPacket::decode, WaystoneActivatedPacket::handle);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onWaystoneActivated(WaystoneActivatedEvent event) {
        if (!event.getPlayer().m_7578_()) {
            IWaystone waystone = event.getWaystone();
            WaystoneActivatedPacket packet = new WaystoneActivatedPacket(waystone.getPos(), waystone.getName());
            W2w2Mod.sendToClient(packet, (ServerPlayer)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onWaystoneUpdated(WaystoneUpdateReceivedEvent event) {
        IWaystone waystone = event.getWaystone();
        String name = waystone.getName();
        BlockPos pos = waystone.getPos();
        IXaeroMinimapClientPlayNetHandler clientLevel = (IXaeroMinimapClientPlayNetHandler)Minecraft.m_91087_().f_91074_.f_108617_;
        XaeroMinimapSession session = clientLevel.getXaero_minimapSession();
        WaypointsManager waypointsManager = session.getWaypointsManager();
        Waypoint waypoint = this.getWaypoint(waypointsManager.getWaypoints().getList(), waystone);
        if (waypoint == null) {
            Waypoint instant = new Waypoint(pos.m_123341_(), pos.m_123342_() + 2, pos.m_123343_(), name, name.substring(0, 1), (int)(Math.random() * (double)ModSettings.ENCHANT_COLORS.length), 0, false);
            waypointsManager.getWaypoints().getList().add(instant);
        } else {
            waypoint.setName(name);
            waypoint.setSymbol(name.substring(0, 1));
            waypoint.setX(pos.m_123341_());
            waypoint.setY(pos.m_123342_() + 2);
            waypoint.setZ(pos.m_123343_());
        }
        try {
            XaeroMinimap.instance.getSettings().saveWaypoints(waypointsManager.getCurrentWorld());
        }
        catch (IOException error) {
            error.printStackTrace();
        }
    }

    public static <MSG> void sendToClient(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    private Waypoint getWaypoint(ArrayList<Waypoint> waypoints, IWaystone waystone) {
        BlockPos waystonePos = waystone.getPos();
        for (Waypoint waypoint : waypoints) {
            if (waypoint.getX() != waystonePos.m_123341_() || waypoint.getY() != waystonePos.m_123342_() + 2 || waypoint.getZ() != waystonePos.m_123343_()) continue;
            return waypoint;
        }
        return null;
    }
}

