/*
 * Decompiled with CFR 0.152.
 */
package tfar.enchantedbookredesign;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;
import tfar.enchantedbookredesign.EnchantedBookRedesign;
import tfar.enchantedbookredesign.Hooks;
import tfar.enchantedbookredesign.platform.MLConfig;

@Mod(value="enchantedbookredesign")
public class EnchantedBookRedesignForge {
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static Set<Item> cache;

    public EnchantedBookRedesignForge() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
        if (FMLEnvironment.dist.isClient()) {
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            bus.addListener(this::configLoad);
            bus.addListener(this::shaders);
            bus.addListener(this::itemColors);
            EnchantedBookRedesign.init();
        } else {
            System.out.println("why is this on the server?");
        }
    }

    private void itemColors(RegisterColorHandlersEvent.Item event) {
        EnchantedBookRedesign.applyTints(event.getItemColors());
    }

    private void shaders(RegisterShadersEvent e) {
        try {
            e.registerShader(new ShaderInstance(e.getResourceProvider(), EnchantedBookRedesign.id("rendertype_tinted_glint_direct"), DefaultVertexFormat.f_85818_), instance -> {
                Hooks.rendertype_tinted_glint_direct = instance;
            });
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void configLoad(ModConfigEvent e) {
        if (e.getConfig().getModId().equals("enchantedbookredesign")) {
            cache.clear();
            for (String s : (List)ClientConfig.items.get()) {
                Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(s));
                if (item == Items.f_41852_) {
                    System.out.println(s + " not found");
                    continue;
                }
                cache.add(item);
            }
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        cache = new HashSet<Item>();
    }

    public static class ClientConfig
    implements MLConfig {
        public static ForgeConfigSpec.ConfigValue<List<? extends String>> items;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            items = builder.comment("Which items to override glint for").defineList("items", List.of("minecraft:enchanted_book"), String.class::isInstance);
            builder.pop();
        }

        @Override
        public Set<Item> whitelistedItems() {
            return cache;
        }
    }
}

