/*
 * Decompiled with CFR 0.152.
 */
package com.github.ewan_selkirk.dimensionviewer;

import com.github.ewan_selkirk.dimensionviewer.Config;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="dimensionviewer", value={Dist.DEDICATED_SERVER})
public class PlayerListHandler {
    private static final Map<String, ResourceLocation> players = new HashMap<String, ResourceLocation>();
    private static List<ServerPlayer> playerList = new ArrayList<ServerPlayer>();
    private static final Map<String, String> tokens = new HashMap<String, String>(){
        {
            this.put("%i", "\u00a7o");
            this.put("%b", "\u00a7l");
            this.put("%u", "\u00a7n");
            this.put("%o", "\u00a7k");
            this.put("%s", "\u00a7m");
            this.put("%r", "\u00a7r");
        }
    };

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static synchronized void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        players.put(event.getEntity().m_20149_(), event.getTo().m_135782_());
        PlayerListHandler.updatePlayerList();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static synchronized void changeUserDisplayName(PlayerEvent.TabListNameFormat event) {
        if (((Boolean)Config.DIM_IN_CHAT_NAME.get()).booleanValue()) {
            event.setDisplayName(event.getEntity().m_5446_());
            return;
        }
        try {
            event.setDisplayName((Component)Component.m_237119_().m_130946_(PlayerListHandler.replaceTokens((PlayerEvent)event)));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static synchronized void changeUserChatName(PlayerEvent.NameFormat event) {
        if (!((Boolean)Config.DIM_IN_CHAT_NAME.get()).booleanValue()) {
            return;
        }
        try {
            MutableComponent name = Component.m_237119_();
            name.m_130946_(PlayerListHandler.replaceTokens((PlayerEvent)event));
            if (!((Boolean)Config.CHAT_DIM_HOVER.get()).booleanValue()) {
                event.setDisplayname((Component)name);
                return;
            }
            name.m_6270_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)PlayerListHandler.getSource((PlayerEvent)event)))));
            event.setDisplayname((Component)name);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static synchronized void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        playerList = Objects.requireNonNull(event.getEntity().m_20194_()).m_6846_().m_11314_();
        playerList.forEach(p -> players.put(p.m_20149_(), p.m_9236_().m_46472_().m_135782_()));
        PlayerListHandler.updatePlayerList();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static synchronized void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        players.remove(event.getEntity().m_20149_());
        playerList = Objects.requireNonNull(event.getEntity().m_20194_()).m_6846_().m_11314_();
        PlayerListHandler.updatePlayerList();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static synchronized void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        try {
            players.put(event.getEntity().m_20149_(), event.getEntity().m_9236_().m_46472_().m_135782_());
            PlayerListHandler.updatePlayerList();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static String splitResourceLocation(ResourceLocation key, int pos) {
        String txt = key.toString();
        return txt.split(":")[pos];
    }

    private static String makeTitleCase(String text) {
        if ((text = text.replace("_", " ")).length() <= 2 || text.startsWith(" ") || text.endsWith(" ")) {
            text = text.toUpperCase(Locale.ROOT);
        } else {
            String[] split = text.split(" ");
            StringBuilder builder = new StringBuilder();
            int count = 0;
            for (String s : split) {
                split[count] = Character.toUpperCase(s.charAt(0)) + s.substring(1);
                builder.append(split[count]);
                if (count != split.length - 1) {
                    builder.append(' ');
                }
                ++count;
            }
            text = builder.toString();
        }
        return text;
    }

    private static String replaceTokens(PlayerEvent event) {
        String format = (String)Config.LIST_FORMAT.get();
        Config.FontColor color = (Config.FontColor)((Object)Config.FONT_COLOR.get());
        boolean per_dim_colors = (Boolean)Config.PER_DIM_COLOR.get();
        Config.FontColor[] dim_colors = new Config.FontColor[]{(Config.FontColor)((Object)Config.OVERWORLD_COLOR.get()), (Config.FontColor)((Object)Config.NETHER_COLOR.get()), (Config.FontColor)((Object)Config.END_COLOR.get())};
        String dimension = PlayerListHandler.getDimension(event);
        tokens.put("%d", dimension);
        String name = event.getEntity().m_6302_();
        tokens.put("%p", name);
        for (String s : tokens.keySet()) {
            format = format.replace(s, tokens.get(s));
        }
        if (!per_dim_colors) {
            format = format.replace("%c", color.value);
        } else {
            for (String dim : (List)Config.MODDED_DIMS.get()) {
                if (!players.get(event.getEntity().m_20149_()).toString().equals(dim.split(" ")[0])) continue;
                format = format.replace("%c", Config.FontColor.valueOf((String)dim.split((String)" ")[1]).value);
                break;
            }
            format = format.replace("%c", switch (players.get(event.getEntity().m_20149_()).toString()) {
                case "minecraft:overworld" -> dim_colors[0].value;
                case "minecraft:the_nether" -> dim_colors[1].value;
                case "minecraft:the_end" -> dim_colors[2].value;
                default -> color.value;
            });
        }
        return format;
    }

    private static boolean updatePlayerList() {
        if (playerList.size() > 0) {
            playerList = Objects.requireNonNull(playerList.get(0).m_20194_()).m_6846_().m_11314_();
            if (((Boolean)Config.DIM_IN_CHAT_NAME.get()).booleanValue()) {
                playerList.forEach(Player::refreshDisplayName);
            }
            playerList.forEach(ServerPlayer::refreshTabListName);
            return true;
        }
        return false;
    }

    private static String getSource(PlayerEvent event) {
        return PlayerListHandler.makeTitleCase(PlayerListHandler.splitResourceLocation(players.get(event.getEntity().m_20149_()), 0));
    }

    private static String getDimension(PlayerEvent event) {
        if (((Boolean)Config.ENABLE_ALIASES.get()).booleanValue()) {
            for (int i = 0; i < ((List)Config.DIMENSION_ALIASES.get()).size(); ++i) {
                if (!((String)((List)Config.DIMENSION_ALIASES.get()).get(i)).contains(players.get(event.getEntity().m_20149_()).toString())) continue;
                return ((String)((List)Config.DIMENSION_ALIASES.get()).get(i)).split(" ", 2)[1];
            }
        }
        return PlayerListHandler.makeTitleCase(PlayerListHandler.splitResourceLocation(players.get(event.getEntity().m_20149_()), 1));
    }

    @Mod.EventBusSubscriber(modid="dimensionviewer")
    public static class RegisterCommands {
        @SubscribeEvent
        public static void CommandRegistration(RegisterCommandsEvent event) {
            event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"refreshPlayerList").executes(ctx -> {
                if (PlayerListHandler.updatePlayerList()) {
                    ((CommandSourceStack)ctx.getSource()).m_288197_((Supplier)Component.m_130674_((String)"[Dimension Viewer] Manually refreshing player list..."), true);
                } else {
                    ((CommandSourceStack)ctx.getSource()).m_81352_(Component.m_130674_((String)"[Dimension Viewer] Could not manually refresh. No players detected..."));
                }
                return 0;
            }));
            event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"getdimensionid").executes(ctx -> {
                try {
                    ((CommandSourceStack)ctx.getSource()).m_288197_((Supplier)Component.m_130674_((String)((CommandSourceStack)ctx.getSource()).m_81375_().m_9236_().m_46472_().m_135782_().toString()), false);
                }
                catch (CommandSyntaxException exception) {
                    ((CommandSourceStack)ctx.getSource()).m_81352_(Component.m_130674_((String)"[Dimension Viewer] The command could not detect a player."));
                }
                return 0;
            }));
        }
    }

    @Mod.EventBusSubscriber(modid="dimensionviewer", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventBusEvents {
        @SubscribeEvent
        public static void onConfigChanged(ModConfigEvent.Reloading event) {
            if (event.getConfig().getModId().contains("dimensionviewer")) {
                PlayerListHandler.updatePlayerList();
            }
        }
    }
}

