/*
 * Decompiled with CFR 0.152.
 */
package com.github.ewan_selkirk.dimensionviewer;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Config {
    private static final String modidRegex = "([a-z_]+:[a-z_]+)";
    public static ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec CONFIG;
    public static ForgeConfigSpec.ConfigValue<String> LIST_FORMAT;
    public static ForgeConfigSpec.EnumValue<FontColor> FONT_COLOR;
    public static ForgeConfigSpec.EnumValue<FontColor> OVERWORLD_COLOR;
    public static ForgeConfigSpec.EnumValue<FontColor> NETHER_COLOR;
    public static ForgeConfigSpec.EnumValue<FontColor> END_COLOR;
    public static ForgeConfigSpec.BooleanValue PER_DIM_COLOR;
    public static ForgeConfigSpec.BooleanValue DIM_IN_CHAT_NAME;
    public static ForgeConfigSpec.BooleanValue CHAT_DIM_HOVER;
    public static ForgeConfigSpec.BooleanValue ENABLE_ALIASES;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> MODDED_DIMS;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> DIMENSION_ALIASES;
    private static final List<String> dimensionAliases;
    private static List<String> moddedDimensionList;

    private static void CategoryCustomization() {
        LIST_FORMAT = BUILDER.comment(new String[]{"Format that will be used to display the dimension in the tab list with the use of tokens:", "    %d - Dimension Name", "    %c - Color value (default or dimension-based)", "    %i - Italic font", "    %b - Bold font", "    %u - Underline font", "    %o - Obfuscated font", "    %s - Strikethrough font", "    %r - Font reset"}).define("listFormat", (Object)"%p %c%i<%d>");
        FONT_COLOR = BUILDER.comment(new String[]{"The color to use for the dimension font if perDimColorPath is false.", "(In the event of a modded dimension being entered, this color will be used as a fallback)"}).defineEnum("fontColor", (Enum)FontColor.DARK_AQUA);
        PER_DIM_COLOR = BUILDER.comment("Should each dimension have its own color?").define("perDimColorPath", true);
        ENABLE_ALIASES = BUILDER.comment("Global toggle for dimension aliases. Requires aliases to be set below.").define("enableAliases", true);
        Config.PerDimensionCustomization();
        Config.ChatCustomization();
        Config.ModdedDimensionCustomization();
    }

    private static void PerDimensionCustomization() {
        BUILDER.comment("Per-Dimension Customization").push("dimension");
        OVERWORLD_COLOR = BUILDER.comment("Color to use for the Overworld").defineEnum("overworldColor", (Enum)FontColor.GREEN);
        NETHER_COLOR = BUILDER.comment("Color to use for the Nether").defineEnum("netherColor", (Enum)FontColor.DARK_RED);
        END_COLOR = BUILDER.comment("Color to use for the End").defineEnum("endColor", (Enum)FontColor.DARK_PURPLE);
        BUILDER.pop();
    }

    private static void ChatCustomization() {
        BUILDER.comment("Chat-related Customization").push("chat");
        DIM_IN_CHAT_NAME = BUILDER.comment("Should a users' current dimension be added to chat messages?").define("dimInChatName", true);
        CHAT_DIM_HOVER = BUILDER.comment(new String[]{"Add a hover effect in chat that will display which mod added the dimension", "Requires 'dimInChatName' to be set to true"}).define("chatDimHover", true);
        BUILDER.pop();
    }

    private static void ModdedDimensionCustomization() {
        BUILDER.comment("Modded Dimension Customization").push("modded");
        MODDED_DIMS = BUILDER.comment("A list of modded dimension resource IDs and a color in the format of \"modid:dim_id color\"\nFor example, Twilight Forest in Gold would be \"twilightforest:twilight_forest GOLD\"\nWill throw an exception if the color is not valid\nAllowed Values: DARK_RED, RED, GOLD, YELLOW, DARK_GREEN, GREEN, AQUA, DARK_AQUA, DARK_BLUE, BLUE, LIGHT_PURPLE, DARK_PURPLE, WHITE, GRAY, DARK_GRAY, BLACK").defineListAllowEmpty(List.of("modded_dimension_ids"), () -> moddedDimensionList, item -> {
            String i;
            return item instanceof String && (i = (String)item).matches("([a-z_]+:[a-z_]+) ([A-Z_]+)") && !i.isEmpty() && FontColor.valueOf(i.split(" ")[1]) instanceof FontColor;
        });
        DIMENSION_ALIASES = BUILDER.comment("A list of aliases to use instead of the original dimension ID.\nUses the format 'modid:dim_id New Name'.\nFor example, to replace 'Overworld' with 'Grasslands' you would use 'minecraft:overworld Grasslands'").defineListAllowEmpty(List.of("dimensionAliases"), () -> dimensionAliases, item -> {
            String i;
            return item instanceof String && (i = (String)item).matches("([a-z_]+:[a-z_]+) (.*)");
        });
        BUILDER.pop();
    }

    static {
        dimensionAliases = new ArrayList<String>();
        moddedDimensionList = new ArrayList<String>();
        BUILDER.comment("Customization Settings").push("customization");
        Config.CategoryCustomization();
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }

    public static enum FontColor {
        DARK_RED("\u00a74"),
        RED("\u00a7c"),
        GOLD("\u00a76"),
        YELLOW("\u00a7e"),
        DARK_GREEN("\u00a72"),
        GREEN("\u00a7a"),
        AQUA("\u00a7b"),
        DARK_AQUA("\u00a73"),
        DARK_BLUE("\u00a71"),
        BLUE("\u00a79"),
        LIGHT_PURPLE("\u00a7d"),
        DARK_PURPLE("\u00a75"),
        WHITE("\u00a7f"),
        GRAY("\u00a77"),
        DARK_GRAY("\u00a78"),
        BLACK("\u00a70");

        public final String value;

        private FontColor(String value) {
            this.value = value;
        }

        public static boolean contains(String value) {
            for (FontColor color : FontColor.values()) {
                if (!color.name().equals(value)) continue;
                return true;
            }
            return false;
        }
    }
}

