/*
 * Decompiled with CFR 0.152.
 */
package com.dragn.bettas.tank;

import com.dragn.bettas.BettasMain;
import com.dragn.bettas.decor.Decor;
import com.dragn.bettas.util.config.BettasCommonConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public class TankTile
extends BlockEntity {
    public static final ModelProperty<Integer> CONNECTED = new ModelProperty();
    public static final ModelProperty<Integer> ALGAE = new ModelProperty();
    public static final VoxelShape NORTH = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.03125);
    public static final VoxelShape EAST = Shapes.m_83048_((double)0.96875, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    public static final VoxelShape SOUTH = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.96875, (double)1.0, (double)1.0, (double)1.0);
    public static final VoxelShape WEST = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.03125, (double)1.0, (double)1.0);
    public static final VoxelShape UP = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    public static final VoxelShape DOWN = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.03125, (double)1.0);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    private final OrderedSet decor = new OrderedSet();
    private VoxelShape shape = Shapes.m_83124_((VoxelShape)NORTH, (VoxelShape[])new VoxelShape[]{EAST, SOUTH, WEST, UP, DOWN});
    public int connected = 0;
    public int algae = 0;
    private final int threshold = 24000 * (Integer)BettasCommonConfig.ALGAE_GROWTH_RATE.get();
    private long age = 0L;

    public TankTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BettasMain.TANK_TILE.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        TankTile tankTile = (TankTile)blockEntity;
        if (((Boolean)tankTile.m_58900_().m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            ++tankTile.age;
            if ((long)tankTile.threshold - tankTile.age == 0L) {
                tankTile.incrementAlgae();
                tankTile.age = 0L;
            }
        }
    }

    public VoxelShape getShape() {
        for (int i = 0; i < SHAPES.length; ++i) {
            if ((this.connected >> i & 1) != 1) continue;
            this.shape = Shapes.m_83113_((VoxelShape)this.shape, (VoxelShape)SHAPES[i], (BooleanOp)BooleanOp.f_82685_);
        }
        return this.shape;
    }

    private void handleModelUpdate() {
        if (this.f_58857_ != null) {
            this.m_6596_();
            this.requestModelDataUpdate();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void incrementAlgae() {
        this.algae = Math.min(4, this.algae + 1);
        this.handleModelUpdate();
    }

    public boolean decrementAlgae() {
        int prev = this.algae;
        this.algae = Math.max(0, this.algae - 1);
        boolean decremented = prev != this.algae;
        this.handleModelUpdate();
        return decremented;
    }

    public void addConnected(Direction direction) {
        this.connected |= 1 << direction.m_122411_();
        this.shape = Shapes.m_83113_((VoxelShape)this.shape, (VoxelShape)SHAPES[direction.m_122411_()], (BooleanOp)BooleanOp.f_82685_);
        this.handleModelUpdate();
    }

    public void removeConnected(Direction direction) {
        this.connected &= ~(1 << direction.m_122411_());
        this.shape = Shapes.m_83113_((VoxelShape)this.shape, (VoxelShape)SHAPES[direction.m_122411_()], (BooleanOp)BooleanOp.f_82695_);
        this.handleModelUpdate();
    }

    public ItemStack removeDecor() {
        BlockState state = this.decor.remove();
        if (state != null) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            return new ItemStack((ItemLike)Decor.DECOR_TO_ITEM.get(state.m_60734_()));
        }
        return null;
    }

    public boolean addDecor(Item item, Direction direction) {
        Decor block = Decor.ITEM_TO_DECOR.get(item);
        boolean added = this.decor.add(block.facing(direction));
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return added;
    }

    public Stream<BlockState> allDecor() {
        return this.decor.asStream();
    }

    public void slowGrowth() {
        this.age = -this.threshold;
    }

    protected void m_183515_(@NotNull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_("Algae", this.algae);
        compoundTag.m_128405_("Connected", this.connected);
        compoundTag.m_128356_("Age", this.age);
        compoundTag.m_128365_("Decor", (Tag)this.decor.asNBT());
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.algae = compoundTag.m_128451_("Algae");
        this.connected = compoundTag.m_128451_("Connected");
        this.age = compoundTag.m_128454_("Age");
        this.decor.fromNBT(compoundTag.m_128469_("Decor"));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleModelUpdate();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(CONNECTED, (Object)this.connected).with(ALGAE, (Object)this.algae).build();
    }

    private static final class OrderedSet {
        private final Map<BlockState, BlockState> map = new HashMap<BlockState, BlockState>();
        private BlockState last;

        private OrderedSet() {
        }

        public boolean add(BlockState state) {
            if (!this.map.containsKey(state)) {
                this.map.putIfAbsent(state, this.last);
                this.last = state;
                return true;
            }
            return false;
        }

        public BlockState remove() {
            BlockState ret = this.last;
            this.last = this.map.remove(ret);
            return ret;
        }

        public CompoundTag asNBT() {
            CompoundTag nbt = new CompoundTag();
            this.map.keySet().forEach(k -> {
                String name = k.toString();
                Direction direction = (Direction)k.m_61143_((Property)Decor.FACING);
                nbt.m_128405_(name, direction.ordinal());
            });
            return nbt;
        }

        public void fromNBT(CompoundTag nbt) {
            this.map.clear();
            this.last = null;
            nbt.m_128431_().forEach(k -> {
                Decor block = Decor.NAME_TO_DECOR.get(k);
                Direction direction = Direction.values()[nbt.m_128451_(k)];
                BlockState state = block.facing(direction);
                this.map.put(state, this.last);
                this.last = state;
            });
        }

        public Stream<BlockState> asStream() {
            return this.map.keySet().stream();
        }
    }
}

