/*
 * Decompiled with CFR 0.152.
 */
package com.dragn.bettas.tank;

import com.dragn.bettas.tank.TankTile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TankModel
implements IDynamicBakedModel {
    public static final Material BASE = new Material(InventoryMenu.f_39692_, new ResourceLocation("bettas", "block/base"));
    public static final Material WALLS = new Material(InventoryMenu.f_39692_, new ResourceLocation("bettas", "block/walls"));
    public static final Material[] ALGAE_LEVELS = new Material[]{new Material(InventoryMenu.f_39692_, new ResourceLocation("bettas", "block/algae0")), new Material(InventoryMenu.f_39692_, new ResourceLocation("bettas", "block/algae1")), new Material(InventoryMenu.f_39692_, new ResourceLocation("bettas", "block/algae2")), new Material(InventoryMenu.f_39692_, new ResourceLocation("bettas", "block/algae3")), new Material(InventoryMenu.f_39692_, new ResourceLocation("bettas", "block/algae4"))};
    private static final float[] DOWN = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.03125f, 1.0f};
    private static final float[] NORTH_WEST = new float[]{0.0f, 0.03125f, 0.0f, 0.03125f, 1.03125f, 0.03125f};
    private static final float[] NORTH_EAST = new float[]{0.96875f, 0.03125f, 0.0f, 1.0f, 1.03125f, 0.03125f};
    private static final float[] SOUTH_EAST = new float[]{0.96875f, 0.03125f, 0.96875f, 1.0f, 1.03125f, 1.0f};
    private static final float[] SOUTH_WEST = new float[]{0.0f, 0.03125f, 0.96875f, 0.03125f, 1.03125f, 1.0f};
    private static final float[] SOUTH_UP = new float[]{0.0f, 1.0f, 0.96875f, 1.0f, 1.0312f, 1.0f};
    private static final float[] EAST_UP = new float[]{0.96875f, 1.0f, 0.0f, 1.0f, 1.0312f, 1.0f};
    private static final float[] NORTH_UP = new float[]{0.0f, 1.0f, 0.0f, 1.0f, 1.0312f, 0.03125f};
    private static final float[] WEST_UP = new float[]{0.0f, 1.0f, 0.0f, 0.0312f, 1.03125f, 1.0f};
    private static final float[] NORTH = new float[]{0.03125f, 0.03125f, 0.0f, 0.96875f, 0.96875f, 0.0f};
    private static final float[] EAST = new float[]{1.0f, 0.03125f, 0.03125f, 1.0f, 0.96875f, 0.96875f};
    private static final float[] SOUTH = new float[]{0.03125f, 0.03125f, 1.0f, 0.96875f, 0.96875f, 1.0f};
    private static final float[] WEST = new float[]{0.0f, 0.03125f, 0.03125f, 0.0f, 0.96875f, 0.96875f};
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ItemOverrides overrides;
    private final ItemTransforms transforms;

    public TankModel(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        this.spriteGetter = spriteGetter;
        this.overrides = overrides;
        this.transforms = context.getTransforms();
    }

    private int[] fillData(int[] v1, int[] v2, int[] v3, int[] v4, int[] uvs, int n) {
        int[] data = new int[32];
        data[27] = -1;
        data[19] = -1;
        data[11] = -1;
        data[3] = -1;
        data[20] = 0;
        data[22] = 0;
        data[14] = 0;
        data[6] = 0;
        data[23] = data[31] = n;
        data[15] = data[31];
        data[7] = data[31];
        data[4] = data[12] = uvs[0];
        data[5] = data[29] = uvs[1];
        data[20] = data[28] = uvs[2];
        data[13] = data[21] = uvs[3];
        data[0] = v1[0];
        data[1] = v1[1];
        data[2] = v1[2];
        data[8] = v2[0];
        data[9] = v2[1];
        data[10] = v2[2];
        data[16] = v3[0];
        data[17] = v3[1];
        data[18] = v3[2];
        data[24] = v4[0];
        data[25] = v4[1];
        data[26] = v4[2];
        return data;
    }

    private List<BakedQuad> asShape(float[] v, TextureAtlasSprite sprite) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        int[] uvs = new int[]{Float.floatToRawIntBits(sprite.m_118409_()), Float.floatToRawIntBits(sprite.m_118411_()), Float.floatToRawIntBits(sprite.m_118410_()), Float.floatToRawIntBits(sprite.m_118412_())};
        int[] v1 = new int[]{Float.floatToRawIntBits(v[0]), Float.floatToRawIntBits(v[1]), Float.floatToRawIntBits(v[2])};
        int[] v2 = new int[]{Float.floatToRawIntBits(v[0]), Float.floatToRawIntBits(v[1]), Float.floatToRawIntBits(v[5])};
        int[] v3 = new int[]{Float.floatToRawIntBits(v[0]), Float.floatToRawIntBits(v[4]), Float.floatToRawIntBits(v[2])};
        int[] v4 = new int[]{Float.floatToRawIntBits(v[0]), Float.floatToRawIntBits(v[4]), Float.floatToRawIntBits(v[5])};
        int[] v5 = new int[]{Float.floatToRawIntBits(v[3]), Float.floatToRawIntBits(v[1]), Float.floatToRawIntBits(v[2])};
        int[] v6 = new int[]{Float.floatToRawIntBits(v[3]), Float.floatToRawIntBits(v[1]), Float.floatToRawIntBits(v[5])};
        int[] v7 = new int[]{Float.floatToRawIntBits(v[3]), Float.floatToRawIntBits(v[4]), Float.floatToRawIntBits(v[2])};
        int[] v8 = new int[]{Float.floatToRawIntBits(v[3]), Float.floatToRawIntBits(v[4]), Float.floatToRawIntBits(v[5])};
        quads.add(new BakedQuad(this.fillData(v1, v5, v6, v2, uvs, 33024), -1, Direction.DOWN, sprite, true));
        quads.add(new BakedQuad(this.fillData(v3, v4, v8, v7, uvs, 32512), -1, Direction.UP, sprite, true));
        quads.add(new BakedQuad(this.fillData(v1, v2, v4, v3, uvs, 129), -1, Direction.NORTH, sprite, true));
        quads.add(new BakedQuad(this.fillData(v5, v7, v8, v6, uvs, 127), -1, Direction.SOUTH, sprite, true));
        quads.add(new BakedQuad(this.fillData(v1, v3, v7, v5, uvs, 0x810000), -1, Direction.WEST, sprite, true));
        quads.add(new BakedQuad(this.fillData(v2, v6, v8, v4, uvs, 0x7F0000), -1, Direction.EAST, sprite, true));
        return quads;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        boolean west;
        if (side != null) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        int connected = 0;
        int algae = 0;
        if (extraData.get(TankTile.CONNECTED) != null) {
            connected = (Integer)extraData.get(TankTile.CONNECTED);
        }
        if (extraData.get(TankTile.ALGAE) != null) {
            algae = (Integer)extraData.get(TankTile.ALGAE);
        }
        TextureAtlasSprite algaeSprite = this.spriteGetter.apply(ALGAE_LEVELS[algae]);
        TextureAtlasSprite wallSprite = this.spriteGetter.apply(WALLS);
        boolean up = (connected & 1 << Direction.UP.m_122411_()) == 0;
        boolean down = (connected & 1 << Direction.DOWN.m_122411_()) == 0;
        boolean north = (connected & 1 << Direction.NORTH.m_122411_()) == 0;
        boolean east = (connected & 1 << Direction.EAST.m_122411_()) == 0;
        boolean south = (connected & 1 << Direction.SOUTH.m_122411_()) == 0;
        boolean bl = west = (connected & 1 << Direction.WEST.m_122411_()) == 0;
        if (down) {
            quads.addAll(this.asShape(DOWN, this.spriteGetter.apply(BASE)));
        }
        if (north && east) {
            quads.addAll(this.asShape(NORTH_EAST, wallSprite));
        }
        if (north && west) {
            quads.addAll(this.asShape(NORTH_WEST, wallSprite));
        }
        if (south && east) {
            quads.addAll(this.asShape(SOUTH_EAST, wallSprite));
        }
        if (south && west) {
            quads.addAll(this.asShape(SOUTH_WEST, wallSprite));
        }
        if (north && up) {
            quads.addAll(this.asShape(NORTH_UP, wallSprite));
        }
        if (east && up) {
            quads.addAll(this.asShape(EAST_UP, wallSprite));
        }
        if (south && up) {
            quads.addAll(this.asShape(SOUTH_UP, wallSprite));
        }
        if (west && up) {
            quads.addAll(this.asShape(WEST_UP, wallSprite));
        }
        if (north) {
            quads.addAll(this.asShape(NORTH, algaeSprite));
        }
        if (east) {
            quads.addAll(this.asShape(EAST, algaeSprite));
        }
        if (south) {
            quads.addAll(this.asShape(SOUTH, algaeSprite));
        }
        if (west) {
            quads.addAll(this.asShape(WEST, algaeSprite));
        }
        return quads;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_()});
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.spriteGetter.apply(WALLS);
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public ItemTransforms m_7442_() {
        return this.transforms;
    }
}

