/*
 * Decompiled with CFR 0.152.
 */
package com.dragn.bettas.fish.freshwater.pleco;

import com.dragn.bettas.BettasMain;
import com.dragn.bettas.fish.freshwater.pleco.Variant;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PlecoEntity
extends AbstractFish
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(PlecoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public PlecoEntity(EntityType<? extends PlecoEntity> entity, Level level) {
        super(entity, level);
        this.f_19811_ = true;
    }

    public static boolean checkBettasAquaticsSpawnRules(EntityType<PlecoEntity> entity, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, Random random) {
        int seaLevel = level.m_5736_();
        int depthMin = seaLevel - 13;
        return pos.m_123342_() >= depthMin && pos.m_123342_() <= seaLevel && level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_49990_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_) && level.m_8055_(pos.m_122029_()).m_60713_(Blocks.f_49990_) && level.m_8055_(pos.m_122024_()).m_60713_(Blocks.f_49990_) && level.m_8055_(pos.m_122012_()).m_60713_(Blocks.f_49990_) && level.m_8055_(pos.m_122019_()).m_60713_(Blocks.f_49990_);
    }

    protected SoundEvent m_5699_() {
        return SoundEvents.f_12528_;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (tAnimationState.isMoving()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("swim", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void m_6872_(ItemStack itemStack) {
        super.m_6872_(itemStack);
        CompoundTag compoundTag = itemStack.m_41784_();
        compoundTag.m_128405_("Variant", this.getTexture());
    }

    public ItemStack m_28282_() {
        return ((BucketItem)BettasMain.PLECO_BUCKET.get()).m_7968_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public int getTexture() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setTexture(int texture) {
        this.f_19804_.m_135381_(VARIANT, (Object)texture);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Variant", this.getTexture());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("Variant")) {
            this.setTexture(compoundTag.m_128451_("Variant"));
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (compoundTag != null && compoundTag.m_128441_("Variant")) {
            this.setTexture(compoundTag.m_128451_("Variant"));
        } else {
            this.setTexture(BettasMain.RANDOM.nextInt(Variant.values().length));
        }
        return super.m_6518_(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }
}

