/*
 * Decompiled with CFR 0.152.
 */
package com.dragn.bettas.betta;

import com.dragn.bettas.BettasMain;
import com.dragn.bettas.betta.BasePattern;
import com.dragn.bettas.betta.Model;
import com.dragn.bettas.betta.Palette;
import com.dragn.bettas.betta.TextureGen;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BettaEntity
extends AbstractFish
implements GeoEntity {
    private static final EntityDataAccessor<Integer> MODEL = SynchedEntityData.m_135353_(BettaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BASE_PATTERN = SynchedEntityData.m_135353_(BettaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<int[]> COLOR_MAP = SynchedEntityData.m_135353_(BettaEntity.class, (EntityDataSerializer)((EntityDataSerializer)BettasMain.COLOR_SERIALIZER.get()));
    private ResourceLocation textureLocation = null;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public static boolean checkBettaSpawnRules(EntityType<? extends WaterAnimal> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos pos, RandomSource randomSource) {
        return levelAccessor.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && levelAccessor.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_) && (levelAccessor.m_204166_(pos).m_203565_(Biomes.f_151785_) || WaterAnimal.m_218282_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)randomSource));
    }

    public static int[] generateMap() {
        int[] map = new int[7];
        Palette palette = Palette.getRandomPalette();
        map[0] = palette.getRandomColor();
        map[1] = palette.getRandomShade();
        palette = Palette.getRandomPalette();
        map[2] = palette.getRandomColor();
        map[3] = palette.getRandomShade();
        palette = Palette.getRandomPalette();
        map[4] = palette.getRandomColor();
        map[5] = palette.getRandomShade();
        palette = Palette.getRandomPalette();
        map[6] = palette.getRandomColor();
        return map;
    }

    public BettaEntity(EntityType<? extends AbstractFish> entity, Level level) {
        super(entity, level);
        this.f_19811_ = true;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
    }

    public void m_6872_(ItemStack p_30049_) {
        super.m_6872_(p_30049_);
        CompoundTag compoundtag = p_30049_.m_41784_();
        compoundtag.m_128405_("Model", this.getModel());
        compoundtag.m_128405_("BasePattern", this.getBasePattern());
        compoundtag.m_128385_("ColorMap", this.getColorMap());
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)BettasMain.BETTA_BUCKET.get());
    }

    protected SoundEvent m_5699_() {
        return SoundEvents.f_12528_;
    }

    public int m_5792_() {
        return 1;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (tAnimationState.isMoving()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("swim", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public ResourceLocation getTextureLocation() {
        if (this.textureLocation == null) {
            this.textureLocation = TextureGen.generateTexture(BasePattern.patternFromOrdinal(this.getBasePattern()), this.getColorMap());
        }
        return this.textureLocation;
    }

    public int getModel() {
        return (Integer)this.f_19804_.m_135370_(MODEL);
    }

    public int getBasePattern() {
        return (Integer)this.f_19804_.m_135370_(BASE_PATTERN);
    }

    public int[] getColorMap() {
        return (int[])this.f_19804_.m_135370_(COLOR_MAP);
    }

    public void setModel(int model) {
        this.f_19804_.m_135381_(MODEL, (Object)model);
    }

    public void setBasePattern(int baseTexture) {
        this.f_19804_.m_135381_(BASE_PATTERN, (Object)baseTexture);
    }

    public void setColorMap(int[] colorMap) {
        this.f_19804_.m_135381_(COLOR_MAP, (Object)colorMap);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("Model")) {
            this.setModel(compoundTag.m_128451_("Model"));
        }
        if (compoundTag.m_128441_("BasePattern")) {
            this.setBasePattern(compoundTag.m_128451_("BasePattern"));
        }
        if (compoundTag.m_128441_("ColorMap")) {
            this.setColorMap(compoundTag.m_128465_("ColorMap"));
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Model", this.getModel());
        compoundTag.m_128405_("BasePattern", this.getBasePattern());
        compoundTag.m_128385_("ColorMap", this.getColorMap());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (compoundTag != null && compoundTag.m_128441_("Model") && compoundTag.m_128441_("BasePattern") && compoundTag.m_128441_("ColorMap")) {
            this.setModel(compoundTag.m_128451_("Model"));
            this.setBasePattern(compoundTag.m_128451_("BasePattern"));
            this.setColorMap(compoundTag.m_128465_("ColorMap"));
        } else {
            this.setModel(BettasMain.RANDOM.nextInt(Model.values().length));
            this.setBasePattern(BettasMain.RANDOM.nextInt(BasePattern.values().length));
            this.setColorMap(BettaEntity.generateMap());
        }
        return super.m_6518_(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MODEL, (Object)0);
        this.f_19804_.m_135372_(BASE_PATTERN, (Object)0);
        this.f_19804_.m_135372_(COLOR_MAP, (Object)new int[7]);
    }
}

