/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.peripheral.wand.ProtoPortalSide;
import qouteall.q_misc_util.my_util.Circle;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.WithDim;

public class ProtoPortal {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    public ProtoPortalSide firstSide;
    @Nullable
    public ProtoPortalSide secondSide;

    public ProtoPortal copy() {
        ProtoPortal newPortal = new ProtoPortal();
        newPortal.firstSide = this.firstSide == null ? null : this.firstSide.copy();
        newPortal.secondSide = this.secondSide == null ? null : this.secondSide.copy();
        return newPortal;
    }

    public void reset() {
        this.firstSide = null;
        this.secondSide = null;
    }

    public boolean isComplete() {
        return this.firstSide != null && this.secondSide != null && this.secondSide.isComplete();
    }

    public boolean isValidPlacement() {
        if (this.firstSide != null) {
            if (!this.firstSide.isValidPlacement(null)) {
                return false;
            }
            if (this.secondSide != null) {
                Validate.isTrue((boolean)this.firstSide.isComplete());
                double heightDivWidth = this.firstSide.getHeightDivWidth();
                return this.secondSide.isValidPlacement(heightDivWidth);
            }
        }
        return true;
    }

    @Nullable
    public class_5321<class_1937> getCursorConstraintDim() {
        if (this.firstSide != null && !this.firstSide.isComplete()) {
            return this.firstSide.dimension;
        }
        if (this.secondSide != null && !this.secondSide.isComplete()) {
            return this.secondSide.dimension;
        }
        return null;
    }

    @Nullable
    public WithDim<Plane> getCursorConstraintPlane() {
        WithDim<Plane> plane;
        if (this.firstSide != null && (plane = this.firstSide.getCursorConstraintPlane()) != null) {
            return plane;
        }
        if (this.secondSide != null && (plane = this.secondSide.getCursorConstraintPlane()) != null) {
            return plane;
        }
        return null;
    }

    @Nullable
    public WithDim<Circle> getCursorConstraintCircle() {
        if (this.firstSide != null && this.secondSide != null) {
            double heightDivWidth = this.firstSide.getHeightDivWidth();
            return this.secondSide.getCursorConstraintCircle(heightDivWidth);
        }
        return null;
    }

    public boolean tryPlaceCursor(class_5321<class_1937> dimension, class_243 pos) {
        if (this.firstSide == null) {
            this.firstSide = new ProtoPortalSide(dimension, pos);
            return true;
        }
        if (!this.firstSide.isComplete()) {
            if (dimension != this.firstSide.dimension) {
                return false;
            }
            this.firstSide.placeCursor(pos);
            return true;
        }
        if (this.secondSide == null) {
            this.secondSide = new ProtoPortalSide(dimension, pos);
            return true;
        }
        if (!this.secondSide.isComplete()) {
            if (dimension != this.secondSide.dimension) {
                LOGGER.error("cursor dimension mismatch {} {}", dimension, this.secondSide.dimension);
                return false;
            }
            this.secondSide.placeCursor(pos);
            return true;
        }
        return false;
    }

    public void undo() {
        if (this.secondSide != null) {
            this.secondSide = this.secondSide.undo();
            return;
        }
        if (this.firstSide != null) {
            this.firstSide = this.firstSide.undo();
            return;
        }
    }

    @Nullable
    public class_5250 getPromptMessage(@Nullable ProtoPortal pendingState) {
        if (this.firstSide == null) {
            return class_2561.method_43469((String)"imm_ptl.wand.first_side_left_bottom", (Object[])new Object[]{class_310.method_1551().field_1690.field_1904.method_16007()});
        }
        class_5250 undoPrompt = class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43469((String)"imm_ptl.wand.left_click_to_undo", (Object[])new Object[]{class_310.method_1551().field_1690.field_1886.method_16007()}));
        if (this.firstSide.rightBottom == null) {
            String widthStr = pendingState == null ? "?" : String.format("%.3f", Objects.requireNonNull(pendingState.firstSide).getWidth());
            return class_2561.method_43469((String)"imm_ptl.wand.first_side_right_bottom", (Object[])new Object[]{widthStr}).method_10852((class_2561)undoPrompt);
        }
        if (this.firstSide.leftTop == null) {
            String widthStr = pendingState == null ? "?" : String.format("%.3f", Objects.requireNonNull(pendingState.firstSide).getWidth());
            String heightStr = pendingState == null ? "?" : String.format("%.3f", Objects.requireNonNull(pendingState.firstSide).getHeight());
            return class_2561.method_43469((String)"imm_ptl.wand.first_side_left_up", (Object[])new Object[]{widthStr, heightStr}).method_10852((class_2561)undoPrompt);
        }
        if (this.secondSide == null) {
            return class_2561.method_43471((String)"imm_ptl.wand.second_side_left_bottom").method_10852((class_2561)undoPrompt);
        }
        if (this.secondSide.rightBottom == null) {
            String widthStr = "?";
            String heightStr = "?";
            String scaleStr = "?";
            if (pendingState != null) {
                Validate.notNull((Object)pendingState.firstSide);
                Validate.notNull((Object)pendingState.secondSide);
                double width = pendingState.secondSide.getWidth();
                double heightDivWidth = pendingState.firstSide.getHeightDivWidth();
                double height = width * heightDivWidth;
                double scale = width / pendingState.firstSide.getWidth();
                widthStr = String.format("%.3f", width);
                heightStr = String.format("%.3f", height);
                scaleStr = String.format("%.3f", scale);
            }
            return class_2561.method_43469((String)"imm_ptl.wand.second_side_right_bottom", (Object[])new Object[]{widthStr, heightStr, scaleStr}).method_10852((class_2561)undoPrompt);
        }
        if (this.secondSide.leftTop == null) {
            return class_2561.method_43471((String)"imm_ptl.wand.second_side_left_up").method_10852((class_2561)undoPrompt);
        }
        return null;
    }

    public Stage getStage() {
        if (this.firstSide == null) {
            return Stage.PlacingFirstSideLeftBottom;
        }
        if (this.firstSide.rightBottom == null) {
            return Stage.PlacingFirstSideRightBottom;
        }
        if (this.firstSide.leftTop == null) {
            return Stage.PlacingFirstSideLeftTop;
        }
        if (this.secondSide == null) {
            return Stage.PlacingSecondSideLeftBottom;
        }
        if (this.secondSide.rightBottom == null) {
            return Stage.PlacingSecondSideRightBottom;
        }
        if (this.secondSide.leftTop == null) {
            return Stage.PlacingSecondSideLeftTop;
        }
        return Stage.Completed;
    }

    public static enum Stage {
        PlacingFirstSideLeftBottom,
        PlacingFirstSideRightBottom,
        PlacingFirstSideLeftTop,
        PlacingSecondSideLeftBottom,
        PlacingSecondSideRightBottom,
        PlacingSecondSideLeftTop,
        Completed;

    }
}

