/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.mc_utils.WireRenderingHelper;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.PortalUtils;
import qouteall.imm_ptl.core.portal.animation.ClientPortalAnimationManagement;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.portal.util.PortalLocalXYNormalized;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.peripheral.ImmPtlCustomOverlay;
import qouteall.imm_ptl.peripheral.wand.PortalCorner;
import qouteall.imm_ptl.peripheral.wand.PortalWandInteraction;
import qouteall.imm_ptl.peripheral.wand.PortalWandItem;
import qouteall.imm_ptl.peripheral.wand.WandUtil;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Sphere;
import qouteall.q_misc_util.my_util.WithDim;
import qouteall.q_misc_util.my_util.animation.Animated;
import qouteall.q_misc_util.my_util.animation.RenderedPlane;
import qouteall.q_misc_util.my_util.animation.RenderedPoint;

@Environment(value=EnvType.CLIENT)
public class ClientPortalWandPortalDrag {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static UUID selectedPortalId;
    @Nullable
    private static PortalLocalXYNormalized lockedAnchor;
    private static boolean lockWidth;
    private static boolean lockHeight;
    @Nullable
    private static SelectionStatus selectionStatus;
    public static Animated<RenderedPoint> cursor;
    public static Animated<UnilateralPortalState> renderedRect;
    public static Animated<RenderedPlane> renderedPlane;
    private static Animated<RenderedPoint> renderedLockedAnchor;
    private static Animated<Double> renderedWidthLineSegment;
    private static Animated<Double> renderedHeightLineSegment;
    private static Animated<Double> renderedWidthLock;
    private static Animated<Double> renderedHeightLock;
    @Nullable
    public static DraggingContext draggingContext;
    private static boolean isUndoing;
    private static final int colorOfCursor = -16515844;
    private static final int colorOfRect1 = -1309700;
    private static final int colorOfRect2 = -218877;
    private static final int colorOfPlane = -1;
    private static final int colorOfLock = -1;
    private static final int colorOfWidthLine = -16516018;
    private static final int colorOfHeightLine = -198653;
    private static final int colorOfCursorInLock = -384160;
    private static final int colorOfSphere = -1;

    public static void init() {
        ClientPortalAnimationManagement.clientAnimationUpdateSignal.connect(ClientPortalWandPortalDrag::updateDraggedPortalAnimation);
    }

    public static void reset() {
        selectedPortalId = null;
        ClientPortalWandPortalDrag.clearLock();
        selectionStatus = null;
        cursor.clearTarget();
        renderedPlane.clearTarget();
        renderedRect.clearTarget();
        draggingContext = null;
        isUndoing = false;
    }

    public static void onLeftClick() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (ClientPortalWandPortalDrag.isDragging()) {
            ClientPortalWandPortalDrag.undoDragging();
        } else if (selectionStatus != null) {
            if (ClientPortalWandPortalDrag.selectionStatus.selectsHorizontalEdge) {
                lockWidth = !lockWidth;
                ImmPtlCustomOverlay.putText((class_2561)class_2561.method_43471((String)(lockWidth ? "imm_ptl.wand.width_locked" : "imm_ptl.wand.width_unlocked")).method_27692(class_124.field_1065), 3.0, "0_alert");
            } else if (ClientPortalWandPortalDrag.selectionStatus.selectsVerticalEdge) {
                lockHeight = !lockHeight;
                ImmPtlCustomOverlay.putText((class_2561)class_2561.method_43471((String)(lockHeight ? "imm_ptl.wand.height_locked" : "imm_ptl.wand.height_unlocked")).method_27692(class_124.field_1065), 3.0, "0_alert");
            } else {
                PortalLocalXYNormalized selectedAnchor = ClientPortalWandPortalDrag.selectionStatus.selectedAnchor;
                if (lockedAnchor != null && lockedAnchor.isCloseTo(selectedAnchor, 0.01)) {
                    lockedAnchor = null;
                    ImmPtlCustomOverlay.putText((class_2561)class_2561.method_43471((String)"imm_ptl.wand.anchor_unlocked").method_27692(class_124.field_1065), 3.0, "0_alert");
                } else {
                    ImmPtlCustomOverlay.putText((class_2561)class_2561.method_43471((String)(lockedAnchor != null ? "imm_ptl.wand.anchor_lock_moved" : "imm_ptl.wand.anchor_locked")).method_27692(class_124.field_1065), 3.0, "0_alert");
                    lockedAnchor = selectedAnchor;
                }
            }
        }
    }

    public static void onRightClick() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (ClientPortalWandPortalDrag.isDragging()) {
            return;
        }
        if (isUndoing) {
            return;
        }
        ClientPortalWandPortalDrag.startDragging();
    }

    public static void tick() {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return;
        }
        if (ClientPortalWandPortalDrag.isDragging() && player.method_5998(class_1268.field_5808).method_7909() != PortalWandItem.instance && player.method_5998(class_1268.field_5810).method_7909() != PortalWandItem.instance) {
            LOGGER.info("Undo dragging because the player is not holding the wand");
            ClientPortalWandPortalDrag.undoDragging();
        }
    }

    public static boolean isDragging() {
        return draggingContext != null;
    }

    public static void updateDisplay() {
        Pair rectTurning;
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return;
        }
        if (!minecraft.field_1690.field_1904.method_1434()) {
            isUndoing = false;
        }
        if (isUndoing) {
            return;
        }
        if (draggingContext != null) {
            ClientPortalWandPortalDrag.handleDragging(player, draggingContext);
            return;
        }
        Portal originalSelectedPortal = ClientPortalWandPortalDrag.getSelectedPortal();
        if (originalSelectedPortal == null) {
            ClientPortalWandPortalDrag.reset();
        }
        class_243 eyePos = player.method_5836(RenderStates.getPartialTick());
        class_243 viewVec = player.method_5720();
        Pair rayTraceResult = PortalUtils.lenientRayTracePortals((class_1937)player.method_37908(), (class_243)eyePos, (class_243)eyePos.method_1019(viewVec.method_1021(64.0)), (boolean)false, p -> true, (double)1.0).orElse(null);
        if (rayTraceResult == null) {
            selectionStatus = null;
            cursor.clearTarget();
            renderedPlane.clearTarget();
            ImmPtlCustomOverlay.putText((class_2561)class_2561.method_43471((String)"imm_ptl.wand.select_portal"));
            if (originalSelectedPortal == null) {
                renderedRect.clearTarget();
            } else {
                renderedRect.setTarget((Object)originalSelectedPortal.getThisSideState(), Helper.secondToNano((double)1.0));
            }
            return;
        }
        Portal portal = (Portal)rayTraceResult.getFirst();
        class_243 hitPos = (class_243)rayTraceResult.getSecond();
        if (selectedPortalId == null) {
            selectedPortalId = portal.method_5667();
        } else if (!Objects.equals(selectedPortalId, portal.method_5667())) {
            if (originalSelectedPortal != null && Portal.isFlippedPortal((Portal)originalSelectedPortal, (Portal)portal)) {
                class_243 lockedAnchorPos;
                if (lockedAnchor != null && !(lockedAnchor = PortalLocalXYNormalized.fromPos((Portal)portal, (class_243)(lockedAnchorPos = lockedAnchor.getPos(originalSelectedPortal)))).isValid()) {
                    lockedAnchor = null;
                }
            } else {
                selectionStatus = null;
                if (ClientPortalWandPortalDrag.hasLock()) {
                    ImmPtlCustomOverlay.putText((class_2561)class_2561.method_43471((String)"imm_ptl.wand.lock_cleared").method_27692(class_124.field_1065), 5.0, "1_alert");
                    ClientPortalWandPortalDrag.clearLock();
                }
            }
            selectedPortalId = portal.method_5667();
        }
        PortalLocalXYNormalized rawSelection = PortalLocalXYNormalized.fromPos((Portal)portal, (class_243)hitPos);
        int cursorAlignment = IPConfig.getConfig().portalWandCursorAlignment;
        PortalLocalXYNormalized selection = cursorAlignment == 0 ? rawSelection.clamp() : rawSelection.clamp().snapToGrid(cursorAlignment);
        boolean selectsHorizontalEdge = rawSelection.ny() < 0.0 || rawSelection.ny() > 1.0;
        boolean selectsVerticalEdge = rawSelection.nx() < 0.0 || rawSelection.nx() > 1.0;
        selectionStatus = new SelectionStatus(selection, selectsHorizontalEdge, selectsVerticalEdge);
        class_243 cursorPos = selection.getPos(portal);
        cursor.setTarget((Object)new RenderedPoint(new WithDim(player.method_37908().method_27983(), (Object)cursorPos), 1.0), Helper.secondToNano((double)0.5));
        UnilateralPortalState lastRenderedRect = (UnilateralPortalState)renderedRect.getCurrent();
        UnilateralPortalState newRenderedRect = portal.getThisSideState();
        if (lastRenderedRect != null && ((UnilateralPortalState.RectInvariant)(rectTurning = lastRenderedRect.turnToClosestTo(newRenderedRect.orientation())).getFirst()).switchesWidthAndHeight()) {
            Animated<Double> temp = renderedWidthLineSegment;
            renderedWidthLineSegment = renderedHeightLineSegment;
            renderedHeightLineSegment = temp;
        }
        renderedRect.setTarget((Object)newRenderedRect, Helper.secondToNano((double)1.0));
        Pair<Plane, class_5250> planeInfo = ClientPortalWandPortalDrag.getPlayerFacingPlaneAligned((class_1657)player, cursorPos, portal);
        if (selectsHorizontalEdge) {
            ImmPtlCustomOverlay.putText((class_2561)class_2561.method_43469((String)"imm_ptl.wand.lock_width", (Object[])new Object[]{minecraft.field_1690.field_1886.method_16007()}));
        } else if (selectsVerticalEdge) {
            ImmPtlCustomOverlay.putText((class_2561)class_2561.method_43469((String)"imm_ptl.wand.lock_height", (Object[])new Object[]{minecraft.field_1690.field_1886.method_16007()}));
        } else {
            class_5250 planeText = class_2561.method_43469((String)"imm_ptl.wand.on_plane", (Object[])new Object[]{((class_5250)planeInfo.getSecond()).method_27692(class_124.field_1065)});
            ImmPtlCustomOverlay.putText((class_2561)class_2561.method_43469((String)"imm_ptl.wand.pre_drag", (Object[])new Object[]{minecraft.field_1690.field_1886.method_16007(), minecraft.field_1690.field_1904.method_16007(), planeText}));
        }
    }

    private static boolean hasLock() {
        return lockedAnchor != null || lockWidth || lockHeight;
    }

    private static void clearLock() {
        lockedAnchor = null;
        lockWidth = false;
        lockHeight = false;
        renderedLockedAnchor.clearTarget();
        renderedWidthLineSegment.clearTarget();
        renderedHeightLineSegment.clearTarget();
        renderedWidthLock.clearTarget();
        renderedHeightLock.clearTarget();
    }

    private static void handleDragging(class_746 player, DraggingContext draggingContext) {
        class_243 eyePos = player.method_5836(RenderStates.getPartialTick());
        class_243 viewVec = player.method_5720();
        class_5321 currDim = player.method_37908().method_27983();
        if (draggingContext.dimension != currDim) {
            ClientPortalWandPortalDrag.stopDragging();
            return;
        }
        class_310 minecraft = class_310.method_1551();
        if (!minecraft.field_1690.field_1904.method_1434()) {
            ClientPortalWandPortalDrag.stopDragging();
            return;
        }
        class_243 cursorPos = null;
        Plane plane = draggingContext.limitingPlane();
        Sphere sphere = draggingContext.limitingSphere;
        int alignment = IPConfig.getConfig().portalWandCursorAlignment;
        if (plane != null) {
            cursorPos = plane.rayTrace(eyePos, viewVec);
            if (cursorPos != null) {
                cursorPos = ClientPortalWandPortalDrag.align(cursorPos, alignment);
                cursorPos = plane.getProjection(cursorPos);
            }
        } else if (sphere != null && (cursorPos = sphere.rayTrace(eyePos, viewVec)) != null) {
            cursorPos = ClientPortalWandPortalDrag.align(cursorPos, alignment);
            cursorPos = sphere.projectToSphere(cursorPos);
        }
        if (cursorPos != null) {
            class_243 originalCursorTarget = (class_243)((RenderedPoint)cursor.getTarget()).pos().value();
            if (originalCursorTarget == null) {
                return;
            }
            if (originalCursorTarget.method_1022(cursorPos) > 1.0E-6) {
                cursor.setTarget((Object)new RenderedPoint(new WithDim(currDim, (Object)cursorPos), 1.0), Helper.secondToNano((double)0.2));
                ClientPortalWandPortalDrag.onDrag(cursorPos, draggingContext);
            }
        }
        class_5250 draggingText = class_2561.method_43471((String)"imm_ptl.wand.dragging");
        class_5250 planeText = draggingContext.planeText() == null ? class_2561.method_43470((String)"") : class_2561.method_43469((String)"imm_ptl.wand.on_plane", (Object[])new Object[]{draggingContext.planeText()});
        class_5250 undoPrompt = class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43469((String)"imm_ptl.wand.left_click_to_undo", (Object[])new Object[]{minecraft.field_1690.field_1886.method_16007()}));
        class_5250 cursorPosText = cursorPos == null ? class_2561.method_43470((String)"") : class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43469((String)"imm_ptl.wand.cursor_pos", (Object[])new Object[]{"%.3f".formatted(cursorPos.field_1352), "%.3f".formatted(cursorPos.field_1351), "%.3f".formatted(cursorPos.field_1350)}));
        Portal portal = WandUtil.getClientPortalByUUID(draggingContext.portalId());
        boolean shouldDisplaySize = lockedAnchor != null;
        PortalState animationEndingState = ClientPortalWandPortalDrag.getAnimationEndingState();
        class_5250 portalSizeText = portal != null && shouldDisplaySize && animationEndingState != null ? class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"imm_ptl.wand.portal_size", (Object[])new Object[]{"%.3f".formatted(animationEndingState.width), "%.3f".formatted(animationEndingState.height), "%.3f".formatted(animationEndingState.scaling)})) : class_2561.method_43470((String)"");
        ImmPtlCustomOverlay.putText((class_2561)draggingText.method_10852((class_2561)planeText).method_10852((class_2561)undoPrompt).method_10852((class_2561)cursorPosText).method_10852((class_2561)portalSizeText));
    }

    private static class_243 align(class_243 pos, int alignment) {
        if (alignment == 0) {
            return pos;
        }
        return new class_243((double)Math.round(pos.method_10216() * (double)alignment) / (double)alignment, (double)Math.round(pos.method_10214() * (double)alignment) / (double)alignment, (double)Math.round(pos.method_10215() * (double)alignment) / (double)alignment);
    }

    private static void startDragging() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (ClientPortalWandPortalDrag.isDragging()) {
            LOGGER.error("start dragging when already dragging");
            return;
        }
        if (!class_310.method_1551().field_1690.field_1904.method_1434()) {
            LOGGER.error("start dragging when not right clicking");
            return;
        }
        Portal portal = ClientPortalWandPortalDrag.getSelectedPortal();
        if (portal == null) {
            return;
        }
        RenderedPoint cursorTarget = (RenderedPoint)cursor.getTarget();
        if (cursorTarget == null) {
            return;
        }
        WithDim cursorTargetPos = cursorTarget.pos();
        if (cursorTargetPos == null) {
            return;
        }
        class_243 cursorPos = (class_243)cursorTargetPos.value();
        if (cursorPos == null) {
            return;
        }
        if (selectionStatus == null) {
            return;
        }
        PortalLocalXYNormalized selectedAnchor = ClientPortalWandPortalDrag.selectionStatus.selectedAnchor;
        if (lockedAnchor != null && lockedAnchor.isCloseTo(selectedAnchor, 0.01)) {
            return;
        }
        PortalWandInteraction.DraggingInfo draggingInfo = new PortalWandInteraction.DraggingInfo(lockedAnchor, selectedAnchor, null, lockWidth, lockHeight);
        class_5321 currDim = player.method_37908().method_27983();
        Pair<Plane, class_5250> info = ClientPortalWandPortalDrag.getPlayerFacingPlaneAligned((class_1657)player, cursorPos, portal);
        Plane plane = (Plane)info.getFirst();
        renderedPlane.setTarget((Object)new RenderedPlane(new WithDim(currDim, (Object)plane), 1.0), Helper.secondToNano((double)0.5));
        draggingContext = new DraggingContext((class_5321<class_1937>)currDim, portal.method_5667(), plane, null, draggingInfo, ((class_5250)info.getSecond()).method_27692(class_124.field_1065), portal.getPortalState());
    }

    private static void stopDragging() {
        draggingContext = null;
        renderedPlane.clearTarget();
        renderedRect.clearTarget();
        McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.finishDragging", (Object[])new Object[0]);
    }

    private static void undoDragging() {
        McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.undoDrag", (Object[])new Object[0]);
        renderedPlane.clearTarget();
        renderedRect.clearTarget();
        draggingContext = null;
        isUndoing = true;
    }

    private static void onDrag(class_243 cursorPos, DraggingContext draggingContext) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        Portal portal = WandUtil.getClientPortalByUUID(draggingContext.portalId());
        if (portal == null) {
            LOGGER.error("cannot find portal to drag {}", (Object)selectedPortalId);
            ClientPortalWandPortalDrag.reset();
            return;
        }
        PortalWandInteraction.DraggingInfo draggingInfo = draggingContext.draggingInfo();
        UnilateralPortalState newThisSideState = PortalWandInteraction.applyDrag(draggingContext.originalPortalState().getThisSideState(), cursorPos, draggingInfo, true);
        boolean isValid = PortalWandInteraction.validateDraggedPortalState(draggingContext.originalPortalState(), newThisSideState, (class_1657)player);
        if (isValid) {
            McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.requestApplyDrag", (Object[])new Object[]{selectedPortalId, cursorPos, draggingInfo});
            ImmPtlCustomOverlay.remove("1_invalid_dragging");
        } else {
            ImmPtlCustomOverlay.putText((class_2561)class_2561.method_43471((String)"imm_ptl.wand.invalid_dragging").method_27692(class_124.field_1061), 3.0, "1_invalid_dragging");
        }
    }

    @Nullable
    private static Portal getSelectedPortal() {
        return WandUtil.getClientPortalByUUID(selectedPortalId);
    }

    private static Pair<Plane, class_5250> getPlayerFacingPlaneAligned(class_1657 player, class_243 cursorPos, Portal portal) {
        ArrayList<Pair> candidates = new ArrayList<Pair>();
        class_243 X = new class_243(1.0, 0.0, 0.0);
        class_243 Y = new class_243(0.0, 1.0, 0.0);
        class_243 Z = new class_243(0.0, 0.0, 1.0);
        candidates.add(Pair.of((Object)new Plane(cursorPos, X), (Object)class_2561.method_43471((String)"imm_ptl.wand.plane.x")));
        candidates.add(Pair.of((Object)new Plane(cursorPos, Y), (Object)class_2561.method_43471((String)"imm_ptl.wand.plane.y")));
        candidates.add(Pair.of((Object)new Plane(cursorPos, Z), (Object)class_2561.method_43471((String)"imm_ptl.wand.plane.z")));
        Predicate<class_243> isOrthodox = p -> Math.abs(p.method_1026(X)) > 0.9999 || Math.abs(p.method_1026(Y)) > 0.9999 || Math.abs(p.method_1026(Z)) > 0.9999;
        if (!isOrthodox.test(portal.axisW)) {
            candidates.add(Pair.of((Object)new Plane(cursorPos, portal.axisW), (Object)class_2561.method_43471((String)"imm_ptl.wand.plane.portal_x")));
        }
        if (!isOrthodox.test(portal.axisH)) {
            candidates.add(Pair.of((Object)new Plane(cursorPos, portal.axisH), (Object)class_2561.method_43471((String)"imm_ptl.wand.plane.portal_y")));
        }
        if (!isOrthodox.test(portal.getNormal())) {
            candidates.add(Pair.of((Object)new Plane(cursorPos, portal.getNormal()), (Object)class_2561.method_43471((String)"imm_ptl.wand.plane.portal_z")));
        }
        class_243 viewVec = player.method_5720();
        return Stream.concat(candidates.stream(), candidates.stream().map(p -> Pair.of((Object)((Plane)p.getFirst()).getOpposite(), (Object)((class_5250)p.getSecond())))).min(Comparator.comparingDouble(p -> ((Plane)p.getFirst()).normal().method_1026(viewVec))).orElseThrow();
    }

    public static void render(class_4587 matrixStack, class_4597.class_4598 bufferSource, double camX, double camY, double camZ) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (PortalRendering.isRendering()) {
            return;
        }
        renderedWidthLock.setTarget((Object)(lockWidth ? 1.0 : 0.0), Helper.secondToNano((double)0.5));
        renderedHeightLock.setTarget((Object)(lockHeight ? 1.0 : 0.0), Helper.secondToNano((double)0.5));
        renderedWidthLineSegment.setTarget((Object)(lockWidth || selectionStatus != null && ClientPortalWandPortalDrag.selectionStatus.selectsHorizontalEdge && draggingContext == null ? 1.0 : 0.0), Helper.secondToNano((double)0.5));
        renderedHeightLineSegment.setTarget((Object)(lockHeight || selectionStatus != null && ClientPortalWandPortalDrag.selectionStatus.selectsVerticalEdge && draggingContext == null ? 1.0 : 0.0), Helper.secondToNano((double)0.5));
        class_5321 currDim = player.method_37908().method_27983();
        class_243 cameraPos = new class_243(camX, camY, camZ);
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23594());
        class_243 renderedCursor = ClientPortalWandPortalDrag.getCursorToRender();
        if (renderedCursor != null) {
            WireRenderingHelper.renderSmallCubeFrame((class_4588)vertexConsumer, (class_243)cameraPos, (class_243)renderedCursor, (int)-16515844, (double)((RenderedPoint)cursor.getCurrent()).scale(), (class_4587)matrixStack);
        }
        Portal portal = null;
        if (draggingContext != null) {
            portal = WandUtil.getClientPortalByUUID(ClientPortalWandPortalDrag.draggingContext.portalId);
        }
        if (portal == null && selectedPortalId != null) {
            portal = ClientPortalWandPortalDrag.getSelectedPortal();
        }
        UnilateralPortalState rect = null;
        if (draggingContext != null) {
            if (portal != null) {
                rect = portal.getThisSideState();
                ClientPortalWandPortalDrag.renderRect(matrixStack, cameraPos, vertexConsumer, rect);
                renderedRect.setTarget((Object)rect, 0L);
            }
        } else {
            rect = (UnilateralPortalState)renderedRect.getCurrent();
            if (rect != null && rect.dimension() == currDim) {
                ClientPortalWandPortalDrag.renderRect(matrixStack, cameraPos, vertexConsumer, rect);
            }
        }
        if (lockedAnchor != null && portal != null) {
            renderedLockedAnchor.setTarget((Object)new RenderedPoint(new WithDim(portal.getOriginDim(), (Object)lockedAnchor.getPos(portal)), 1.0), Helper.secondToNano((double)0.5));
        } else {
            renderedLockedAnchor.clearTarget();
        }
        if (portal != null) {
            RenderedPoint current = (RenderedPoint)renderedLockedAnchor.getCurrent();
            if (current != null && current.pos() != null && current.pos().dimension() == currDim) {
                class_243 lockPos = (class_243)current.pos().value();
                if (draggingContext != null && lockedAnchor != null) {
                    lockPos = lockedAnchor.getPos(portal);
                }
                double lockExtraScale = ClientPortalWandPortalDrag.getLockExtraScale(portal.getThisSideState());
                matrixStack.method_22903();
                matrixStack.method_22905(0.5f, 0.5f, 0.5f);
                WireRenderingHelper.renderLockShape((class_4588)vertexConsumer, (class_243)cameraPos, (class_243)lockPos, (double)(current.scale() * lockExtraScale), (int)-1, (class_4587)matrixStack);
                matrixStack.method_22909();
                WireRenderingHelper.renderSmallCubeFrame((class_4588)vertexConsumer, (class_243)cameraPos, (class_243)lockPos, (int)-384160, (double)(current.scale() * lockExtraScale), (class_4587)matrixStack);
            }
            ClientPortalWandPortalDrag.renderWidthHeightLock(matrixStack, cameraPos, vertexConsumer, portal.getThisSideState());
        }
        if (rect != null) {
            ClientPortalWandPortalDrag.renderWidthHeightLineSegment(matrixStack, cameraPos, vertexConsumer, rect);
        }
        class_4588 debugLineStripConsumer = bufferSource.getBuffer(class_1921.method_49043((double)1.0));
        RenderedPlane plane = (RenderedPlane)renderedPlane.getCurrent();
        if (plane != null && plane.plane() != null && plane.plane().dimension() == currDim) {
            Plane planeValue = (Plane)plane.plane().value();
            if (renderedCursor != null) {
                planeValue = planeValue.getParallelPlane(renderedCursor);
            }
            WireRenderingHelper.renderPlane((class_4588)debugLineStripConsumer, (class_243)cameraPos, (Plane)planeValue, (double)plane.scale(), (int)-1, (class_4587)matrixStack);
        }
    }

    @Nullable
    private static class_243 getCursorToRender() {
        if (draggingContext != null) {
            Portal portal = WandUtil.getClientPortalByUUID(ClientPortalWandPortalDrag.draggingContext.portalId);
            if (portal != null) {
                return ClientPortalWandPortalDrag.draggingContext.draggingInfo().draggingAnchor.getPos(portal);
            }
            return null;
        }
        RenderedPoint renderedPoint = (RenderedPoint)cursor.getCurrent();
        assert (renderedPoint != null);
        WithDim pos = renderedPoint.pos();
        if (pos == null) {
            return null;
        }
        return (class_243)pos.value();
    }

    public static void renderRect(class_4587 matrixStack, class_243 cameraPos, class_4588 vertexConsumer, UnilateralPortalState rect) {
        WireRenderingHelper.renderRectFrameFlow((class_4587)matrixStack, (class_243)cameraPos, (class_4588)vertexConsumer, (UnilateralPortalState)rect, (int)-1309700, (int)-218877);
    }

    private static double getLockExtraScale(UnilateralPortalState rect) {
        return Math.sqrt(rect.width() * rect.height()) * 0.2;
    }

    private static void renderWidthHeightLock(class_4587 matrixStack, class_243 cameraPos, class_4588 vertexConsumer, UnilateralPortalState rect) {
        Double heightLockAnim;
        matrixStack.method_22903();
        matrixStack.method_22905(0.5f, 0.5f, 0.5f);
        double lockPadding = 0.1;
        double lockExtraScale = ClientPortalWandPortalDrag.getLockExtraScale(rect);
        Double widthLockAnim = (Double)renderedWidthLock.getCurrent();
        if (widthLockAnim != null && widthLockAnim > 0.001) {
            WireRenderingHelper.renderLockShape((class_4588)vertexConsumer, (class_243)cameraPos, (class_243)new PortalLocalXYNormalized(0.5, -lockPadding).getPos(rect), (double)(widthLockAnim * lockExtraScale), (int)-16516018, (class_4587)matrixStack);
            WireRenderingHelper.renderLockShape((class_4588)vertexConsumer, (class_243)cameraPos, (class_243)new PortalLocalXYNormalized(0.5, 1.0 + lockPadding).getPos(rect), (double)(widthLockAnim * lockExtraScale), (int)-16516018, (class_4587)matrixStack);
        }
        if ((heightLockAnim = (Double)renderedHeightLock.getCurrent()) != null && heightLockAnim > 0.001) {
            WireRenderingHelper.renderLockShape((class_4588)vertexConsumer, (class_243)cameraPos, (class_243)new PortalLocalXYNormalized(-lockPadding, 0.5).getPos(rect), (double)(heightLockAnim * lockExtraScale), (int)-198653, (class_4587)matrixStack);
            WireRenderingHelper.renderLockShape((class_4588)vertexConsumer, (class_243)cameraPos, (class_243)new PortalLocalXYNormalized(1.0 + lockPadding, 0.5).getPos(rect), (double)(heightLockAnim * lockExtraScale), (int)-198653, (class_4587)matrixStack);
        }
        matrixStack.method_22909();
    }

    private static void renderWidthHeightLineSegment(class_4587 matrixStack, class_243 cameraPos, class_4588 vertexConsumer, UnilateralPortalState rect) {
        Double heightLineAnim;
        matrixStack.method_22903();
        matrixStack.method_22905(0.5f, 0.5f, 0.5f);
        double padding1 = 0.04;
        double padding2 = padding1 + 0.02;
        double padding3 = padding2 + 0.03;
        Double widthLineAnim = (Double)renderedWidthLineSegment.getCurrent();
        if (widthLineAnim != null && widthLineAnim > 0.001) {
            double rangeStart = 0.5 - widthLineAnim / 2.0;
            double rangeEnd = 0.5 + widthLineAnim / 2.0;
            WireRenderingHelper.renderLines((class_4588)vertexConsumer, (class_243)cameraPos, (class_243)rect.position(), (class_243[])new class_243[]{new PortalLocalXYNormalized(rangeStart, -padding2).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, -padding2).getOffset(rect), new PortalLocalXYNormalized(rangeStart, 1.0 + padding2).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, 1.0 + padding2).getOffset(rect), new PortalLocalXYNormalized(rangeStart, -padding1).getOffset(rect), new PortalLocalXYNormalized(rangeStart, -padding2).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, -padding1).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, -padding2).getOffset(rect), new PortalLocalXYNormalized(rangeStart, 1.0 + padding1).getOffset(rect), new PortalLocalXYNormalized(rangeStart, 1.0 + padding2).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, 1.0 + padding1).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, 1.0 + padding2).getOffset(rect), new PortalLocalXYNormalized(0.5, -padding2).getOffset(rect), new PortalLocalXYNormalized(0.5, -padding3).getOffset(rect), new PortalLocalXYNormalized(0.5, 1.0 + padding2).getOffset(rect), new PortalLocalXYNormalized(0.5, 1.0 + padding3).getOffset(rect)}, (double)1.0, (DQuaternion)DQuaternion.identity, (int)-16516018, (class_4587)matrixStack);
        }
        if ((heightLineAnim = (Double)renderedHeightLineSegment.getCurrent()) != null && heightLineAnim > 0.001) {
            double rangeStart = 0.5 - heightLineAnim / 2.0;
            double rangeEnd = 0.5 + heightLineAnim / 2.0;
            WireRenderingHelper.renderLines((class_4588)vertexConsumer, (class_243)cameraPos, (class_243)rect.position(), (class_243[])new class_243[]{new PortalLocalXYNormalized(-padding2, rangeStart).getOffset(rect), new PortalLocalXYNormalized(-padding2, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding2, rangeStart).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding2, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(-padding1, rangeStart).getOffset(rect), new PortalLocalXYNormalized(-padding2, rangeStart).getOffset(rect), new PortalLocalXYNormalized(-padding1, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(-padding2, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding1, rangeStart).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding2, rangeStart).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding1, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding2, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(-padding2, 0.5).getOffset(rect), new PortalLocalXYNormalized(-padding3, 0.5).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding2, 0.5).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding3, 0.5).getOffset(rect)}, (double)1.0, (DQuaternion)DQuaternion.identity, (int)-198653, (class_4587)matrixStack);
        }
        matrixStack.method_22909();
    }

    private static PortalCorner getClosestCorner(Portal portal, class_243 hitPos) {
        return Arrays.stream(PortalCorner.values()).min(Comparator.comparingDouble(corner -> corner.getPos(portal).method_1022(hitPos))).orElseThrow();
    }

    private static void updateDraggedPortalAnimation() {
        class_243 currentCursor;
        if (draggingContext == null) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        RenderedPoint renderedCursor = (RenderedPoint)cursor.getCurrent();
        assert (renderedCursor != null);
        class_243 class_2432 = currentCursor = renderedCursor.pos() == null ? null : (class_243)renderedCursor.pos().value();
        if (currentCursor == null) {
            return;
        }
        Portal selectedPortal = ClientPortalWandPortalDrag.getSelectedPortal();
        if (selectedPortal == null) {
            return;
        }
        UnilateralPortalState newState = PortalWandInteraction.applyDrag(draggingContext.originalPortalState().getThisSideState(), currentCursor, ClientPortalWandPortalDrag.draggingContext.draggingInfo, false);
        if (PortalWandInteraction.validateDraggedPortalState(draggingContext.originalPortalState(), newState, (class_1657)player)) {
            PortalState newFullState = draggingContext.originalPortalState().withThisSideUpdated(newState, ClientPortalWandPortalDrag.draggingContext.draggingInfo.shouldLockScale());
            selectedPortal.setPortalState(newFullState);
            selectedPortal.rectifyClusterPortals(false);
        }
    }

    @Nullable
    private static PortalState getAnimationEndingState() {
        class_243 cursorTarget;
        if (draggingContext == null) {
            return null;
        }
        Portal portal = WandUtil.getClientPortalByUUID(draggingContext.portalId());
        if (portal == null) {
            return null;
        }
        RenderedPoint renderedCursorTarget = (RenderedPoint)cursor.getTarget();
        assert (renderedCursorTarget != null);
        class_243 class_2432 = cursorTarget = renderedCursorTarget.pos() == null ? null : (class_243)renderedCursorTarget.pos().value();
        if (cursorTarget == null) {
            return null;
        }
        UnilateralPortalState newThisSide = PortalWandInteraction.applyDrag(draggingContext.originalPortalState().getThisSideState(), cursorTarget, draggingContext.draggingInfo(), false);
        if (newThisSide == null) {
            return null;
        }
        return draggingContext.originalPortalState().withThisSideUpdated(newThisSide, draggingContext.draggingInfo().shouldLockScale());
    }

    static {
        lockWidth = false;
        lockHeight = false;
        cursor = new Animated(Animated.RENDERED_POINT_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)RenderedPoint.EMPTY);
        renderedRect = new Animated(UnilateralPortalState.ANIMATION_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), null);
        renderedPlane = new Animated(Animated.RENDERED_PLANE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)RenderedPlane.NONE);
        renderedLockedAnchor = new Animated(Animated.RENDERED_POINT_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.circle).mapProgress(arg_0), (Object)RenderedPoint.EMPTY);
        renderedWidthLineSegment = new Animated(Animated.DOUBLE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)0.0);
        renderedHeightLineSegment = new Animated(Animated.DOUBLE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)0.0);
        renderedWidthLock = new Animated(Animated.DOUBLE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)0.0);
        renderedHeightLock = new Animated(Animated.DOUBLE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)0.0);
        isUndoing = false;
    }

    private record SelectionStatus(PortalLocalXYNormalized selectedAnchor, boolean selectsHorizontalEdge, boolean selectsVerticalEdge) {
    }

    private record DraggingContext(class_5321<class_1937> dimension, @NotNull UUID portalId, @Nullable Plane limitingPlane, @Nullable Sphere limitingSphere, PortalWandInteraction.DraggingInfo draggingInfo, @Nullable class_5250 planeText, PortalState originalPortalState) {
    }
}

