/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import java.util.Arrays;
import java.util.Comparator;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.mc_utils.WireRenderingHelper;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalUtils;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.peripheral.ImmPtlCustomOverlay;
import qouteall.imm_ptl.peripheral.wand.WandUtil;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.AARotation;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.WithDim;
import qouteall.q_misc_util.my_util.animation.Animated;
import qouteall.q_misc_util.my_util.animation.RenderedPoint;

@Environment(value=EnvType.CLIENT)
public class ClientPortalWandPortalCopy {
    @NotNull
    private static Status status = new Status_SelectPortal();
    public static Animated<RenderedPoint> cursor = new Animated(Animated.RENDERED_POINT_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)RenderedPoint.EMPTY);
    public static Animated<UnilateralPortalState> selection = new Animated(UnilateralPortalState.ANIMATION_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), null);
    public static Animated<DQuaternion> placementOrientation = new Animated(Animated.QUATERNION_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)DQuaternion.identity);
    public static Animated<Double> placementOffsetLen = new Animated(Animated.DOUBLE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)0.0);
    private static final int colorOfCursor = -16515844;
    private static final int colorOfSelection1 = -11337838;
    private static final int colorOfSelection2 = -224451;
    private static final int colorOfPendingPlacement1 = -16711681;
    private static final int colorOfPendingPlacement2 = -2339841;

    public static void reset() {
        status = new Status_SelectPortal();
        cursor.clearTarget();
        selection.clearTarget();
        placementOrientation.clearTarget();
        placementOffsetLen.clearTarget();
    }

    public static void updateDisplay() {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return;
        }
        class_243 eyePos = player.method_5836(RenderStates.getPartialTick());
        class_243 viewVec = player.method_5720();
        Status status = ClientPortalWandPortalCopy.status;
        if (status instanceof Status_SelectPortal) {
            Status_SelectPortal statusSelectPortal = (Status_SelectPortal)status;
            cursor.clearTarget();
            rayTraceResult = PortalUtils.lenientRayTracePortals((class_1937)player.method_37908(), (class_243)eyePos, (class_243)eyePos.method_1019(viewVec.method_1021(64.0)), (boolean)false, p -> true, (double)1.0).orElse(null);
            if (rayTraceResult != null) {
                Portal portal = (Portal)rayTraceResult.getFirst();
                selection.setTarget((Object)portal.getThisSideState(), Helper.secondToNano((double)0.5));
                statusSelectPortal.selectedPortalId = portal.method_5667();
                ImmPtlCustomOverlay.putText((class_2561)class_2561.method_43469((String)"imm_ptl.wand.copy.prompt.copy_or_cut", (Object[])new Object[]{class_310.method_1551().field_1690.field_1904.method_16007(), class_310.method_1551().field_1690.field_1886.method_16007()}));
            } else {
                selection.clearTarget();
                statusSelectPortal.selectedPortalId = null;
                ImmPtlCustomOverlay.putText((class_2561)class_2561.method_43471((String)"imm_ptl.wand.copy.prompt.select_portal"));
            }
        } else {
            rayTraceResult = ClientPortalWandPortalCopy.status;
            if (rayTraceResult instanceof Status_PlacingPortal) {
                UnilateralPortalState placement;
                class_243 preCursorPos;
                Status_PlacingPortal statusPlacingPortal = (Status_PlacingPortal)rayTraceResult;
                selection.clearTarget();
                class_239 hitResult = player.method_5745(64.0, RenderStates.getPartialTick(), false);
                int alignment = IPConfig.getConfig().portalWandCursorAlignment;
                if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
                    class_3965 blockHitResult = (class_3965)hitResult;
                    preCursorPos = blockHitResult.method_17784();
                } else {
                    preCursorPos = eyePos.method_1019(viewVec.method_1021(5.0));
                }
                class_243 cursorPointing = WandUtil.alignOnBlocks(player.method_37908(), preCursorPos, alignment);
                cursor.setTarget((Object)new RenderedPoint(new WithDim(player.method_37908().method_27983(), (Object)cursorPointing), 1.0), Helper.secondToNano((double)0.5));
                DQuaternion camRotInverse = TransformationManager.getPlayerCameraRotation().getConjugated();
                AARotation orientationRot = Arrays.stream(AARotation.values()).min(Comparator.comparingDouble(r -> DQuaternion.distance((DQuaternion)r.quaternion, (DQuaternion)camRotInverse))).orElseThrow();
                DQuaternion orientation = orientationRot.quaternion;
                PlacementRequirement req = statusPlacingPortal.placementRequirement;
                boolean isFacingUpOrDown = player.method_36455() > 45.0f || player.method_36455() < -45.0f;
                double offsetLen = isFacingUpOrDown ? 0.0 : req.height() / 2.0;
                class_243 offset = orientation.rotate(new class_243(0.0, offsetLen, 0.0));
                class_243 placementOrigin = cursorPointing.method_1019(offset);
                statusPlacingPortal.pendingPlacement = placement = new UnilateralPortalState(player.method_37908().method_27983(), placementOrigin, orientation, req.width(), req.height());
                placementOrientation.setTarget((Object)orientation, Helper.secondToNano((double)0.5));
                placementOffsetLen.setTarget((Object)offsetLen, Helper.secondToNano((double)0.5));
                ImmPtlCustomOverlay.putText((class_2561)class_2561.method_43469((String)"imm_ptl.wand.copy.prompt.place_portal", (Object[])new Object[]{class_310.method_1551().field_1690.field_1904.method_16007(), class_310.method_1551().field_1690.field_1886.method_16007()}));
            } else {
                throw new RuntimeException();
            }
        }
    }

    public static void onLeftClick() {
        Status status = ClientPortalWandPortalCopy.status;
        if (status instanceof Status_SelectPortal) {
            Portal portal;
            Status_SelectPortal statusSelectPortal = (Status_SelectPortal)status;
            if (statusSelectPortal.selectedPortalId != null && (portal = WandUtil.getClientPortalByUUID(statusSelectPortal.selectedPortalId)) != null) {
                ClientPortalWandPortalCopy.status = new Status_PlacingPortal(new PlacementRequirement(portal.width, portal.height), true);
                McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.copyCutPortal", (Object[])new Object[]{statusSelectPortal.selectedPortalId, true});
            }
        } else {
            status = ClientPortalWandPortalCopy.status;
            if (status instanceof Status_PlacingPortal) {
                Status_PlacingPortal statusPlacingPortal = (Status_PlacingPortal)status;
                McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.clearPortalClipboard", (Object[])new Object[0]);
                ClientPortalWandPortalCopy.status = new Status_SelectPortal();
            }
        }
    }

    public static void onRightClick() {
        Status status = ClientPortalWandPortalCopy.status;
        if (status instanceof Status_SelectPortal) {
            Portal portal;
            Status_SelectPortal statusSelectPortal = (Status_SelectPortal)status;
            if (statusSelectPortal.selectedPortalId != null && (portal = WandUtil.getClientPortalByUUID(statusSelectPortal.selectedPortalId)) != null) {
                ClientPortalWandPortalCopy.status = new Status_PlacingPortal(new PlacementRequirement(portal.width, portal.height), false);
                McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.copyCutPortal", (Object[])new Object[]{statusSelectPortal.selectedPortalId, false});
            }
        } else {
            status = ClientPortalWandPortalCopy.status;
            if (status instanceof Status_PlacingPortal) {
                Status_PlacingPortal statusPlacingPortal = (Status_PlacingPortal)status;
                if (statusPlacingPortal.pendingPlacement != null) {
                    McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.confirmCopyCut", (Object[])new Object[]{statusPlacingPortal.pendingPlacement.position(), statusPlacingPortal.pendingPlacement.orientation()});
                    ClientPortalWandPortalCopy.status = new Status_SelectPortal();
                }
            }
        }
    }

    public static void render(class_4587 matrixStack, class_4597.class_4598 bufferSource, double camX, double camY, double camZ) {
        Status status;
        UnilateralPortalState rect;
        WithDim posWithDim;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (PortalRendering.isRendering()) {
            return;
        }
        class_5321 currDim = player.method_37908().method_27983();
        class_243 cameraPos = new class_243(camX, camY, camZ);
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23594());
        class_243 cursorPos = null;
        RenderedPoint currentCursor = (RenderedPoint)cursor.getCurrent();
        if (currentCursor != null && (posWithDim = currentCursor.pos()) != null && posWithDim.dimension() == currDim) {
            cursorPos = (class_243)posWithDim.value();
        }
        if (cursorPos != null) {
            WireRenderingHelper.renderSmallCubeFrame((class_4588)vertexConsumer, (class_243)cameraPos, cursorPos, (int)-16515844, (double)((RenderedPoint)cursor.getCurrent()).scale(), (class_4587)matrixStack);
        }
        if ((rect = (UnilateralPortalState)selection.getCurrent()) != null && rect.dimension() == currDim) {
            WireRenderingHelper.renderRectFrameFlow((class_4587)matrixStack, (class_243)cameraPos, (class_4588)vertexConsumer, (UnilateralPortalState)rect, (int)-11337838, (int)-224451);
        }
        if ((status = ClientPortalWandPortalCopy.status) instanceof Status_PlacingPortal) {
            Status_PlacingPortal statusPlacingPortal = (Status_PlacingPortal)status;
            DQuaternion orientation = (DQuaternion)placementOrientation.getCurrent();
            Double offsetLen = (Double)placementOffsetLen.getCurrent();
            Validate.isTrue((orientation != null ? 1 : 0) != 0);
            Validate.isTrue((offsetLen != null ? 1 : 0) != 0);
            class_243 offset = orientation.rotate(new class_243(0.0, offsetLen.doubleValue(), 0.0));
            if (cursorPos != null) {
                PlacementRequirement req = statusPlacingPortal.placementRequirement;
                UnilateralPortalState placement = new UnilateralPortalState(currDim, cursorPos.method_1019(offset), orientation, req.width(), req.height());
                WireRenderingHelper.renderRectFrameFlow((class_4587)matrixStack, (class_243)cameraPos, (class_4588)vertexConsumer, (UnilateralPortalState)placement, (int)-16711681, (int)-2339841);
            }
        }
    }

    private static final class Status_SelectPortal
    implements Status {
        @Nullable
        public UUID selectedPortalId;

        private Status_SelectPortal() {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface Status {
    }

    private static final class Status_PlacingPortal
    implements Status {
        @NotNull
        public final PlacementRequirement placementRequirement;
        public final boolean isCut;
        @Nullable
        public UnilateralPortalState pendingPlacement;

        private Status_PlacingPortal(@NotNull PlacementRequirement placementRequirement, boolean isCut) {
            this.placementRequirement = placementRequirement;
            this.isCut = isCut;
        }
    }

    public record PlacementRequirement(double width, double height) {
    }
}

