/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.dim_stack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.VerticalConnectingPortal;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackEntry;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackGuiController;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackInfo;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.dimension.DimId;

public class DimStackManagement {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static DimStackInfo dimStackToApply = null;
    public static Map<class_5321<class_1937>, class_2680> bedrockReplacementMap = new HashMap<class_5321<class_1937>, class_2680>();

    public static void init() {
    }

    public static void onServerEarlyInit(MinecraftServer server) {
        HashMap<class_5321<class_1937>, class_2680> newMap = new HashMap<class_5321<class_1937>, class_2680>();
        if (dimStackToApply != null) {
            for (DimStackEntry entry : DimStackManagement.dimStackToApply.entries) {
                newMap.put(entry.getDimension(), DimStackInfo.parseBlockString(entry.bedrockReplacementStr));
            }
        }
        bedrockReplacementMap = newMap;
    }

    public static void onServerCreatedWorlds(MinecraftServer server) {
        DimStackManagement.applyDimStackPresetInDedicatedServer();
        if (dimStackToApply != null) {
            dimStackToApply.apply();
            dimStackToApply = null;
        } else {
            DimStackManagement.updateBedrockReplacementFromStorage(server);
        }
    }

    private static void applyDimStackPresetInDedicatedServer() {
        if (O_O.isDedicatedServer()) {
            DimStackInfo dimStackPreset = DimStackManagement.getDimStackPreset();
            if (dimStackPreset != null) {
                if (!DimStackManagement.hasDimStackPortal()) {
                    LOGGER.info("Applying dimension stack preset in dedicated server");
                    dimStackToApply = dimStackPreset;
                } else {
                    LOGGER.info("There are already dim stack portals, so the preset is not applied");
                }
            } else {
                LOGGER.info("The server has no dimension stack preset.");
            }
        }
    }

    private static void updateBedrockReplacementFromStorage(MinecraftServer server) {
        HashMap<class_5321<class_1937>, class_2680> newMap = new HashMap<class_5321<class_1937>, class_2680>();
        for (class_3218 world : server.method_3738()) {
            class_2680 replacement = GlobalPortalStorage.get((class_3218)world).bedrockReplacement;
            newMap.put((class_5321<class_1937>)world.method_27983(), replacement);
            Helper.log((Object)String.format("Bedrock Replacement %s %s", world.method_27983().method_29177(), replacement != null ? class_7923.field_41175.method_10221((Object)replacement.method_26204()) : "null"));
        }
        bedrockReplacementMap = newMap;
    }

    public static void upgradeLegacyDimensionStack(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            GlobalPortalStorage gps = GlobalPortalStorage.get((class_3218)world);
            gps.bedrockReplacement = class_2246.field_10540.method_9564();
            gps.onDataChanged();
        }
        DimStackManagement.updateBedrockReplacementFromStorage(server);
        Helper.log((Object)"Legacy Dimension Stack Upgraded");
    }

    public static void replaceBedrock(class_3218 world, class_2791 chunk) {
        if (bedrockReplacementMap == null) {
            Helper.err((Object)"Dimension Stack Bedrock Replacement Abnormal");
            return;
        }
        class_2680 replacement = bedrockReplacementMap.get(world.method_27983());
        if (replacement != null) {
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = chunk.method_31607(); y < chunk.method_31600(); ++y) {
                        mutable.method_10103(x, y, z);
                        class_2680 blockState = chunk.method_8320((class_2338)mutable);
                        if (blockState.method_26204() != class_2246.field_9987) continue;
                        chunk.method_12010((class_2338)mutable, replacement, false);
                    }
                }
            }
        }
    }

    public static boolean hasDimStackPortal() {
        MinecraftServer server = MiscHelper.getServer();
        for (class_3218 world : server.method_3738()) {
            GlobalPortalStorage gps = GlobalPortalStorage.get((class_3218)world);
            if (Helper.indexOf((List)gps.data, p -> p instanceof VerticalConnectingPortal) == -1) continue;
            return true;
        }
        return false;
    }

    private static void clearDimStackPortals() {
        MinecraftServer server = MiscHelper.getServer();
        for (class_3218 world : server.method_3738()) {
            GlobalPortalStorage gps = GlobalPortalStorage.get((class_3218)world);
            gps.data.removeIf(p -> p instanceof VerticalConnectingPortal);
            gps.bedrockReplacement = null;
            gps.onDataChanged();
        }
        DimStackManagement.updateBedrockReplacementFromStorage(server);
    }

    @Nullable
    public static DimStackInfo getDimStackPreset() {
        JsonObject json = IPConfig.getConfig().dimStackPreset;
        if (json == null) {
            return null;
        }
        try {
            DimStackInfo dimStackInfo = (DimStackInfo)IPGlobal.gson.fromJson((JsonElement)json, DimStackInfo.class);
            return dimStackInfo;
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse dimension stack preset JSON {}", (Object)json, (Object)e);
            return null;
        }
    }

    public static void setDimStackPreset(@Nullable DimStackInfo preset) {
        JsonObject json = null;
        if (preset != null) {
            json = IPGlobal.gson.toJsonTree((Object)preset).getAsJsonObject();
        }
        IPConfig config = IPConfig.getConfig();
        config.dimStackPreset = json;
        config.saveConfigFile();
    }

    public static class RemoteCallables {
        @Environment(value=EnvType.CLIENT)
        public static void clientOpenScreen(List<String> dimensions) {
            List dimensionList = dimensions.stream().map(DimId::idToKey).collect(Collectors.toList());
            DimStackGuiController controller = new DimStackGuiController(null, () -> dimensionList, dimStackInfo -> {
                if (dimStackInfo != null) {
                    McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement.RemoteCallables.serverSetupDimStack", (Object[])new Object[]{dimStackInfo});
                } else {
                    McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement.RemoteCallables.serverRemoveDimStack", (Object[])new Object[0]);
                }
                class_310.method_1551().method_1507(null);
            });
            controller.initializeAsDefault();
            class_310.method_1551().method_1507((class_437)controller.view);
        }

        public static void serverSetupDimStack(class_3222 player, DimStackInfo dimStackInfo) {
            if (!player.method_5687(2)) {
                Helper.err((Object)"one player without permission tries to change dimension stack");
                return;
            }
            DimStackManagement.clearDimStackPortals();
            dimStackInfo.apply();
            player.method_7353((class_2561)class_2561.method_43471((String)"imm_ptl.dim_stack_established"), false);
            if (O_O.isDedicatedServer()) {
                DimStackManagement.setDimStackPreset(dimStackInfo);
            }
        }

        public static void serverRemoveDimStack(class_3222 player) {
            if (!player.method_5687(2)) {
                Helper.err((Object)"one player without permission tries to change dimension stack");
                return;
            }
            DimStackManagement.clearDimStackPortals();
            player.method_7353((class_2561)class_2561.method_43471((String)"imm_ptl.dim_stack_removed"), false);
            if (O_O.isDedicatedServer()) {
                DimStackManagement.setDimStackPreset(null);
            }
        }
    }
}

